<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">111.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!-- Remove the parameter "contentManager" -->
	<xsl:template match="crn:parameter[@name='contentManager']"/>
	<!--============================================================================================================= 
	Move the parameter 'confidentialityAlgorithm' from CRYPTO to: CRYPTO/cryptoProvider/CognosCrypto or CRYPTO/cryptoProvider/Entrust 
	=============================================================================================================-->
	<!-- Remove the parameter 'confidentialityAlgorithm' from CRYPTO -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:parameter[@name='confidentialityAlgorithm']"/>
	<!-- Add new Confidentiality Algorithm parameter for CRYPTO/cryptoProvider/CognosCrypto or CRYPTO/cryptoProvider/Entrust -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:instances[@name='cryptoProvider']/crn:instance[@class='CognosCrypto' or @class='Entrust']/child::*[position() = 1]">
		<xsl:copy-of select="."/>
		<xsl:variable name="ca-value">
			<xsl:choose>
				<xsl:when test="../../../crn:parameter[@name='confidentialityAlgorithm']/crn:value != ''">
					<xsl:value-of select="../../../crn:parameter[@name='confidentialityAlgorithm']/crn:value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="../@class='CognosCrypto' and not (../crn:parameter[@name='cognosCryptoConfidentialityAlgorithm'])">
			<!-- For cognos crypto provider, copy the value -->
			<crn:parameter name="cognosCryptoConfidentialityAlgorithm">
				<crn:value xsi:type="xsd:string">
					<xsl:value-of select="$ca-value"/>
				</crn:value>
			</crn:parameter>
		</xsl:if>
		<xsl:if test="../@class='Entrust' and not (../crn:parameter[@name='entrustConfidentialityAlgorithm'])">
			<!-- For Entrust crypto provider, leave the value blank if the old value is "RC4' or 'RC4-40' since they are invalid now , otherwise copy the value -->
			<xsl:variable name="ent-value">
				<xsl:choose>
					<xsl:when test="$ca-value = 'RC4' or $ca-value = 'RC4-40'">
						<xsl:value-of select="''"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$ca-value"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<crn:parameter name="entrustConfidentialityAlgorithm">
				<crn:value xsi:type="xsd:string">
					<xsl:value-of select="$ent-value"/>
				</crn:value>
			</crn:parameter>
		</xsl:if>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
