<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">116.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!-- Update the content in CRYPTO/cryptoProvider/Entrust -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:instances[@name='cryptoProvider']/crn:instance[@class='Entrust']/child::*[position() = 1]">
		<!-- Add 2 new parameters: useEntrustServerLogin , identityFilePassword -->
		<xsl:copy-of select="."/>
		<xsl:if test="not (../crn:parameter[@name='useEntrustServerLogin'])">
			<crn:parameter name="useEntrustServerLogin">
				<crn:value xsi:type="xsd:boolean">true</crn:value>
			</crn:parameter>
		</xsl:if>
		<xsl:if test="not (../crn:parameter[@name='identityFilePassword'])">
			<!-- copy the value from 'signKeyFilePassword'-->
			<crn:parameter name="identityFilePassword">
				<xsl:choose>
					<xsl:when test="../crn:parameter[@name='signKeyFilePassword']/crn:value != ''">
						<xsl:copy-of select="../crn:parameter[@name='signKeyFilePassword']/crn:value"/>
					</xsl:when>
					<xsl:otherwise>
						<crn:value xsi:type="cfg:systemPassword"/>
					</xsl:otherwise>
				</xsl:choose>
			</crn:parameter>
		</xsl:if>
	</xsl:template>
	<!-- Remove 2 paramters from CRYPTO/cryptoProvider/Entrust : signKeyFilePassword, encryptKeyFilePassword -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:instances[@name='cryptoProvider']/crn:instance[@class='Entrust']/crn:parameter[@name='signKeyFilePassword']"/>
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:instances[@name='cryptoProvider']/crn:instance[@class='Entrust']/crn:parameter[@name='encryptKeyFilePassword']"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
