<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">118.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!-- Add 2 new parameters to CAF: caf_tpXSSCheckingUsed and caf_tpXSSChars -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CAF']/crn:value/child::*[position() = 1]">
		<xsl:copy-of select="."/>
		<xsl:if test="not (../crn:parameter[@name='caf_tpXSSCheckingUsed'])">
			<crn:parameter name="caf_tpXSSCheckingUsed">
				<crn:value xsi:type="xsd:boolean">false</crn:value>
			</crn:parameter>
		</xsl:if>
		<xsl:if test="not (../crn:parameter[@name='caf_tpXSSChars'])">
			<crn:parameter name="caf_tpXSSChars">
				<crn:value xsi:type="xsd:string">&lt;'&gt;</crn:value>
			</crn:parameter>
		</xsl:if>
	</xsl:template>
	<!-- Add a new parameterin CRYPTO/cryptoProvider/Entrust: entrustCiphersuite -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:instances[@name='cryptoProvider']/crn:instance[@class='Entrust']/child::*[position() = 1]">
		<xsl:copy-of select="."/>
		<xsl:if test="not (../crn:parameter[@name='entrustCiphersuite'])">
			<crn:parameter opaque="true" name="entrustCiphersuite">
				<crn:value xsi:type="cfg:sortedArray">
					<crn:item xsi:type="xsd:string" order="0">RSA-RSA-DES(168)CBC3-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="1">RSA-RSA-RC4(128)-MD5</crn:item>
					<crn:item xsi:type="xsd:string" order="2">RSA-RSA-RC4(128)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="3">RSA-RSA-IDEA(128)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="4">RSA-RSA-DES(56)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="5">RSA(1024)-RSA-DES(56)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="6">RSA(1024)-RSA-RC4(56)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="7">RSA(512)-RSA-DES(40)-MD5</crn:item>
					<crn:item xsi:type="xsd:string" order="8">RSA(512)-RSA-RC4(40)-MD5</crn:item>
				</crn:value>
			</crn:parameter>
		</xsl:if>
	</xsl:template>
	<!-- Add a new parameterin CRYPTO/cryptoProvider/CognosCrypto: cognosCryptoCiphersuite -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:instances[@name='cryptoProvider']/crn:instance[@class='CognosCrypto']/child::*[position() = 1]">
		<xsl:copy-of select="."/>
		<xsl:if test="not (../crn:parameter[@name='cognosCryptoCiphersuite'])">
			<crn:parameter opaque="true" name="cognosCryptoCiphersuite">
				<crn:value xsi:type="cfg:sortedArray">
					<crn:item xsi:type="xsd:string" order="0">RSA-RSA-DES(168)CBC3-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="1">RSA-RSA-AES(256)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="2">DH-RSA-AES(256)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="3">DH-RSA-DES(168)CBC3-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="4">RSA-RSA-AES(128)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="5">DH-RSA-AES(128)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="6">RSA-RSA-RC4(128)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="7">RSA-RSA-RC4(128)-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="8">RSA(1024)-RSA-DES(56)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="9">RSA-RSA-DES(56)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="10">DH-RSA-DES(56)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="11">RSA(512)-DES(40)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="12">DH(512)-RSA-DES(40)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="13">RSA(512)-RC4(40)-MD5</crn:item>
					<crn:item xsi:type="xsd:string" order="14">RSA-RSA-DES(56)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="15">DH-RSA-DES(56)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="16">RSA-RSA-DES(40)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="17">DH-RSA-DES(40)CBC-SHA</crn:item>
					<crn:item xsi:type="xsd:string" order="18">RSA-RSA-RC4(40)-MD5</crn:item>
				</crn:value>
			</crn:parameter>
		</xsl:if>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
