<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">131.0</xsl:attribute>
			<xsl:apply-templates/>
			<xsl:if test="not(./crn:parameter[@name='gatewayDispatcherURIList'])">
				<xsl:call-template name="addGatewayDispatcherURIList"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<!-- Add a new parameter: gatewayDispatcherURIList. Grab the value from externalDispatcher as default, if not present, keep empty so the user have to put some in.-->
	<xsl:template name="addGatewayDispatcherURIList">
		<xsl:variable name="disp_uri">
			<xsl:choose>
				<xsl:when test="/crn:parameters/crn:parameter[@name = 'externalDispatcher']">
					<xsl:value-of select="/crn:parameters/crn:parameter[@name = 'externalDispatcher']/crn:value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<crn:parameter name="gatewayDispatcherURIList" opaque="true">
			<crn:value xsi:type="cfg:sortedArray">
				<xsl:if test="not ($disp_uri = '')">
					<crn:item xsi:type="xsd:anyURI" order="0">
						<xsl:value-of select="$disp_uri"/>
					</crn:item>
				</xsl:if>
			</crn:value>
		</crn:parameter>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
