<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">136.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!--Replace the parameter "sdsIsEnabled" in CBS with two new parameters:jsIsEnabled, emIsEnabled-->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CBS']/crn:value/child::*[position() = 1]">
		<xsl:copy-of select="."/>
		<xsl:variable name="sds-value">
			<xsl:choose>
				<xsl:when test="../crn:parameter[@name='sdsIsEnabled'] and (../crn:parameter[@name='sdsIsEnabled']/crn:value != '')">
					<xsl:value-of select="../crn:parameter[@name='sdsIsEnabled']/crn:value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'true'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="not (../crn:parameter[@name='jsIsEnabled'])">
			<crn:parameter name="jsIsEnabled">
				<crn:value xsi:type="xsd:boolean">
					<xsl:value-of select="$sds-value"/>
				</crn:value>
			</crn:parameter>
		</xsl:if>
		<xsl:if test="not (../crn:parameter[@name='emIsEnabled'])">
			<crn:parameter name="emIsEnabled">
				<crn:value xsi:type="xsd:boolean">
					<xsl:value-of select="$sds-value"/>
				</crn:value>
			</crn:parameter>
		</xsl:if>
	</xsl:template>
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CBS']/crn:value/crn:parameter[@name='sdsIsEnabled']"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
