<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">152.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'formatSpecificationLocation']">
		<xsl:variable name="value_node" select="./crn:value/."/>
		<xsl:choose>
			<xsl:when test="(contains($value_node, '/configuration/crnformat.xml') and substring-after($value_node, '/configuration/crnformat.xml') = '')  or ( contains($value_node, '\configuration\crnformat.xml') and substring-after($value_node,'\configuration\crnformat.xml') = '') ">		
				<xsl:copy>
					<xsl:copy-of select="@*"/>
					<crn:value xsi:type="cfg:filePath">../configuration/cogformat.xml</crn:value>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:copy-of select="@*"/>
					<crn:value xsi:type="cfg:filePath"><xsl:value-of select="$value_node"/></crn:value>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'IPF']/crn:value/crn:instances[@name='appender']/crn:instance[@class='file']/crn:parameter[@name='appenderName']">
		<xsl:variable name="value_node" select="./crn:value/."/>
		<xsl:choose>
			<xsl:when test="(contains($value_node, '/logs/crnserver.log') and substring-after($value_node, '/logs/crnserver.logl') = '')  or ( contains($value_node, '\logs\crnserver.log') and substring-after($value_node,'\logs\crnserver.log') = '') ">		
				<xsl:copy>
					<xsl:copy-of select="@*"/>
					<crn:value xsi:type="cfg:filePath">../logs/cogserver.log</crn:value>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:copy-of select="@*"/>
					<crn:value xsi:type="cfg:filePath"><xsl:value-of select="$value_node"/></crn:value>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
