<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of cogstartup.xml -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">153.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>	
	<!--Remove  the parameter "controllerClientURI"-->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'controllerClientURI']"/>
	<!-- move the analystMaxSize node -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'PLANNING']/crn:value">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:copy-of select="/crn:parameters/crn:parameter[@name = 'PLANNING']/crn:value/crn:parameter[@name='Contributor']/crn:value/crn:parameter[@name='analystMaxSize']"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!--Remove  the parameter "analystMaxSize"-->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'PLANNING']/crn:value/crn:parameter[@name='Contributor']/crn:value/crn:parameter[@name='analystMaxSize']"/>
	<!-- rename maxConcurrentCalEngines to mddsMaxAceSessions -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'PLANNING']/crn:value/crn:parameter[@name='Contributor']/crn:value/crn:parameter[@name='maxConcurrentCalEngines']">
		<xsl:copy>
				<xsl:copy-of select="@*"/>
				<xsl:attribute name="name">mddsMaxAceSessions</xsl:attribute>
				<xsl:apply-templates/>
          </xsl:copy>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>