<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	BI and PM: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of COGSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">160.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CBS']/crn:value/crn:instances[@name = 'cbs'][crn:instance[@class = 'Small' or @class = 'Medium' or @class = 'Large']]">
		<!-- UPDATE the class -->
		<xsl:element name="crn:instances">
			<xsl:copy-of select="@*"/>
			<xsl:element name="crn:instance">
				<xsl:copy-of select="./crn:instance/@*"/>
				<xsl:attribute name="class">Tomcat</xsl:attribute>
				<xsl:copy-of select="./crn:instance[@class = 'Small' or @class = 'Medium' or @class = 'Large']/*"> </xsl:copy-of>
			</xsl:element>
		</xsl:element>
	</xsl:template>	
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|comment()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|comment()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
