<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	BI and PM: cclmcf

	(C) Copyright IBM Corp. 2013

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of COGSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">163.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: AAA/instances -->
	<xsl:template match="crn:parameter[@name = 'AAA']/crn:value//crn:parameter[@name='advancedProperties']">
		<xsl:copy>
    		<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
          <xsl:text>
          </xsl:text>
        <xsl:variable name="pattern">
			<xsl:value-of select="crn:value/crn:parameter[@name='multitenancy.TenantPattern']/crn:value/text()"/>
		</xsl:variable>
		<xsl:variable name="providerClass">
			<xsl:value-of select="crn:value/crn:parameter[@name='multitenancy.ITenantProvider']/crn:value/text()"/>
		</xsl:variable>
		<crn:parameter name="tenantIdMapping" opaque="true">
            <xsl:text>
            </xsl:text>
            <crn:value xsi:type="cfg:tenancyInfo">
              <xsl:text>
            	</xsl:text>
            	<xsl:choose>
					<xsl:when test="string-length($providerClass)!=0">
						<crn:item name="providerClass" xsi:type="xsd:string">
							<xsl:copy-of select="$providerClass"/>
						</crn:item>
					</xsl:when>
					<xsl:otherwise>
						<crn:item name="pattern" xsi:type="xsd:string">
							<xsl:copy-of select="$pattern"/>
						</crn:item>
					</xsl:otherwise>
				</xsl:choose>
            <xsl:text>
            	</xsl:text>
			</crn:value>
				<xsl:text>
          </xsl:text>
		</crn:parameter>
			<xsl:text>
          </xsl:text>
	</xsl:template>
	<xsl:template match="crn:parameter[@name = 'AAA']/crn:value//crn:parameter[@name='advancedProperties']/crn:value/crn:parameter[@name='multitenancy.TenantPattern']"/>
	<xsl:template match="crn:parameter[@name = 'AAA']/crn:value//crn:parameter[@name='advancedProperties']/crn:value/crn:parameter[@name='multitenancy.ITenantProvider']"/>
	
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|comment()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|comment()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
