<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	BI and PM: cclmcf

	(C) Copyright IBM Corp. 2014

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of COGSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">164.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	<!--Replace cbs Tomcat instance with WebSphereLiberty -->
	<xsl:template match="/crn:instances[@name='cbs']/crn:instance[@class='Tomcat']">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="@class">
		<xsl:attribute name="class">
			<xsl:choose>
				<xsl:when test=". = 'Tomcat'">
					<xsl:text>WebSphereLiberty</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="."/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:template>
	<!-- Remove shutdown port-->
	<xsl:template match="/crn:instances[@name='cbs']/crn:instance[@class='Tomcat']/crn:parameter[@name = 'shutdownPort']"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|comment()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|comment()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
