<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2017

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">167.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	
	<!-- Add advancedProperties 'directoryServerType' for builtin ApacheDS LDAP namespace in ReadyToRun install type -->	
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'LDAP']/crn:parameter[@name='advancedProperties']/crn:value/child::*[position() = 1]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<xsl:variable name="nsid" select="../../../crn:parameter[@name='id']/crn:value"/>
		<xsl:if test="$nsid = 'CognosEx'">
			<xsl:variable name="directoryServerType" select="name(../crn:parameter[@name='directoryServerType'])"/>			
			<xsl:if test="$directoryServerType != 'crn:parameter'">
				<xsl:element name="crn:parameter">
					<xsl:attribute name="name">directoryServerType</xsl:attribute>
					<xsl:element name="crn:value">
						<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
						<xsl:value-of select="'Netscape'"/>
					</xsl:element>
				</xsl:element>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
