<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2017

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of COGSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">168.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	
	<!-- Replace the AAA namespace type "OIDC" to "OIDC_BlueID" -->	
	<xsl:template match="/crn:instances[@name = 'authProvider']/crn:instance[@class = 'OIDC']">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="@class">
		<xsl:attribute name="class">
			<xsl:choose>
				<xsl:when test=". = 'OIDC'">
					<xsl:text>OIDC_BlueID</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="."/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:template>
	
	<!-- Update identityProviderType to "IBMid" for namespace "OIDC" -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class='OIDC']/crn:parameter[@name='identityProviderType']/crn:value/text()">
		<xsl:value-of select="'IBMid'"/>
	</xsl:template>
	
	<!-- Update default cogserver.log to cogaudit.log -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'IPF']/crn:value/crn:instances[@name = 'appender']/crn:instance[@class='file']/crn:parameter[@name='appenderName']/crn:value/text()">
		<xsl:choose>
			<xsl:when test=". = '../logs/cogserver.log'">
				<xsl:value-of select="'../logs/cogaudit.log'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
		
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|comment()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|comment()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
