<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2019

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of COGSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">171.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>	
	<!-- Start from Endor R2 release, the default crypto standard conformance change from "IBM Cognos" to "NIST_SP_800_131A". -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:parameter[@name = 'cryptoStandardConformance']/crn:value[text() = 'IBM_Cognos']">	    
		<crn:value xsi:type="xsd:string">NIST_SP_800_131A</crn:value>
	</xsl:template>	
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|comment()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|comment()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
