<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>

	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">34.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: AAA/authProvider/LDAP -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'LDAP']/child::*[position() = 1]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD userLookup -->
		<xsl:variable name="userLookupExists" select="name(../crn:parameter[@name='userLookup'])"/>
		<xsl:if test="$userLookupExists != 'crn:parameter'">
			<xsl:variable name="lookupPerfix" select="../crn:parameter[@name='userLookupPrefix']/crn:value"/>
			<xsl:variable name="lookupSuffix" select="../crn:parameter[@name='userLookupSuffix']/crn:value"/>
			<xsl:variable name="baseDN" select="../crn:parameter[@name='baseDN']/crn:value"/>
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">userLookup</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$baseDN = ''">
							<xsl:value-of select="concat(concat($lookupPerfix,'${userID}'), $lookupSuffix)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat(concat(concat($lookupPerfix,'${userID}'), $lookupSuffix), concat(',',$baseDN))"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD useExternalIdentity -->
		<xsl:variable name="useExternalIdentityExists" select="name(../crn:parameter[@name='useExternalIdentity'])"/>
		<xsl:if test="$useExternalIdentityExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">useExternalIdentity</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>false</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD externalIdentityMapping -->
		<xsl:variable name="externalIdentityMappingExists" select="name(../crn:parameter[@name='externalIdentityMapping'])"/>
		<xsl:if test="$externalIdentityMappingExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">externalIdentityMapping</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>${environment(&quot;REMOTE_USER&quot;)}</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD camidAttribute -->
		<xsl:variable name="camidAttributeExists" select="name(../crn:parameter[@name='camidAttribute'])"/>
		<xsl:if test="$camidAttributeExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">camidAttribute</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>dn</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD dataEncoding -->
		<xsl:variable name="dataEncodingExists" select="name(../crn:parameter[@name='dataEncoding'])"/>
		<xsl:if test="$dataEncodingExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">dataEncoding</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>UTF-8</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD accountPassword -->
		<xsl:variable name="accountPasswordExists" select="name(../crn:parameter[@name='accountPassword'])"/>
		<xsl:if test="$accountPasswordExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">accountPassword</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>userPassword</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- CHANGE THE DEFAULT PARAMETER OF: AAA/LDAP/folderObjectClass -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'LDAP']/crn:parameter[@name = 'folderObjectClass']">
		<xsl:variable name="currentValue" select="crn:value"/>
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:attribute name="name">folderObjectClass</xsl:attribute>
			<xsl:element name="crn:value">
				<xsl:choose>
					<xsl:when test="$currentValue = '*'">
						<xsl:variable name="newValue">organizationalunit</xsl:variable>
						<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
						<xsl:value-of select="$newValue"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="newValue" select="$currentValue"/>
						<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
						<xsl:value-of select="$newValue"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: AAA/authProvider/Series7 -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'Series7']/child::*[position() = 1]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD dataEncoding -->
		<xsl:variable name="dataEncodingExists" select="name(../crn:parameter[@name='dataEncoding'])"/>
		<xsl:if test="$dataEncodingExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">dataEncoding</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>UTF-8</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- CHANGE THE DEFAULT PARAMETER OF: AAA/Series7/CookieSecure -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'Series7']/crn:parameter[@name = 'CookieSecure']">
		<xsl:variable name="currentValue" select="crn:value"/>
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:attribute name="name">CookieSecure</xsl:attribute>
			<xsl:element name="crn:value">
				<xsl:choose>
					<xsl:when test="$currentValue = 'true'">
						<xsl:variable name="newValue">false</xsl:variable>
						<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>
						<xsl:value-of select="$newValue"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="newValue" select="$currentValue"/>
						<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>
						<xsl:value-of select="$newValue"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: CRYPTO -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/child::*[position() = 2]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD localCSK -->
		<xsl:variable name="localCSKExists" select="name(../crn:parameter[@name='localCSK'])"/>
		<xsl:if test="$localCSKExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">localCSK</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>true</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD CSKLifetime -->
		<xsl:variable name="CSKLifetimeExists" select="name(../crn:parameter[@name='CSKLifetime'])"/>
		<xsl:if test="$CSKLifetimeExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">CSKLifetime</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:long</xsl:attribute>365</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: CRYPTO/CognosCrypto -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:instances[@name = 'cryptoProvider']/crn:instance[@class = 'CognosCrypto']/child::*[position() = 1]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD thirdPartyCA -->
		<xsl:variable name="thirdPartyCAExists" select="name(../crn:parameter[@name='thirdPartyCA'])"/>
		<xsl:if test="$thirdPartyCAExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">thirdPartyCA</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>false</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- CHANGE THE DEFAULT PARAMETER OF: CRYPTO/confidentialityAlgorithm -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:parameter[@name = 'confidentialityAlgorithm']">
		<xsl:variable name="currentValue" select="crn:value"/>
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:attribute name="name">confidentialityAlgorithm</xsl:attribute>
			<xsl:element name="crn:value">
				<xsl:choose>
					<xsl:when test="$currentValue = 'RC2'">
						<xsl:variable name="newValue">RC2-40</xsl:variable>
						<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
						<xsl:value-of select="$newValue"/>
					</xsl:when>
					<xsl:when test="$currentValue = 'RC4'">
						<xsl:variable name="newValue">RC4-40</xsl:variable>
						<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
						<xsl:value-of select="$newValue"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="newValue" select="$currentValue"/>
						<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
						<xsl:value-of select="$newValue"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: parameters -->
	<xsl:template match="/crn:parameters/child::*[position() = 1]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD gatewayNamespace -->
		<xsl:variable name="gatewayNamespaceExists" select="name(../crn:parameter[@name='gatewayNamespace'])"/>
		<xsl:if test="$gatewayNamespaceExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">gatewayNamespace</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- get the value of the old dispatcher parameter -->
		<xsl:variable name="dispatcherValue" select="../crn:parameter[@name='dispatcher']/crn:value"/>
		<!-- ADD externalDispatcher -->
		<xsl:variable name="externalDispatcherExists" select="name(../crn:parameter[@name='externalDispatcher'])"/>
		<xsl:if test="$externalDispatcherExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">externalDispatcher</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:anyURI</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$dispatcherValue = '' or not(../crn:parameter[@name='dispatcher']/crn:value)">
							<xsl:text>http://localhost:9300/p2pd/servlet/dispatch</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$dispatcherValue"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD internalDispatcher -->
		<xsl:variable name="internalDispatcherExists" select="name(../crn:parameter[@name='internalDispatcher'])"/>
		<xsl:if test="$internalDispatcherExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">internalDispatcher</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:anyURI</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$dispatcherValue = '' or not(../crn:parameter[@name='dispatcher']/crn:value)">
							<xsl:text>http://localhost:9300/p2pd/servlet/dispatch</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$dispatcherValue"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD defaultFont -->
		<xsl:variable name="defaultFontExists" select="name(../crn:parameter[@name='defaultFont'])"/>
		<xsl:if test="$defaultFontExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">defaultFont</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:string</xsl:attribute>Andale WT</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD sortMemory -->
		<xsl:variable name="sortMemoryExists" select="name(../crn:parameter[@name='sortMemory'])"/>
		<xsl:if test="$sortMemoryExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">sortMemory</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:unsignedInt</xsl:attribute>4</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD FM -->
		<xsl:variable name="FMExists" select="name(../crn:parameter[@name='FM'])"/>
		<xsl:if test="$FMExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">FM</xsl:attribute>
				<xsl:attribute name="opaque">true</xsl:attribute>
				<xsl:element name="crn:value"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: parameters/CBS/Small -->
	<xsl:template name="cbsSmall" match="/crn:parameters/crn:parameter[@name = 'CBS']/crn:value/crn:instances[@name = 'cbs']/crn:instance[@class = 'Small']/child::*[position() = 1]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD shutdownPort -->
		<xsl:variable name="shutdownPortExists" select="name(../crn:parameter[@name='shutdownPort'])"/>
		<xsl:if test="$shutdownPortExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">shutdownPort</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:unsignedShort</xsl:attribute>9399</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: parameters/CBS/Medium -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CBS']/crn:value/crn:instances[@name = 'cbs']/crn:instance[@class = 'Medium']/child::*[position() = 1]" priority="4">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD shutdownPort -->
		<xsl:variable name="shutdownPortExists" select="name(../crn:parameter[@name='shutdownPort'])"/>
		<xsl:if test="$shutdownPortExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">shutdownPort</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:unsignedShort</xsl:attribute>9399</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: parameters/CBS/Large -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CBS']/crn:value/crn:instances[@name = 'cbs']/crn:instance[@class = 'Large']/child::*[position() = 1]" priority="4">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD shutdownPort -->
		<xsl:variable name="shutdownPortExists" select="name(../crn:parameter[@name='shutdownPort'])"/>
		<xsl:if test="$shutdownPortExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">shutdownPort</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:unsignedShort</xsl:attribute>9399</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: parameters/CBS -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CBS']/crn:value/child::*[position() = 1]">
		<!-- copy the first node, but apply templates before copying -->
		<xsl:copy>
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:copy>
		<!-- ADD cmIsEnabled -->
		<xsl:variable name="cmIsEnabledExists" select="name(../crn:parameter[@name='cmIsEnabled'])"/>
		<xsl:if test="$cmIsEnabledExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">cmIsEnabled</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>true</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD dispIsEnabled -->
		<xsl:variable name="dispIsEnabledExists" select="name(../crn:parameter[@name='dispIsEnabled'])"/>
		<xsl:if test="$dispIsEnabledExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">dispIsEnabled</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>true</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD sdsIsEnabled -->
		<xsl:variable name="sdsIsEnabledExists" select="name(../crn:parameter[@name='sdsIsEnabled'])"/>
		<xsl:if test="$sdsIsEnabledExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">sdsIsEnabled</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>true</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD warpIsEnabled -->
		<xsl:variable name="warpIsEnabledExists" select="name(../crn:parameter[@name='warpIsEnabled'])"/>
		<xsl:if test="$warpIsEnabledExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">warpIsEnabled</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>true</xsl:element>
			</xsl:element>
		</xsl:if>
		<!-- ADD xtscrnIsEnabled -->
		<xsl:variable name="xtscrnIsEnabledExists" select="name(../crn:parameter[@name='xtscrnIsEnabled'])"/>
		<xsl:if test="$xtscrnIsEnabledExists != 'crn:parameter'">
			<xsl:element name="crn:parameter">
				<xsl:attribute name="name">xtscrnIsEnabled</xsl:attribute>
				<xsl:element name="crn:value">
					<xsl:attribute name="xsi:type">xsd:boolean</xsl:attribute>true</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- delete AAA/LDAP/userLookupPrefix element -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'LDAP']/crn:parameter[@name = 'userLookupPrefix']"/>
	<!-- delete AAA/LDAP/userLookupSuffix element -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'LDAP']/crn:parameter[@name = 'userLookupSuffix']"/>
	<!-- delete CRYPTO/cipherSuitesLocation element -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:parameter[@name = 'cipherSuitesLocation']"/>
	<!-- delete CRYPTO/SSLInternalUsage element -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:parameter[@name = 'SSLInternalUsage']"/>
	<!-- delete CRYPTO/SSLExternalUsage element -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'CRYPTO']/crn:value/crn:parameter[@name = 'SSLExternalUsage']"/>
	<!-- delete dispatcher element -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'dispatcher']"/>
	<!-- delete IPF/enableServerSSL element -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'IPF']/crn:value/crn:parameter[@name = 'enableServerSSL']"/>
</xsl:stylesheet>
