/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance;

import com.ibm.cognos.conformance.CNFMCategoryInfo;
import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMConfiguration;
import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.CNFMParser;
import com.ibm.cognos.conformance.CNFMProductInfo;
import com.ibm.cognos.conformance.ICNFMChecking;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class CNFMChecking
implements ICNFMChecking {
    public abstract CNFMCheckResult validate(CNFMItemInfo var1, ArrayList<CNFMItemInfo> var2);

    public abstract CNFMItemInfo getVersionInfo();

    @Override
    public abstract String getCategory();

    @Override
    public CNFMCheckResult validate(String productName, String productVersion) {
        CNFMItemInfo osVer = this.getVersionInfo();
        String sproductName = CNFMConfiguration.getInstance().getProductName();
        String sproductVer = CNFMConfiguration.getInstance().getProductVersion();
        ArrayList<CNFMItemInfo> items = this.getMatchedCNFMItems(sproductName, sproductVer, this.getCategory());
        return this.validate(osVer, items);
    }

    @Override
    public CNFMCheckResult validate() {
        String productName = CNFMConfiguration.getInstance().getProductName();
        String productVer = CNFMConfiguration.getInstance().getProductVersion();
        return this.validate(productName, productVer);
    }

    public ArrayList<CNFMItemInfo> getMatchedCNFMItems(String productName, String productVersion, String category) {
        ArrayList<CNFMItemInfo> resultList = new ArrayList<CNFMItemInfo>();
        ArrayList<CNFMProductInfo> cnfmList = CNFMParser.getConformanceList();
        for (int i = 0; i < cnfmList.size(); ++i) {
            CNFMCategoryInfo catInfo;
            CNFMProductInfo prod = cnfmList.get(i);
            String prodName = prod.getProductName();
            String prodVer = prod.getProductVersion();
            if (prodName == null || !prodName.equalsIgnoreCase(productName) || productVersion != null && !productVersion.equalsIgnoreCase(prodVer) || (catInfo = this.getMatchedCategory(prod.getCategories(), category)) == null) continue;
            resultList.addAll(catInfo.getItems());
        }
        return resultList;
    }

    private CNFMCategoryInfo getMatchedCategory(ArrayList<CNFMCategoryInfo> categoryList, String category) {
        for (int i = 0; i < categoryList.size(); ++i) {
            CNFMCategoryInfo cat = categoryList.get(i);
            String catName = cat.getCategoryName();
            if (catName == null || !catName.equalsIgnoreCase(category)) continue;
            return cat;
        }
        return null;
    }

    protected boolean verifyVersionOutOfRange(CNFMItemInfo localInfo, CNFMItemInfo ceilingInfo, CNFMItemInfo floorInfo) {
        boolean result = false;
        if (localInfo == null || ceilingInfo == null && floorInfo == null) {
            return false;
        }
        if (ceilingInfo != null && this.propertiesOutOfRangeMatch(localInfo.getVersionRelease(), ceilingInfo.getVersionRelease(), "ceiling")) {
            return true;
        }
        if (floorInfo != null && this.propertiesOutOfRangeMatch(localInfo.getVersionRelease(), floorInfo.getVersionRelease(), "floor")) {
            return true;
        }
        return result;
    }

    protected boolean propertiesOutOfRangeMatch(String localRelease, String confRelease, String flag) {
        try {
            StringTokenizer localTokens = new StringTokenizer(localRelease, ".");
            StringTokenizer confTokens = new StringTokenizer(confRelease, ".");
            int iLocalVer = 0;
            int iConfVer = 0;
            for (int idx = 0; (localTokens.hasMoreTokens() || confTokens.hasMoreTokens()) && idx < 2; ++idx) {
                iLocalVer = 0;
                iConfVer = 0;
                if (localTokens.hasMoreTokens()) {
                    iLocalVer = Integer.parseInt(localTokens.nextToken());
                }
                if (!confTokens.hasMoreTokens()) continue;
                iConfVer = Integer.parseInt(confTokens.nextToken());
                if (iLocalVer == iConfVer) continue;
                if (!flag.equalsIgnoreCase("ceiling")) continue;
                if (iLocalVer <= iConfVer) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

