/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n.ui;

import com.ibm.icu.text.BreakIterator;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import javax.swing.text.WrappedPlainView;

public class I18NWrappedPlainView
extends WrappedPlainView {
    int tabBase;
    boolean m_wordWrap;
    BreakIterator breakIterator;

    public I18NWrappedPlainView(Element elem) {
        super(elem);
        this.m_wordWrap = true;
        try {
            this.breakIterator = BreakIterator.getWordInstance((Locale)Locale.getDefault());
        }
        catch (MissingResourceException e) {
            this.breakIterator = BreakIterator.getWordInstance((Locale)Locale.ENGLISH);
        }
    }

    public I18NWrappedPlainView(Element elem, boolean wordWrap) {
        super(elem, wordWrap);
        this.m_wordWrap = wordWrap;
        Locale locale = Locale.getDefault();
        if (this.m_wordWrap) {
            try {
                this.breakIterator = BreakIterator.getWordInstance((Locale)locale);
            }
            catch (MissingResourceException e) {
                this.breakIterator = BreakIterator.getWordInstance((Locale)Locale.ENGLISH);
            }
        } else {
            try {
                this.breakIterator = BreakIterator.getCharacterInstance((Locale)locale);
            }
            catch (MissingResourceException e) {
                this.breakIterator = BreakIterator.getCharacterInstance((Locale)Locale.ENGLISH);
            }
        }
    }

    public I18NWrappedPlainView(Element elem, boolean wordWrap, Locale locale) {
        super(elem, wordWrap);
        this.m_wordWrap = wordWrap;
        if (this.m_wordWrap) {
            try {
                this.breakIterator = BreakIterator.getWordInstance((Locale)locale);
            }
            catch (MissingResourceException e) {
                this.breakIterator = BreakIterator.getWordInstance((Locale)Locale.ENGLISH);
            }
        } else {
            try {
                this.breakIterator = BreakIterator.getCharacterInstance((Locale)locale);
            }
            catch (MissingResourceException e) {
                this.breakIterator = BreakIterator.getCharacterInstance((Locale)Locale.ENGLISH);
            }
        }
    }

    @Override
    protected int calculateBreakPosition(int p0, int p1) {
        Segment lineBuffer = new Segment();
        Container host = this.getContainer();
        Font f = host.getFont();
        FontMetrics metrics = host.getFontMetrics(f);
        try {
            Document doc = this.getDocument();
            doc.getText(p0, p1 - p0, lineBuffer);
        }
        catch (BadLocationException bl) {
            throw new Error("Can't get line text");
        }
        char[] txt = lineBuffer.array;
        int txtOffset = lineBuffer.offset;
        int txtCount = lineBuffer.count;
        String text = new String(txt, txtOffset, txtCount);
        this.breakIterator.setText(text);
        int index = Utilities.getTabbedTextOffset(lineBuffer, metrics, this.tabBase, this.tabBase + this.getWidth(), this, p0);
        if (index == text.length()) {
            return text.length() + p0;
        }
        int newIndex = 0;
        if (this.breakIterator.current() != -1) {
            int textEndIndex = Math.min(index, txtCount - 1);
            if (textEndIndex < text.length()) {
                newIndex = this.breakIterator.preceding(textEndIndex);
            }
            if (newIndex <= 0) {
                newIndex = this.breakIterator.following(textEndIndex);
            }
        }
        if (newIndex == -1) {
            newIndex = 0;
        }
        if (text.length() > 0) {
            char lastChar;
            if (newIndex > text.length() - 1) {
                newIndex = text.length() - 1;
            }
            if (!Character.isSpaceChar(lastChar = text.charAt(newIndex))) {
                if (newIndex > 0) {
                    --newIndex;
                }
                if (!Character.isSpaceChar(lastChar = text.charAt(newIndex))) {
                    if (newIndex < text.length() - 1) {
                        ++newIndex;
                    }
                    lastChar = text.charAt(newIndex);
                }
            }
            while (Character.isSpaceChar(lastChar) && newIndex < text.length() - 1) {
                newIndex = !Character.isWhitespace(lastChar) ? this.breakIterator.following(newIndex) : ++newIndex;
                lastChar = text.charAt(newIndex);
            }
            boolean isPunctuation = this.charIsPunctuation(lastChar);
            if (!this.m_wordWrap) {
                boolean belongsToCJK = this.charIsCJK(lastChar);
                while (!belongsToCJK && !Character.isWhitespace(lastChar) && newIndex > 0) {
                    lastChar = text.charAt(--newIndex);
                    isPunctuation = this.charIsPunctuation(lastChar);
                    belongsToCJK = this.charIsCJK(lastChar);
                }
            }
            while (isPunctuation && newIndex < text.length() - 1) {
                lastChar = text.charAt(++newIndex);
                while (Character.isSpaceChar(lastChar) && newIndex < text.length() - 1) {
                    newIndex = !Character.isWhitespace(lastChar) ? this.breakIterator.following(newIndex) : ++newIndex;
                    lastChar = text.charAt(newIndex);
                }
                isPunctuation = this.charIsPunctuation(lastChar);
            }
        }
        if (newIndex == 0) {
            return super.calculateBreakPosition(p0, p1);
        }
        return newIndex + p0;
    }

    boolean charIsPunctuation(char character) {
        int charType = Character.getType(character);
        return charType == 23 || charType == 20 || charType == 22 || charType == 24;
    }

    boolean charIsCJK(char character) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(character);
        return unicodeBlock != null && (unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.KANBUN || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || unicodeBlock == Character.UnicodeBlock.BOPOMOFO || unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA);
    }
}

