/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.i18n.util;

import com.cognos.i18n.ToolkitResources;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class Bidi {
    private static final String LRM = "\u200e";
    private static final String RLM = "\u200f";
    private static final String LRE = "\u202a";
    private static final String RLE = "\u202b";
    private static final String PDF = "\u202c";
    private static final String DIR_RTL = "rtl";
    private static final String DIR_LTR = "ltr";
    private static HashMap<String, ISTTParser> map = new HashMap();

    public static boolean isLocaleRTL(String locale) {
        if (locale != null && locale.length() > 1) {
            String normalizedLocaleID = ToolkitResources.normalizeLocaleIdentifier(locale);
            List<String> rtlLocales = ToolkitResources.getRTLLocales();
            return rtlLocales.contains(normalizedLocaleID);
        }
        return false;
    }

    public static boolean isLocaleRTL(Locale locale) {
        if (locale != null) {
            return Bidi.isLocaleRTL(locale.toString());
        }
        return false;
    }

    public static boolean isRTLText(String text, String locale) {
        for (int i = 0; i < text.length(); ++i) {
            if (Bidi.isBidiChar(text.charAt(i))) {
                return true;
            }
            if (!Bidi.isLatinChar(text.charAt(i))) continue;
            return false;
        }
        return Bidi.isLocaleRTL(locale);
    }

    private static boolean isBidiChar(char c) {
        if (c >= '\u05d0' && c <= '\u05ff') {
            return true;
        }
        if (c >= '\u0600' && c <= '\u065f') {
            return true;
        }
        if (c >= '\u066a' && c <= '\u06ef') {
            return true;
        }
        if (c >= '\u06fa' && c <= '\u07ff') {
            return true;
        }
        if (c >= '\ufb1d' && c <= '\ufdff') {
            return true;
        }
        return c >= '\ufe70' && c <= '\ufefc';
    }

    private static boolean isArabicChar(char c) {
        if (c >= '\u0600' && c <= '\u065f') {
            return true;
        }
        if (c >= '\u066a' && c <= '\u06ef') {
            return true;
        }
        if (c >= '\u06fa' && c <= '\u07ff') {
            return true;
        }
        return c >= '\ufe70' && c <= '\ufefc';
    }

    private static boolean isLatinChar(char c) {
        return c > '@' && c < '[' || c > '`' && c < '{';
    }

    public static String getBTD(String text, String btd, String locale) {
        if (btd.equals(DIR_LTR) || btd.equals(DIR_RTL)) {
            return btd;
        }
        return Bidi.isRTLText(text, locale) ? DIR_RTL : DIR_LTR;
    }

    public static String enforceBTD(String text, String btd, String locale) {
        String dir = Bidi.getBTD(text, btd, locale);
        if (dir.equals(DIR_RTL)) {
            return RLE + text + PDF;
        }
        return LRE + text + PDF;
    }

    public static String enforceSegmentBTD(String text, String btd, String locale) {
        String txt = Bidi.enforceBTD(text, btd, locale);
        if (Bidi.isLocaleRTL(locale)) {
            return RLM + txt + RLM;
        }
        return LRM + txt + LRM;
    }

    public static String handleBidiFraction(String text, boolean isRtl) {
        int delimiterIndex = -1;
        int digitIndex = -1;
        int start = 0;
        String fractionDelimiter = "/";
        StringBuffer buffer = new StringBuffer(text);
        char startMarker = isRtl ? RLE.charAt(0) : LRE.charAt(0);
        while ((delimiterIndex = buffer.indexOf(fractionDelimiter, start)) > 0) {
            boolean correctFraction = Bidi.isBidiFraction(buffer.charAt(delimiterIndex - 1), buffer.charAt(delimiterIndex + 1));
            if (correctFraction) {
                buffer.insert(delimiterIndex, RLM);
                for (digitIndex = delimiterIndex - 2; digitIndex >= 0 && Character.isDigit(buffer.charAt(digitIndex)); --digitIndex) {
                }
                buffer.insert(digitIndex + 1, startMarker);
                for (digitIndex = delimiterIndex + 4; digitIndex < buffer.length() && Character.isDigit(buffer.charAt(digitIndex)); ++digitIndex) {
                }
                buffer.insert(digitIndex, PDF);
            } else {
                digitIndex = delimiterIndex + 1;
            }
            if (digitIndex + 2 >= buffer.length() - 2) break;
            start = digitIndex + 2;
        }
        return buffer.toString();
    }

    private static boolean isBidiFraction(char num, char den) {
        boolean isBidiFraction = false;
        if (num >= '\u0660' && num <= '\u0669' && den >= '\u0660' && den <= '\u0669') {
            return true;
        }
        return isBidiFraction;
    }

    public static String sttInjectUCCIntoStr(String text, String sttType) {
        if (text == null || sttType == null || text.length() < 2) {
            return text;
        }
        if ((sttType.equals("email") || sttType.equals("multiemail")) && Bidi.isArabicText(text)) {
            return Bidi.handle_ArabicEmail_Static(text);
        }
        ISTTParser parser = map.get(sttType);
        if (parser != null) {
            return parser.parse(text);
        }
        return text;
    }

    private static boolean isArabicText(String text) {
        if (text == null) {
            return false;
        }
        int length = text.length();
        if (length < 1) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Bidi.isArabicChar(c)) {
                return true;
            }
            if (!Bidi.isBidiChar(c)) continue;
            return false;
        }
        return false;
    }

    public static String enforceSTT(String text, String sttType) {
        String stText = Bidi.sttInjectUCCIntoStr(text, sttType);
        return LRE + stText + PDF;
    }

    public static String enforceSegmentSTT(String text, String sttType, String locale) {
        String txt = Bidi.enforceSTT(text, sttType);
        if (Bidi.isLocaleRTL(locale)) {
            return RLM + txt + RLM;
        }
        return LRM + txt + LRM;
    }

    private static boolean isCharBeforeBiDiChar(String text, int i, int previous) {
        while (i > 0) {
            byte classifier;
            if (i == previous) {
                return false;
            }
            if ((classifier = Character.getDirectionality(text.charAt(--i))) == 2 || classifier == 1) {
                return true;
            }
            if (classifier != 0) continue;
            return false;
        }
        return false;
    }

    private static String handle_ArabicEmail_Static(String str) {
        int length = str.length();
        if (str != null && length > 0) {
            int cPosition = 0;
            String result = "";
            String separators = ";,";
            boolean lastCharIsSeparator = false;
            while (cPosition < length) {
                int nextSeparatorIndex = Bidi.nextSeparator(str, cPosition);
                String mail = str.substring(cPosition, nextSeparatorIndex);
                String dir = Bidi.getArabicEmailDirection(mail);
                if (nextSeparatorIndex < length - 1) {
                    result = result + Bidi.handle_ArabicSingleEmail(mail, dir) + str.charAt(nextSeparatorIndex);
                } else {
                    lastCharIsSeparator = separators.indexOf(str.charAt(nextSeparatorIndex)) > -1;
                    if (lastCharIsSeparator) {
                        result = result + Bidi.handle_ArabicSingleEmail(mail, dir) + str.charAt(nextSeparatorIndex);
                    } else {
                        mail = mail + str.charAt(nextSeparatorIndex);
                        result = result + Bidi.handle_ArabicSingleEmail(mail, dir);
                    }
                }
                cPosition = nextSeparatorIndex + 1;
            }
            return result;
        }
        return str;
    }

    private static String handle_ArabicSingleEmail(String sttString, String dir) {
        String cEmbeding;
        String cMarker;
        String resultStr = "";
        int lastDelimiterIndex = -1;
        boolean isLastRTL = false;
        boolean isLastLTR = false;
        String mailDelimiters = "@.<>";
        String cEmailDir = null;
        int length = sttString.length();
        cEmailDir = dir;
        if (cEmailDir == DIR_RTL) {
            cMarker = RLM;
            cEmbeding = RLE;
        } else {
            cMarker = LRM;
            cEmbeding = LRE;
        }
        if (length > 0 && mailDelimiters.length() > 0) {
            for (int i = 0; i < length; ++i) {
                char chrCode = sttString.charAt(i);
                char chr = sttString.charAt(i);
                if (mailDelimiters.indexOf(chr) != -1) {
                    if (cEmailDir == DIR_LTR && isLastRTL || cEmailDir == DIR_RTL && isLastLTR) {
                        lastDelimiterIndex = resultStr.length();
                    }
                } else if (Bidi.isDigit(chrCode)) {
                    if (lastDelimiterIndex != -1) {
                        resultStr = resultStr.substring(0, lastDelimiterIndex) + cMarker + resultStr.substring(lastDelimiterIndex);
                        lastDelimiterIndex = -1;
                        isLastRTL = false;
                        isLastLTR = false;
                    }
                } else if (Bidi.isBidiChar(chrCode) || Bidi.isLTRChar(chrCode)) {
                    if (Bidi.isBidiChar(chrCode)) {
                        if (cEmailDir == DIR_LTR && lastDelimiterIndex != -1) {
                            resultStr = resultStr.substring(0, lastDelimiterIndex) + LRM + resultStr.substring(lastDelimiterIndex);
                            lastDelimiterIndex = -1;
                        }
                        isLastRTL = true;
                        isLastLTR = false;
                    } else {
                        if (cEmailDir == DIR_RTL && lastDelimiterIndex != -1) {
                            resultStr = resultStr.substring(0, lastDelimiterIndex) + RLM + resultStr.substring(lastDelimiterIndex);
                            lastDelimiterIndex = -1;
                        }
                        isLastLTR = true;
                        isLastRTL = false;
                    }
                }
                resultStr = resultStr + chr;
            }
            resultStr = cEmbeding + resultStr + PDF;
        }
        return resultStr;
    }

    private static int nextSeparator(String str, int start) {
        int nextComma = str.indexOf(44, start);
        int len = str.length();
        int nextSemiColon = str.indexOf(59, start);
        if (nextComma < 0) {
            nextComma = len - 1;
        }
        if (nextSemiColon < 0) {
            nextSemiColon = len - 1;
        }
        return Math.min(nextComma, nextSemiColon);
    }

    private static String getArabicEmailDirection(String email) {
        String domain = Bidi.getEmailDomain(email);
        if (domain == null) {
            return DIR_LTR;
        }
        if (Bidi.hasRTLText(domain)) {
            return DIR_RTL;
        }
        return DIR_LTR;
    }

    private static String getEmailDomain(String email) {
        if (email == null || email.indexOf(64) < 0) {
            return null;
        }
        String[] tmp = email.split("@");
        return tmp[1];
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9' || c >= '\u0660' && c <= '\u0669';
    }

    private static boolean isLTRChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '\u200e';
    }

    private static boolean hasRTLText(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Bidi.isBidiChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static {
        map.put("filepath", new FilepathParser());
        map.put("email", new EmailParser());
    }

    private static class EmailParser
    implements ISTTParser {
        private EmailParser() {
        }

        @Override
        public String parse(String text) {
            String delimiters = "<>@.,;";
            int previous = -1;
            int len = text.length();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    if (Bidi.isCharBeforeBiDiChar(text, i, previous)) {
                        buf.append(Bidi.LRM);
                        previous = i;
                    }
                    int k = i++;
                    int j = text.indexOf(34, i);
                    if (j > i) {
                        buf.append(text.substring(k, j));
                        i = j;
                        if (Bidi.isCharBeforeBiDiChar(text, i, previous)) {
                            buf.append(Bidi.LRM);
                            previous = i;
                        }
                    }
                }
                if (delimiters.indexOf(c) >= 0 && Bidi.isCharBeforeBiDiChar(text, i, previous)) {
                    buf.append(Bidi.LRM);
                    previous = i;
                }
                buf.append(c);
            }
            return buf.toString();
        }
    }

    private static class FilepathParser
    implements ISTTParser {
        private FilepathParser() {
        }

        @Override
        public String parse(String text) {
            String delimiters = "/\\:.";
            StringBuffer buf = new StringBuffer();
            int previous = -1;
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                char c = text.charAt(i);
                if (delimiters.indexOf(c) >= 0 && Bidi.isCharBeforeBiDiChar(text, i, previous)) {
                    buf.append(Bidi.LRM);
                    previous = i;
                }
                buf.append(c);
            }
            return buf.toString();
        }
    }

    private static interface ISTTParser {
        public String parse(String var1);
    }
}

