/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.icuadapter;

import com.ibm.icu.impl.Grego;
import com.ibm.icu.impl.jdkadapter.TimeZoneICU;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class TimeZoneJDK
extends TimeZone {
    private static final long serialVersionUID = -1137052823551791933L;
    private java.util.TimeZone fJdkTz;
    private transient Calendar fJdkCal;

    private TimeZoneJDK(java.util.TimeZone jdkTz) {
        this.fJdkTz = jdkTz;
    }

    public static TimeZone wrap(java.util.TimeZone jdkTz) {
        if (jdkTz instanceof TimeZoneICU) {
            return ((TimeZoneICU)jdkTz).unwrap();
        }
        return new TimeZoneJDK(jdkTz);
    }

    public java.util.TimeZone unwrap() {
        return this.fJdkTz;
    }

    public Object clone() {
        TimeZoneJDK other = (TimeZoneJDK)((Object)super.clone());
        other.fJdkTz = (java.util.TimeZone)this.fJdkTz.clone();
        return other;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeZoneJDK) {
            return ((TimeZoneJDK)((Object)obj)).fJdkTz.equals(this.fJdkTz);
        }
        return false;
    }

    public String getDisplayName(boolean daylight, int style, Locale locale) {
        return this.fJdkTz.getDisplayName(daylight, style, locale);
    }

    public String getDisplayName(boolean daylight, int style, ULocale locale) {
        return this.fJdkTz.getDisplayName(daylight, style, locale.toLocale());
    }

    public int getDSTSavings() {
        return this.fJdkTz.getDSTSavings();
    }

    public String getID() {
        return this.fJdkTz.getID();
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        return this.fJdkTz.getOffset(era, year, month, day, dayOfWeek, milliseconds);
    }

    public int getOffset(long date) {
        return this.fJdkTz.getOffset(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOffset(long date, boolean local, int[] offsets) {
        TimeZoneJDK timeZoneJDK = this;
        synchronized (timeZoneJDK) {
            if (this.fJdkCal == null) {
                this.fJdkCal = new GregorianCalendar(this.fJdkTz);
            }
            if (local) {
                int[] fields = new int[6];
                Grego.timeToFields((long)date, (int[])fields);
                int tmp = fields[5];
                int mil = tmp % 1000;
                int sec = (tmp /= 1000) % 60;
                int min = (tmp /= 60) % 60;
                int hour = tmp / 60;
                this.fJdkCal.clear();
                this.fJdkCal.set(fields[0], fields[1], fields[2], hour, min, sec);
                this.fJdkCal.set(14, mil);
                int doy1 = this.fJdkCal.get(6);
                int hour1 = this.fJdkCal.get(11);
                int min1 = this.fJdkCal.get(12);
                int sec1 = this.fJdkCal.get(13);
                int mil1 = this.fJdkCal.get(14);
                if (fields[4] != doy1 || hour != hour1 || min != min1 || sec != sec1 || mil != mil1) {
                    int dayDelta = Math.abs(doy1 - fields[4]) > 1 ? 1 : doy1 - fields[4];
                    int delta = (((dayDelta * 24 + hour1 - hour) * 60 + min1 - min) * 60 + sec1 - sec) * 1000 + mil1 - mil;
                    this.fJdkCal.setTimeInMillis(this.fJdkCal.getTimeInMillis() - (long)delta - 1L);
                }
            } else {
                this.fJdkCal.setTimeInMillis(date);
            }
            offsets[0] = this.fJdkCal.get(15);
            offsets[1] = this.fJdkCal.get(16);
        }
    }

    public int getRawOffset() {
        return this.fJdkTz.getRawOffset();
    }

    public int hashCode() {
        return this.fJdkTz.hashCode();
    }

    public boolean hasSameRules(TimeZone other) {
        return other.hasSameRules(TimeZoneJDK.wrap(this.fJdkTz));
    }

    public boolean inDaylightTime(Date date) {
        return this.fJdkTz.inDaylightTime(date);
    }

    public void setID(String ID) {
        this.fJdkTz.setID(ID);
    }

    public void setRawOffset(int offsetMillis) {
        this.fJdkTz.setRawOffset(offsetMillis);
    }

    public boolean useDaylightTime() {
        return this.fJdkTz.useDaylightTime();
    }
}

