/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.configtest;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CSKRequestUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.HttpClientInitializer;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.misc.PriorityUrlList;
import com.cognos.accman.res.MessageSet;
import java.net.InetAddress;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class CSKRequestUnitTest {
    public final byte SUCCESS = 1;
    public final byte CAMFACTORY_INITIALIZE_ERROR = (byte)2;
    public final byte SYNC_CM_ERROR = (byte)3;
    public final byte GET_CERT_AND_KEY_ERROR = (byte)4;
    public final byte CREATE_V1_REQUEST_ERROR = (byte)5;
    public final byte CREATE_NEW_REQUEST_ERROR = (byte)6;
    public final byte NO_ACTIVE_CM_ERROR = (byte)7;
    public final byte UNKNOWN_ERROR = (byte)9;

    public byte test() {
        String strXMLRequest;
        PrivateKey encPrivateKey;
        CAMFactory factory = new CAMFactory();
        try {
            factory.initialize("<initializeDocument><serviceID>CAM</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            return 2;
        }
        Configuration config = Configuration.getInstance();
        try {
            if (config.getWeAreCM() || config.isStandaloneCA()) {
                return 1;
            }
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            return 9;
        }
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        byte[] hostIP = null;
        byte[] rawEncCert = null;
        try {
            hostIP = InetAddress.getLocalHost().getAddress();
            Certificate encCert = KeyStoreReader.getEncryptionCertificate();
            encPrivateKey = KeyStoreReader.getEncryptionPrivateKey();
            rawEncCert = encCert.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 4;
        }
        String response = null;
        try {
            strXMLRequest = CSKRequestUtilities.createRequest((byte[])locale, (byte[])hostIP, (byte[])rawEncCert, null);
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            return 6;
        }
        PriorityUrlList urls = config.getPeers();
        Iterator thisUrl = urls.getIterator();
        CAMCryptoException firstError = null;
        while (thisUrl.hasNext()) {
            try {
                URL url = (URL)thisUrl.next();
                PostMethod post = new PostMethod();
                post.setRequestBody(strXMLRequest);
                post.setPath(url.getFile());
                post.setRequestHeader("Content-type", "text/xml");
                post.setRequestHeader("SOAPAction", "\"http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201505/\"");
                HttpClient hc = HttpClientInitializer.getInstance().createHttpClient(url);
                hc.setConnectionTimeout(30000);
                hc.setTimeout(30000);
                int resultCode = 0;
                try {
                    resultCode = hc.executeMethod((HttpMethod)post);
                    response = CAMCryptoUtilities.getResponseString((PostMethod)post);
                    post.releaseConnection();
                }
                catch (Exception e) {
                    if (firstError != null) continue;
                    firstError = new CAMCryptoException((Throwable)e, MessageSet.getMessage((String)"CAM_CRP_req_csk_http_error", (String[])new String[]{url.toString()}));
                    continue;
                }
                if (resultCode < 200 || resultCode > 299) {
                    if (firstError != null) continue;
                    firstError = new CAMCryptoException(MessageSet.getMessage((String)"CAM_CRP_req_http_ret_code_error", (String[])new String[]{String.valueOf(resultCode)}));
                    continue;
                }
                urls.updateURLPriority(url);
                Document doc = DocumentHelper.parseText((String)response);
                List nodeList = doc.selectNodes("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='commonSymmetricKey']/*[local-name()='value']");
                Iterator it = nodeList.iterator();
                if (!it.hasNext()) {
                    throw new CAMCryptoException(MessageSet.getMessage((String)"CAM_CRP_remote_csk_req_parse_error"));
                }
                Node node = (Node)it.next();
                if (it.hasNext()) {
                    throw new CAMCryptoException(MessageSet.getMessage((String)"CAM_CRP_remote_csk_req_parse_error"));
                }
                String b64CSK = node.getText();
                byte[] rawResponse = CryptoWrapper.decodeBase64((byte[])b64CSK.getBytes());
                rawResponse = CryptoWrapper.decodeBase64((byte[])rawResponse);
                byte reqVersion = rawResponse[0];
                byte respType = rawResponse[1];
                byte[] rawEncryptedCSK = new byte[rawResponse.length - 2];
                System.arraycopy(rawResponse, 2, rawEncryptedCSK, 0, rawResponse.length - 2);
                if (reqVersion != 2) {
                    throw new CAMCryptoException(MessageSet.getMessage((String)"CAM_CRP_csk_invalid_msg_version"));
                }
                if (respType == 9) {
                    CAMCryptoUtilities.throwPeerException((byte[])rawEncryptedCSK);
                }
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                Cipher c = Cipher.getInstance("RSA", jceProvider);
                c.init(2, encPrivateKey);
                c.doFinal(rawEncryptedCSK);
                return 1;
            }
            catch (Exception e) {
                if (firstError != null) continue;
                firstError = new CAMCryptoException((Throwable)e, MessageSet.getMessage((String)"CAM_CRP_req_csk_http_error", (String[])new String[]{config.getPeer().toString()}));
            }
        }
        if (firstError != null) {
            firstError.printStackTrace();
        }
        return 7;
    }
}

