/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.configtest;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.SymmetricAlgorithmManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigurationValidator {
    public static final int SUCCESS = 1;
    public static final int UNKNOWN_ERROR = 2;
    public static final int CAMFACTORY_INITIALIZE_ERROR = 3;
    public static final int NULL_SYMMETRIC_ALG_ERROR = 4;
    public static final int INVALID_SYMMETRIC_ALG_ERROR = 5;
    public static final int INVALID_NIST_131A_ALG_ERROR = 6;
    public static final int INVALID_DISPATCHER_HOSTNAMES = 7;
    public static final int INVALID_INTERNAL_DISPATCHER_HOSTNAME = 8;
    public static final int INVALID_EXTERNAL_DISPATCHER_HOSTNAME = 9;
    public static final int INVALID_CONFIGURATION_GROUP_HOSTNAME = 10;
    private CAMFactory cf = null;

    public int validateSymmetricAlgorithm() throws CAMCryptoException {
        if (!this.initCAMFactory()) {
            return 3;
        }
        Configuration config = Configuration.getInstance();
        String symmetricAlgorithm = config.getConfidentialityAlgorithm();
        if (symmetricAlgorithm == null || symmetricAlgorithm.length() == 0) {
            return 4;
        }
        SymmetricAlgorithmManager symmetricAlgorighmManager = new SymmetricAlgorithmManager();
        Vector algorithms = symmetricAlgorighmManager.getSupportedSymmetricAlgs(null);
        for (String algorithm : algorithms) {
            if (symmetricAlgorithm.compareToIgnoreCase(algorithm) != 0) continue;
            return 1;
        }
        return 5;
    }

    public int doNISTChecks() throws CAMCryptoException {
        if (!this.initCAMFactory()) {
            return 3;
        }
        Configuration config = Configuration.getInstance();
        String pdfAlgName = config.getPDFEncryptionAlgorithm();
        int pdfKeyBits = config.getPDFKeySizeInBits();
        if (pdfAlgName.compareToIgnoreCase("AES") != 0 || pdfKeyBits < 256) {
            return 6;
        }
        return 1;
    }

    public int validateSANConfiguration(String configGroupMemberHost) throws CAMCryptoException {
        StringTokenizer st;
        if (!this.initCAMFactory()) {
            return 3;
        }
        Configuration config = Configuration.getInstance();
        String sanDnsNames = config.getSanDnsNames();
        String sanIPAddrs = config.getSanIPAddrs();
        String serverCommonName = config.getServerCommonName();
        ArrayList<String> sanNames = new ArrayList<String>();
        if (sanDnsNames != null && sanDnsNames.length() != 0) {
            st = new StringTokenizer(sanDnsNames, " ");
            while (st.hasMoreTokens()) {
                sanNames.add(st.nextToken());
            }
        }
        if (sanIPAddrs != null && sanIPAddrs.length() != 0) {
            st = new StringTokenizer(sanIPAddrs, " ");
            while (st.hasMoreTokens()) {
                sanNames.add(st.nextToken());
            }
        }
        if (sanNames.size() == 0) {
            sanNames.add(serverCommonName);
        }
        String internalDispatcherURI = config.getInternalDispatcherURI();
        boolean internalDispOK = this.verifyDispatcherURI(sanNames, internalDispatcherURI);
        String externalDispatcherURI = config.getExternalDispatcherURI();
        boolean externalDispOK = this.verifyDispatcherURI(sanNames, externalDispatcherURI);
        boolean configGroupMemberHostOK = this.sanListHasHostname(sanNames, configGroupMemberHost);
        if (!internalDispOK && !externalDispOK) {
            return 7;
        }
        if (!internalDispOK) {
            return 8;
        }
        if (!externalDispOK) {
            return 9;
        }
        if (!configGroupMemberHostOK) {
            return 10;
        }
        return 1;
    }

    protected boolean verifyDispatcherURI(List<String> sanList, String dispatcherURI) {
        boolean ret = true;
        if (dispatcherURI.startsWith("https:")) {
            try {
                String hostname = new URL(dispatcherURI).getHost();
                if (!this.sanListHasHostname(sanList, hostname)) {
                    ret = false;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return ret;
    }

    private boolean sanListHasHostname(List<String> sanList, String hostname) {
        for (String san : sanList) {
            if (san.startsWith("*")) {
                return CAMCryptoUtilities.checkWildcardMatch((String)san, (String)hostname);
            }
            if (san.compareToIgnoreCase(hostname) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean initCAMFactory() {
        if (this.cf != null) {
            return true;
        }
        try {
            this.cf = new CAMFactory();
            this.cf.initialize("<initializeDocument><serviceID>CONFIG_TEST</serviceID></initializeDocument>".getBytes());
            return true;
        }
        catch (Exception e) {
            this.cf = null;
            return false;
        }
    }
}

