/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.configtest;

import com.cognos.accman.jcam.configtest.CSKRequestUnitTest;
import com.cognos.accman.jcam.configtest.ConfigurationValidator;
import com.cognos.accman.jcam.configtest.JVMTrustStoreUnitTest;
import com.cognos.accman.jcam.configtest.TrustRootUnitTest;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import com.cognos.crconfig.ICnfgTest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.dom4j.Element;

public class CryptoTest
implements ICnfgTest {
    boolean isNISTMode = true;
    boolean isDispatcherSSL = false;
    boolean isThirdPartyCA = false;
    boolean isEnabledHostnameVerification = true;
    String configGroupMemberHost = "";
    private ResourceBundle m_resource;
    private String m_sDeploymentPath;
    private static final String DEP_PATH = "deploymentPath";
    private static final String NULL_PATH = "null";
    private static final String SECURITY_PATH = "security";
    private static final String SECURITY_CRYPTO_PATH = "security/CRYPTO";

    public boolean initialize(ICCLConfiguration config, ICnfgFeedback feedback) {
        this.m_resource = ResourceBundle.getBundle("jcam_errors", Locale.getDefault());
        boolean bStatus = true;
        try {
            this.m_sDeploymentPath = config.getValue(DEP_PATH, true);
            this.getConfigGroupMemberHost(config);
            this.checkNISTMode(config);
            this.checkDispatcherSSL(config);
            this.checkThirdPartyCA(config);
            this.checkEnablingHostNameVerification(config);
        }
        catch (CCLConfigurationException e) {
            bStatus = false;
        }
        return bStatus;
    }

    private void getConfigGroupMemberHost(ICCLConfiguration config) throws CCLConfigurationException {
        Element elemCFS = config.getValueElement("CFS", true);
        Element elemConfigGroupMemberHost = this.getChildElement(elemCFS, "configGroupMemberHost");
        this.configGroupMemberHost = elemConfigGroupMemberHost.getStringValue();
    }

    private void checkNISTMode(ICCLConfiguration config) throws CCLConfigurationException {
        Element elemCRYPTO = config.getValueElement("CRYPTO", true);
        Element elemCryptoStandardConformance = this.getChildElement(elemCRYPTO, "cryptoStandardConformance");
        String nodeValue = elemCryptoStandardConformance.getStringValue();
        this.isNISTMode = nodeValue.compareTo("NIST_SP_800_131A") == 0;
    }

    private void checkDispatcherSSL(ICCLConfiguration config) throws CCLConfigurationException {
        Element elemInternaleDispatcher = config.getValueElement("internalDispatcher", true);
        Element elemexternaleDispatcher = config.getValueElement("externalDispatcher", true);
        String vInternaleDispatcher = elemInternaleDispatcher.getStringValue();
        String vExternaleDispatcher = elemexternaleDispatcher.getStringValue();
        this.isDispatcherSSL = vInternaleDispatcher.startsWith("https:") || vExternaleDispatcher.startsWith("https:");
    }

    private void checkThirdPartyCA(ICCLConfiguration config) throws CCLConfigurationException {
        Element elemCRYPTO = config.getValueElement("CRYPTO", true);
        Element elemCryptoProvider = this.getChildElement(elemCRYPTO, "cryptoProvider");
        Element elemCognos = this.getChildElement(elemCryptoProvider, "Cognos");
        Element elemThirdPartyCA = this.getChildElement(elemCognos, "thirdPartyCA");
        String nodeValue = elemThirdPartyCA.getStringValue();
        this.isThirdPartyCA = nodeValue.compareTo("true") == 0;
    }

    private void checkEnablingHostNameVerification(ICCLConfiguration config) throws CCLConfigurationException {
        Element elemHostnameVerification;
        Element elemAdvancedProperties = config.getValueElement("advancedProperties", true);
        if (elemAdvancedProperties != null && (elemHostnameVerification = this.getChildElement(elemAdvancedProperties, "EnableSSLHostnameVerification")) != null) {
            String vEnableHostnameVerification = elemHostnameVerification.getStringValue();
            this.isEnabledHostnameVerification = vEnableHostnameVerification.compareToIgnoreCase("true") == 0 || vEnableHostnameVerification.compareToIgnoreCase("Yes") == 0;
        }
    }

    private Element getChildElement(Element elem, String nodeName) {
        for (Object obj : elem.elements()) {
            Element childElem;
            String node;
            if (obj == null || !(obj instanceof Element) || !(node = (childElem = (Element)obj).attributeValue("name")).equals(nodeName)) continue;
            return childElem;
        }
        return null;
    }

    public void terminate(ICnfgFeedback feedback) {
    }

    public ICnfgTask[] getTasks(String parameterPath, ICnfgFeedback feedback) {
        ArrayList list = new ArrayList();
        if (parameterPath.equals(NULL_PATH) || parameterPath.equals(SECURITY_PATH) || parameterPath.equals(SECURITY_CRYPTO_PATH)) {
            this.createTasks(list);
        }
        ICnfgTask[] tasks = new ICnfgTask[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            tasks[i++] = (ICnfgTask)it.next();
        }
        return tasks;
    }

    private void createTasks(ArrayList taskList) {
        taskList.add(new CnfgTask(){

            public String getLabel() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_configuration_title");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public String getDescription() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_configuration_description");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public ICnfgTaskPrompt[] getPrompts() {
                return null;
            }

            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                boolean bRetValue = true;
                ConfigurationValidator configurationValidator = new ConfigurationValidator();
                int ret = configurationValidator.validateSymmetricAlgorithm();
                if (ret == 1) {
                    bRetValue = true;
                } else if (ret == 3) {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_camfactory_initialize_error"));
                    bRetValue = false;
                } else if (ret == 4) {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_configuration_symmetric_algorithm_not_configured_error"));
                    bRetValue = false;
                } else if (ret == 5) {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_configuration_invalid_symmetric_algorithm_error"));
                    bRetValue = false;
                } else {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_configuration_symmetric_algorithm_error"));
                    bRetValue = false;
                }
                return bRetValue;
            }
        });
        if (this.isEnabledHostnameVerification) {
            if (!this.isThirdPartyCA) {
                taskList.add(new CnfgTask(){

                    @Override
                    public boolean isMandatory() {
                        return true;
                    }

                    public String getLabel() {
                        String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_title");
                        return CAMCryptoUtilities.extractMsgString((String)msg);
                    }

                    public String getDescription() {
                        String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_description");
                        return CAMCryptoUtilities.extractMsgString((String)msg);
                    }

                    public ICnfgTaskPrompt[] getPrompts() {
                        return null;
                    }

                    public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                        boolean bRetValue = true;
                        String sanError = "";
                        ConfigurationValidator configurationValidator = new ConfigurationValidator();
                        int ret = configurationValidator.validateSANConfiguration(CryptoTest.this.configGroupMemberHost);
                        if (ret == 1) {
                            return true;
                        }
                        if (ret == 7) {
                            sanError = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_dispatchers_error");
                        } else if (ret == 8) {
                            sanError = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_internal_dispatcher_error");
                        } else if (ret == 9) {
                            sanError = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_external_dispatcher_error");
                        } else if (ret == 10) {
                            sanError = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_configuration_group_error");
                        }
                        String showMessage = sanError + CAMCryptoUtilities.extractMsgString((String)CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_comments"));
                        feedback.showError(showMessage);
                        return false;
                    }
                });
            } else {
                taskList.add(new CnfgTask(){

                    @Override
                    public boolean isMandatory() {
                        return false;
                    }

                    public String getLabel() {
                        String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_title");
                        return CAMCryptoUtilities.extractMsgString((String)msg);
                    }

                    public String getDescription() {
                        String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_description");
                        return CAMCryptoUtilities.extractMsgString((String)msg);
                    }

                    public ICnfgTaskPrompt[] getPrompts() {
                        return null;
                    }

                    public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                        feedback.showWarning(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_san_thirdparty_warning"));
                        return false;
                    }
                });
            }
        }
        if (this.isNISTMode) {
            taskList.add(new CnfgTask(){

                @Override
                public boolean isMandatory() {
                    return false;
                }

                public String getLabel() {
                    String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_nist_131a_conformance_title");
                    return CAMCryptoUtilities.extractMsgString((String)msg);
                }

                public String getDescription() {
                    String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_nist_131a_conformance_description");
                    return CAMCryptoUtilities.extractMsgString((String)msg);
                }

                public ICnfgTaskPrompt[] getPrompts() {
                    return null;
                }

                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    boolean bRetValue = true;
                    ConfigurationValidator configurationValidator = new ConfigurationValidator();
                    int ret = configurationValidator.doNISTChecks();
                    if (ret == 1) {
                        bRetValue = true;
                    } else if (ret == 3) {
                        feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_camfactory_initialize_error"));
                        bRetValue = false;
                    } else if (ret == 6) {
                        feedback.showWarning(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_validate_nist_131a_not_permited_algorithm"));
                        bRetValue = false;
                    }
                    return bRetValue;
                }
            });
        }
        taskList.add(new CnfgTask(){

            public String getLabel() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_trustroot_test_title");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public String getDescription() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_trustroot_test_description");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public ICnfgTaskPrompt[] getPrompts() {
                return null;
            }

            public boolean run(Object[] arg0, ICnfgFeedback feedback) throws Exception {
                boolean bRetValue = true;
                CAMFactory cf = new CAMFactory();
                try {
                    cf.initialize("<initializeDocument><serviceID>CAM</serviceID></initializeDocument>".getBytes());
                    if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                        String s = CryptoTest.this.m_resource.getString("CAM_CAP_fips_mode_on");
                        feedback.showInformational(s);
                    }
                }
                catch (Exception e) {
                    String s = e.toString();
                    e.printStackTrace();
                    return false;
                }
                try {
                    TrustRootUnitTest trustRootUnitTest = new TrustRootUnitTest();
                    byte ret = trustRootUnitTest.test();
                    if (ret == trustRootUnitTest.DIFFERENT_TRUSTROOT) {
                        String s = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_different_trustroot");
                        feedback.showError(s);
                        bRetValue = false;
                    } else {
                        bRetValue = true;
                    }
                }
                catch (CAMCryptoException e) {
                    bRetValue = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bRetValue = false;
                }
                return bRetValue;
            }
        });
        taskList.add(new CnfgTask(){

            public String getLabel() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_csk_request_test_title");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public String getDescription() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_csk_request_test_description");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public ICnfgTaskPrompt[] getPrompts() {
                return null;
            }

            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                boolean bRetValue = true;
                CAMFactory cf = new CAMFactory();
                try {
                    cf.initialize("<initializeDocument><serviceID>CAM</serviceID></initializeDocument>".getBytes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    CSKRequestUnitTest cskRequestUnitTest = new CSKRequestUnitTest();
                    byte ret = cskRequestUnitTest.test();
                    if (ret == cskRequestUnitTest.SUCCESS) {
                        bRetValue = true;
                    } else if (ret == cskRequestUnitTest.CAMFACTORY_INITIALIZE_ERROR) {
                        feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_camfactory_initialize_error"));
                        bRetValue = false;
                    } else if (ret == cskRequestUnitTest.SYNC_CM_ERROR) {
                        feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_sync_cm_error"));
                        bRetValue = false;
                    } else if (ret == cskRequestUnitTest.GET_CERT_AND_KEY_ERROR) {
                        feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_get_cert_and_key_error"));
                        bRetValue = false;
                    } else if (ret == cskRequestUnitTest.CREATE_V1_REQUEST_ERROR) {
                        feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_create_v1_request_error"));
                        bRetValue = false;
                    } else if (ret == cskRequestUnitTest.CREATE_NEW_REQUEST_ERROR) {
                        feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_create_new_request_error"));
                        bRetValue = false;
                    } else if (ret == cskRequestUnitTest.NO_ACTIVE_CM_ERROR) {
                        feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_no_active_cm_error"));
                        bRetValue = false;
                    } else {
                        bRetValue = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bRetValue = false;
                }
                return bRetValue;
            }
        });
        taskList.add(new CnfgTask(){

            public String getLabel() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_truststore_title");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public String getDescription() {
                String msg = CryptoTest.this.m_resource.getString("CAM_CRP_config_test_truststore_description");
                return CAMCryptoUtilities.extractMsgString((String)msg);
            }

            public ICnfgTaskPrompt[] getPrompts() {
                return null;
            }

            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                boolean bRetValue = true;
                JVMTrustStoreUnitTest jvmTrustStoreUnitTest = new JVMTrustStoreUnitTest();
                byte ret = jvmTrustStoreUnitTest.test();
                if (ret == 1) {
                    bRetValue = true;
                } else if (ret == 3) {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_camfactory_initialize_error"));
                    bRetValue = false;
                } else if (ret == 4) {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_truststore_password_empty"));
                    bRetValue = false;
                } else if (ret == 5) {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_truststore_password_error"));
                    bRetValue = false;
                } else {
                    feedback.showError(CryptoTest.this.m_resource.getString("CAM_CRP_config_test_truststore_load_keystore_error"));
                    bRetValue = false;
                }
                return bRetValue;
            }
        });
    }

    abstract class CnfgTask
    implements ICnfgTask {
        private int m_status;

        CnfgTask() {
        }

        public boolean isMandatory() {
            return true;
        }

        public final int getStatus() {
            return this.m_status;
        }

        public final void setStatus(int status) {
            this.m_status = status;
        }

        public void cancel(ICnfgFeedback feedback) throws Exception {
        }
    }
}

