/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.configtest;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;

public class JVMTrustStoreUnitTest {
    private static final String JVM_DEFAULT_PASSWORD = "changeit";
    public static final byte SUCCESS = 1;
    public static final byte UNKNOWN_ERROR = 2;
    public static final byte CAMFACTORY_INITIALIZE_ERROR = 3;
    public static final byte NULL_PASSWORD_ERROR = 4;
    public static final byte INCORRECT_PASSWORD_ERROR = 5;

    public byte test() throws CAMCryptoException {
        CAMFactory cf = new CAMFactory();
        try {
            cf.initialize("<initializeDocument><serviceID>CAM</serviceID></initializeDocument>".getBytes());
        }
        catch (Exception e) {
            return 3;
        }
        Configuration config = Configuration.getInstance();
        String jvmTrustStorePassword = config.getJVMTrustStorePassword();
        if (jvmTrustStorePassword == null) {
            return 4;
        }
        if (jvmTrustStorePassword.length() == 0) {
            jvmTrustStorePassword = JVM_DEFAULT_PASSWORD;
        }
        String jvmTrustStoreFile = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        try {
            KeyStore keystore = KeyStore.getInstance("jks");
            keystore.load(new FileInputStream(jvmTrustStoreFile), jvmTrustStorePassword.toCharArray());
        }
        catch (IOException exception) {
            return 5;
        }
        catch (Exception exception) {
            return 2;
        }
        return 1;
    }
}

