/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMCryptoKeyException;
import com.cognos.accman.jcam.crypto.SPSCipherAESjava;
import com.cognos.accman.jcam.crypto.SystemProtectionSessionTokenV1;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.InvalidKeyException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class SystemProtectionSession {
    private Cipher cd_o = null;
    private Cipher cd = null;
    static final int SHA256RawKey = 3;
    static final int MD5RawKey = 2;
    static final int LegacyRawKey = 1;

    public byte[] encryptData(byte[] cleartext) throws CAMCryptoException {
        try {
            return this.encryptDataV1(cleartext);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_sys_prot_key_encrypt_failure"));
        }
    }

    public byte[] encryptDataV1(byte[] cleartext) throws CAMCryptoException {
        IJVMEnvironment jvmEnv = JVMEnvironment.getInstance();
        SPSCipherAESjava spsCipher = new SPSCipherAESjava(jvmEnv);
        return SystemProtectionSessionTokenV1.encryptData(cleartext, spsCipher);
    }

    public byte[] tryDecryptDataV1(byte[] data, IJVMEnvironment jvmEnv) {
        try {
            return SystemProtectionSessionTokenV1.decryptData(data, jvmEnv);
        }
        catch (CAMCryptoException e) {
            return null;
        }
    }

    public byte[] decryptData(byte[] ciphertext) throws CAMCryptoException {
        byte[] cleartext;
        block14: {
            this.outputCipherText(ciphertext);
            cleartext = null;
            IJVMEnvironment jvmEnvironment = JVMEnvironment.getInstance();
            try {
                if (ciphertext.length > 0) {
                    try {
                        cleartext = this.tryDecryptDataV1(ciphertext, jvmEnvironment);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cleartext == null) {
                        if (this.cd == null) {
                            this.cd = this._getAESKeyCipher();
                        }
                        if (jvmEnvironment.isFIPSEnabled()) {
                            cleartext = this.cd.doFinal(ciphertext);
                        } else {
                            try {
                                cleartext = this.cd.doFinal(ciphertext);
                            }
                            catch (BadPaddingException bpe) {
                                cleartext = this.handleSystemKeyOfPreviousReleases(ciphertext);
                            }
                            catch (IllegalBlockSizeException ibse) {
                                cleartext = this.handleSystemKeyOfPreviousReleases(ciphertext);
                            }
                        }
                    }
                    break block14;
                }
                cleartext = ciphertext;
            }
            catch (BadPaddingException bpe) {
                throw new CAMCryptoKeyException(bpe, MessageSet.getMessage("CAM_CRP_sys_prot_key_decrypt_failure"));
            }
            catch (CAMCryptoException e) {
                throw (CAMCryptoException)e.fillInStackTrace();
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_sys_prot_key_decrypt_failure"));
            }
        }
        return cleartext;
    }

    private byte[] handleSystemKeyOfPreviousReleases(byte[] ciphertext) throws IllegalBlockSizeException, CAMCryptoException, BadPaddingException {
        byte[] cleartext;
        try {
            cleartext = this._getDESKeyCipher().doFinal(ciphertext);
        }
        catch (BadPaddingException bpe2) {
            try {
                cleartext = this._getAESKeyCipher().doFinal(ciphertext);
            }
            catch (BadPaddingException bpe3) {
                try {
                    cleartext = this._getNonParityKeyCipher().doFinal(ciphertext);
                }
                catch (BadPaddingException bpe4) {
                    cleartext = this._getOldDecryptingCipher().doFinal(ciphertext);
                }
            }
        }
        return cleartext;
    }

    private byte[] _getRawKey(int version) throws CAMCryptoException {
        byte[] rawKey;
        try {
            switch (version) {
                case 3: {
                    rawKey = new JNISystemProperties().getByteBuffer3(0);
                    break;
                }
                case 2: {
                    rawKey = new JNISystemProperties().getByteBuffer2(0);
                    break;
                }
                case 1: {
                    rawKey = new JNISystemProperties().getByteBuffer();
                    break;
                }
                default: {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_syskey_gen_error"));
                }
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_syskey_gen_error"));
        }
        if (rawKey == null || rawKey.length <= 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_syskey_gen_error"));
        }
        this.outputKey(rawKey);
        return rawKey;
    }

    private void outputKey(byte[] key) {
        byte[] encodedString = CryptoWrapper.encodeBase64(key);
        String identifier = new String("Java SystemProtectionSession.GetRawKey Base64 encoded Raw Key:" + new String(encodedString));
        IPFTraceFunction.trace(identifier);
    }

    private void outputCipherText(byte[] cipherText) {
        byte[] encodedString = CryptoWrapper.encodeBase64(cipherText);
        String identifier = new String("Java SystemProtectionSession.GetRawKey Base64 encoded Cipher Text:" + new String(encodedString));
        IPFTraceFunction.trace(identifier);
    }

    private Cipher _getAESKeyCipher() throws CAMCryptoException {
        Cipher akc;
        IJVMEnvironment jvmEnvironment = JVMEnvironment.getInstance();
        byte[] rawKey = this._getRawKey(3);
        try {
            SecretKeySpec key = new SecretKeySpec(rawKey, 0, 16, "AES");
            String jceProvider = jvmEnvironment.getJCEProvider();
            akc = Cipher.getInstance("AES", jceProvider);
            akc.init(2, key);
            int keylen = rawKey.length;
            for (int i = 0; i < keylen; ++i) {
                rawKey[i] = 0;
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_syskey_gen_error"));
        }
        return akc;
    }

    private Cipher _getDESKeyCipher() throws CAMCryptoException {
        Cipher dkc;
        byte[] rawKey = this._getRawKey(2);
        try {
            byte[] rawKeyWithParity = CryptoWrapper.addParity(rawKey);
            SecretKeySpec key = new SecretKeySpec(rawKeyWithParity, 0, 8, "DES");
            int keylen = rawKeyWithParity.length;
            for (int i = 0; i < keylen; ++i) {
                rawKeyWithParity[i] = 0;
            }
            dkc = Cipher.getInstance("DES/ECB/PKCS5Padding", JVMEnvironment.getInstance().getPBEProvider());
            dkc.init(2, key);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_syskey_gen_error"));
        }
        return dkc;
    }

    private Cipher _getNonParityKeyCipher() throws CAMCryptoException {
        Cipher npkc;
        byte[] rawKey = this._getRawKey(2);
        try {
            SecretKeySpec key = new SecretKeySpec(rawKey, 0, 8, "DES");
            npkc = Cipher.getInstance("DES/ECB/PKCS5Padding", JVMEnvironment.getInstance().getPBEProvider());
            npkc.init(2, key);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_syskey_gen_error"));
        }
        int keylen = rawKey.length;
        for (int i = 0; i < keylen; ++i) {
            rawKey[i] = 0;
        }
        return npkc;
    }

    private Cipher _getOldDecryptingCipher() throws CAMCryptoException {
        if (this.cd_o == null) {
            byte[] rawKey = this._getRawKey(1);
            try {
                SecretKeySpec key = new SecretKeySpec(rawKey, 0, 8, "DES");
                this.cd_o = Cipher.getInstance("DES/ECB/PKCS5Padding", JVMEnvironment.getInstance().getPBEProvider());
                this.cd_o.init(2, key);
            }
            catch (InvalidKeyException e) {
                throw new CAMCryptoKeyException(e, MessageSet.getMessage("CAM_CRP_sys_prot_key_decrypt_failure"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_syskey_gen_error"));
            }
            int keylen = rawKey.length;
            for (int i = 0; i < keylen; ++i) {
                rawKey[i] = 0;
            }
        }
        return this.cd_o;
    }
}

