/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.EncodedCSKRequest;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7SignedData;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class CSKRequestUtilities {
    private static final byte PKCS1_WITH_IPADDR = 4;
    private static final byte PKCS1_WITH_IPADDR_DIGEST = 5;
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");
    private static final byte[] CSK_HEAD = "-----BEGIN CSK V3.0-----\n".getBytes();
    private static final byte[] CSK_TAIL = "-----END CSK V3.0-----\n".getBytes();
    private static final int PBE_SALT_LENGTH = 24;
    private static final int PBE_ITERATION_COUNT = 100;
    private static final String CSK_REQ_HEAD = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">\n<SOAP-ENV:Header>\n<bus:biBusHeader xsi:type=\"bus:biBusHeader\">\n<CAM xsi:nil=\"true\"/>\n<CAMProtect xsi:type=\"bus:CAMProtect\">\n<trustedValue xsi:type=\"xsd:base64Binary\">";
    private static final String CSK_REQ_TAIL = "</trustedValue >\n<serviceId xsi:type=\"xsd:string\">CAMconfig</serviceId>\n</CAMProtect>\n</bus:biBusHeader>\n</SOAP-ENV:Header>\n<SOAP-ENV:Body>\n<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\">\n<search xsi:type=\"xsd:string\">/directory</search>\n<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\">\n<item xsi:type=\"cm:propEnum\">commonSymmetricKey</item>\n</properties>\n</cm:query>\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>\n";

    public static String createV1Request(byte[] hostIP, byte[] rawEncCert, byte[] digest) throws CAMCryptoException {
        int sFlag;
        byte[] contentData;
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("hostIP = " + new String(hostIP));
        cskTraceLogger.trace("rawEncCert = " + IPFTraceLogger.toBase64String(rawEncCert));
        cskTraceLogger.trace("digest = " + IPFTraceLogger.toBase64String(digest));
        Configuration config = Configuration.getInstance();
        PrivateKey signPrivateKey = KeyStoreReader.getSigningPrivateKey();
        Certificate[] signCertChain = KeyStoreReader.getSigningCertificateChain();
        X509Certificate[] x509SignCertChain = new X509Certificate[signCertChain.length];
        System.arraycopy(signCertChain, 0, x509SignCertChain, 0, signCertChain.length);
        signCertChain = null;
        if (digest == null) {
            contentData = new byte[1 + hostIP.length + rawEncCert.length];
            contentData[0] = (byte)hostIP.length;
            System.arraycopy(hostIP, 0, contentData, 1, hostIP.length);
            System.arraycopy(rawEncCert, 0, contentData, hostIP.length + 1, rawEncCert.length);
            sFlag = 4;
        } else {
            contentData = new byte[1 + hostIP.length + 1 + digest.length + rawEncCert.length];
            contentData[0] = (byte)hostIP.length;
            System.arraycopy(hostIP, 0, contentData, 1, hostIP.length);
            contentData[hostIP.length + 1] = (byte)digest.length;
            System.arraycopy(digest, 0, contentData, hostIP.length + 2, digest.length);
            System.arraycopy(rawEncCert, 0, contentData, hostIP.length + digest.length + 2, rawEncCert.length);
            sFlag = 5;
        }
        byte[] signedContentData = PKCS7SignedData.sign(contentData, signPrivateKey, x509SignCertChain, config.getDigestAlgorithm());
        byte[] signedRequest = new byte[1 + signedContentData.length];
        signedRequest[0] = (byte)sFlag;
        System.arraycopy(signedContentData, 0, signedRequest, 1, signedContentData.length);
        String b64CSKReqBytes = new String(CryptoWrapper.encodeBase64(signedRequest));
        String strXMLRequest = new StringBuffer().append(CSK_REQ_HEAD).append(b64CSKReqBytes).append(CSK_REQ_TAIL).toString();
        cskTraceLogger.logExit(true);
        return strXMLRequest;
    }

    public static String createRequest(byte[] locale, byte[] hostIP, byte[] rawEncCert, byte[] digest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("hostIP = " + new String(hostIP));
        cskTraceLogger.trace("rawEncCert = " + IPFTraceLogger.toBase64String(rawEncCert));
        cskTraceLogger.trace("digest = " + IPFTraceLogger.toBase64String(digest));
        Configuration config = Configuration.getInstance();
        PrivateKey signPrivateKey = KeyStoreReader.getSigningPrivateKey();
        Certificate[] signCertChain = KeyStoreReader.getSigningCertificateChain();
        X509Certificate[] x509SignCertChain = new X509Certificate[signCertChain.length];
        System.arraycopy(signCertChain, 0, x509SignCertChain, 0, signCertChain.length);
        signCertChain = null;
        EncodedCSKRequest encodedCSKRequest = new EncodedCSKRequest(locale, hostIP, rawEncCert, digest);
        byte[] contentData = encodedCSKRequest.genCSKRequest();
        byte[] signedContentData = PKCS7SignedData.sign(contentData, signPrivateKey, x509SignCertChain, config.getDigestAlgorithm());
        String b64CSKReqBytes = new String(CryptoWrapper.encodeBase64(signedContentData));
        String strXMLRequest = new StringBuffer().append(CSK_REQ_HEAD).append(b64CSKReqBytes).append(CSK_REQ_TAIL).toString();
        cskTraceLogger.trace("strXMLRequest = " + strXMLRequest);
        cskTraceLogger.logExit(true);
        return strXMLRequest;
    }
}

