/*
 * Decompiled with CFR 0.152.
 */
package jd.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import jd.io.CharToByteConverter;
import jd.io.ConversionBufferFullException;

public class OutputStreamWriter
extends Writer {
    private CharToByteConverter ctb_;
    private OutputStream out_;
    private byte[] bb_;
    private int nextByte_ = 0;
    private int nBytes_ = 0;
    private static final int defaultByteBufferSize = 8192;

    public OutputStreamWriter(OutputStream outputStream, CharToByteConverter charToByteConverter) {
        super(outputStream);
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream is null");
        }
        if (charToByteConverter == null) {
            throw new IllegalArgumentException("CharToByteConverter is null");
        }
        this.out_ = outputStream;
        this.ctb_ = charToByteConverter;
        this.bb_ = new byte[8192];
        this.nBytes_ = 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            return this.ctb_ != null ? this.ctb_.getCharacterEncoding() : null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out_ == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                boolean bl = false;
                try {
                    this.nextByte_ += this.ctb_.convert(cArray, n3, n4, this.bb_, this.nextByte_, this.nBytes_);
                    n3 = n4;
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    int n5 = this.ctb_.nextCharIndex();
                    if (n5 == n3) {
                        throw new CharConversionException("Output buffer too small");
                    }
                    n3 = n5;
                    bl = true;
                    this.nextByte_ = this.ctb_.nextByteIndex();
                }
                if (this.nextByte_ < this.nBytes_ && !bl) continue;
                this.out_.write(this.bb_, 0, this.nextByte_);
                this.nextByte_ = 0;
            }
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                try {
                    this.nextByte_ += this.ctb_.flush(this.bb_, this.nextByte_, this.nBytes_);
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte_ = this.ctb_.nextByteIndex();
                }
                if (this.nextByte_ == 0) break;
                if (this.nextByte_ <= 0) continue;
                this.out_.write(this.bb_, 0, this.nextByte_);
                this.nextByte_ = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.out_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out_ == null) {
                return;
            }
            this.flush();
            this.out_.close();
            this.out_ = null;
            this.bb_ = null;
            this.ctb_ = null;
        }
    }
}

