/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.axis;

import jd.xml.xpath.axis.Axis;
import jd.xml.xpath.axis.NodeTest;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.walk.ModelWalker;
import jd.xml.xpath.model.walk.PrecedingSiblingWalker;
import jd.xml.xpath.object.XMutableNodeSet;

public class PrecedingSiblingAxis
extends Axis
implements ModelWalker {
    public static final Axis INSTANCE = new PrecedingSiblingAxis();

    private PrecedingSiblingAxis() {
        super("preceding-sibling", false, false);
    }

    @Override
    public void getNodes(XPathNode xPathNode, NodeTest nodeTest, XMutableNodeSet xMutableNodeSet) {
        int n = xPathNode.getType();
        if (n != 2 && n != 6) {
            XPathNode xPathNode2 = xPathNode.getFirstSibling();
            while (!xPathNode2.equalsNode(xPathNode)) {
                if (nodeTest.accept(xPathNode2, 0)) {
                    xMutableNodeSet.addNode(xPathNode2);
                }
                xPathNode2 = xPathNode2.getNextSibling();
            }
        }
    }

    @Override
    public ModelWalker getModelWalker() {
        return new PrecedingSiblingWalker();
    }

    @Override
    public ModelWalker getProximityModelWalker() {
        return this;
    }

    @Override
    public XPathNode gotoFirstNode(XPathNode xPathNode) {
        return xPathNode.getPrevSibling();
    }

    @Override
    public XPathNode gotoNextNode(XPathNode xPathNode) {
        return xPathNode.getPrevSibling();
    }
}

