/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.object;

public abstract class Relation {
    public static final Relation LESS = new Less();
    public static final Relation LESS_EQUALS = new LessEquals();
    public static final Relation GREATER = new Greater();
    public static final Relation GREATER_EQUALS = new GreaterEquals();
    private String symbol_;
    private Relation reverse_;

    private Relation() {
    }

    private void init(String string, Relation relation) {
        this.symbol_ = string;
        this.reverse_ = relation;
    }

    public Relation getReverse() {
        return this.reverse_;
    }

    public String getSymbol() {
        return this.symbol_;
    }

    public abstract boolean compare(double var1, double var3);

    static {
        LESS.init("<", GREATER);
        GREATER.init(">", LESS);
        LESS_EQUALS.init("<=", GREATER_EQUALS);
        GREATER_EQUALS.init(">=", LESS_EQUALS);
    }

    private static final class GreaterEquals
    extends Relation {
        private GreaterEquals() {
        }

        @Override
        public boolean compare(double d, double d2) {
            return d >= d2;
        }
    }

    private static final class Greater
    extends Relation {
        private Greater() {
        }

        @Override
        public boolean compare(double d, double d2) {
            return d > d2;
        }
    }

    private static final class LessEquals
    extends Relation {
        private LessEquals() {
        }

        @Override
        public boolean compare(double d, double d2) {
            return d <= d2;
        }
    }

    private static final class Less
    extends Relation {
        private Less() {
        }

        @Override
        public boolean compare(double d, double d2) {
            return d < d2;
        }
    }
}

