/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.object;

import jd.xml.xpath.XPathException;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.Relation;
import jd.xml.xpath.object.XNumber;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XString;

public abstract class XNodeSet
extends XObject {
    public static final int ORDER_ORDERED = 0;
    public static final int ORDER_UNORDERED = 1;
    public static final int ORDER_COUNTED = 2;
    public static final int ORDER_SUMMARIZED = 3;
    public static final int ORDER_CONVERTIBLE = 4;
    private int docId_;

    @Override
    public int getType() {
        return 3;
    }

    public int getOrdering() {
        return 0;
    }

    public boolean isOrdered() {
        return XNodeSet.isOrdered(this.getOrdering());
    }

    public static boolean isOrdered(int n) {
        return n == 4 || n == 0;
    }

    @Override
    public Object toValue() {
        return this;
    }

    @Override
    public int canConvertTo(Class clazz) {
        if (XObject.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (XNodeSet.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (XPathNode.class.isAssignableFrom(clazz)) {
            return 9;
        }
        if (clazz == String.class) {
            return 8;
        }
        if (clazz == Object.class) {
            return 7;
        }
        if (clazz == Character.TYPE) {
            return 6;
        }
        if (clazz == Character.class) {
            return 5;
        }
        if (clazz == Double.TYPE || clazz == Float.TYPE || clazz == Long.TYPE || clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
            return 4;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return 3;
        }
        if (clazz == Boolean.TYPE) {
            return 2;
        }
        if (clazz == Boolean.class) {
            return 1;
        }
        return 0;
    }

    @Override
    public Object toValue(Class clazz) {
        if (XObject.class.isAssignableFrom(clazz)) {
            return this;
        }
        if (XPathNode.class.isAssignableFrom(clazz)) {
            if (this.isEmpty()) {
                throw new XPathException("cannot convert an empty NodeSet to a Node");
            }
            return this.getNode(0);
        }
        if (clazz == String.class) {
            return this.toStringValue();
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return XString.toCharacterValue(this.toStringValue());
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return this.toBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return XNumber.toNumberValue(this.toNumberValue(), clazz);
    }

    @Override
    public boolean toBooleanValue() {
        return !this.isEmpty();
    }

    @Override
    public double toNumberValue() {
        return XString.toNumberValue(this.toStringValue());
    }

    public double toNumberValue(int n) {
        return XString.toNumberValue(this.toStringValue(n));
    }

    @Override
    public String toStringValue() {
        return this.isEmpty() ? "" : this.toStringValue(0);
    }

    public String toStringValue(int n) {
        return this.getNode(n).getValue();
    }

    @Override
    public XNodeSet toNodeSet() {
        return this;
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract XPathNode getNode(int var1);

    public double getNodeSum() {
        double d = 0.0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            d += XString.toNumberValue(this.toStringValue(i));
        }
        return d;
    }

    public int indexOf(XPathNode xPathNode) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.getNode(i).equals(xPathNode)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(XPathNode xPathNode) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.getNode(i).equalsNode(xPathNode)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.getNode(i).getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    int getDocId() {
        if (this.docId_ == 0 && !this.isEmpty()) {
            this.docId_ = this.getNode(0).getRoot().getDocumentId();
        }
        return this.docId_;
    }

    void setDocId(int n) {
        this.docId_ = n;
    }

    void setMultiDocId() {
        this.docId_ = 0;
    }

    @Override
    public boolean compare(Equality equality, String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!equality.compare(this.toStringValue(i), string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean compare(Equality equality, double d) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!equality.compare(this.toNumberValue(i), d)) continue;
            return true;
        }
        return false;
    }

    public boolean compare(Equality equality, XNodeSet xNodeSet) {
        int n = this.size();
        int n2 = xNodeSet.size();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n; ++i) {
            String string = this.toStringValue(i);
            for (int j = 0; j < n2; ++j) {
                if (i == 0) {
                    stringArray[j] = xNodeSet.toStringValue(j);
                }
                if (!equality.compare(string, stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean compare(Equality equality, XObject xObject) {
        switch (xObject.getType()) {
            case 1: {
                return this.compare(equality, xObject.toNumberValue());
            }
            case 2: {
                return this.compare(equality, xObject.toStringValue());
            }
            case 0: {
                return this.compare(equality, xObject.toBooleanValue());
            }
        }
        return this.compare(equality, xObject.toNodeSet());
    }

    @Override
    public boolean compare(Relation relation, double d) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!relation.compare(this.toNumberValue(i), d)) continue;
            return true;
        }
        return false;
    }

    public boolean compare(Relation relation, XNodeSet xNodeSet) {
        int n = this.size();
        int n2 = xNodeSet.size();
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            double d = this.toNumberValue(i);
            for (int j = 0; j < n2; ++j) {
                if (i == 0) {
                    dArray[j] = xNodeSet.toNumberValue(j);
                }
                if (!relation.compare(d, dArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean compare(Relation relation, XObject xObject) {
        return xObject.getType() == 3 ? this.compare(relation, xObject.toNodeSet()) : this.compare(relation, xObject.toNumberValue());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getNode(i));
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

