/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result.output;

import java.io.IOException;
import java.io.Writer;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.result.output.Output;

public final class CharOutput
implements Output {
    public static final int BUFFER_SIZE = 4096;
    private char[] buffer_ = new char[4096];
    private Writer out_;
    private int pos_;
    private int bufferLength_ = this.buffer_.length;

    public CharOutput(Writer writer) {
        this.out_ = writer;
    }

    @Override
    public void printSmallByte(char c) {
        if (this.pos_ == this.bufferLength_) {
            this.flushBuffer();
        }
        this.buffer_[this.pos_++] = c;
    }

    @Override
    public void printSmallBytes(char c, int n) {
        if (this.pos_ + n > this.bufferLength_) {
            this.ensureCapacity(n);
        }
        while (n-- > 0) {
            this.buffer_[this.pos_++] = c;
        }
    }

    @Override
    public void printChar(char c) {
        if (this.pos_ == this.bufferLength_) {
            this.flushBuffer();
        }
        this.buffer_[this.pos_++] = c;
    }

    @Override
    public void printChars(char[] cArray, int n) {
        if (this.pos_ + n > this.bufferLength_) {
            this.ensureCapacity(n);
        }
        System.arraycopy(cArray, 0, this.buffer_, this.pos_, n);
        this.pos_ += n;
    }

    @Override
    public void printString(String string) {
        int n = string.length();
        if (this.pos_ + n > this.bufferLength_) {
            this.ensureCapacity(n);
        }
        string.getChars(0, n, this.buffer_, this.pos_);
        this.pos_ += n;
    }

    @Override
    public final void flush() {
        this.flushBuffer();
        try {
            this.out_.flush();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    private void flushBuffer() {
        try {
            this.out_.write(this.buffer_, 0, this.pos_);
            this.pos_ = 0;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    private void ensureCapacity(int n) {
        this.flushBuffer();
        if (this.bufferLength_ < n) {
            this.buffer_ = new char[n];
            this.bufferLength_ = this.buffer_.length;
        }
    }

    private void handleException(IOException iOException) {
        throw new XsltException("output error", iOException);
    }
}

