/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result.output;

import java.io.OutputStream;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.result.output.ByteOutput;

public class Utf8ByteOutput
extends ByteOutput {
    private char highHalfZoneCode_;
    private int lastPos_;

    public Utf8ByteOutput(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public final void printChar(char c) {
        if (this.highHalfZoneCode_ != '\u0000') {
            if (c < '\udc00' || c > '\udfff') {
                throw new XsltException("malformed input");
            }
            int n = (this.highHalfZoneCode_ - 55296) * 1024 + (c - 56320) + 65536;
            this.highHalfZoneCode_ = '\u0000';
            this.pos_ = this.lastPos_;
            this.printSmallByte((char)(0xF0 | n >> 18 & 7));
            this.printSmallByte((char)(0x80 | n >> 12 & 0x3F));
            this.printSmallByte((char)(0x80 | n >> 6 & 0x3F));
            this.printSmallByte((char)(0x80 | n & 0x3F));
        } else if (c < '\u0080') {
            this.printSmallByte(c);
        } else if (c < '\u0800') {
            this.printSmallByte((char)(0xC0 | c >> 6 & 0x1F));
            this.printSmallByte((char)(0x80 | c & 0x3F));
        } else if ((c & 0xFC00) != 55296) {
            this.printSmallByte((char)(0xE0 | c >> 12 & 0xF));
            this.printSmallByte((char)(0x80 | c >> 6 & 0x3F));
            this.printSmallByte((char)(0x80 | c & 0x3F));
        } else {
            this.highHalfZoneCode_ = c;
            this.lastPos_ = this.pos_;
            this.pos_ = this.max_;
        }
    }

    @Override
    protected void flushBuffer() throws XsltException {
        if (this.highHalfZoneCode_ != '\u0000') {
            throw new XsltException("malformed input");
        }
        super.flushBuffer();
    }
}

