/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.trax;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jd.xml.util.UriResolver;
import jd.xml.util.XmlSource;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.result.DomResultBuilder;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.result.SaxResultBuilder;
import jd.xml.xslt.trax.TraxModelXmlSource;
import jd.xml.xslt.trax.UriResolverAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public abstract class TraxUtil {
    public static XmlSource getXmlSource(Source source) throws TransformerConfigurationException {
        try {
            String string = source.getSystemId();
            if (string == null) {
                string = "";
            }
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                InputSource inputSource = new InputSource(string);
                inputSource.setByteStream(streamSource.getInputStream());
                inputSource.setCharacterStream(streamSource.getReader());
                inputSource.setPublicId(streamSource.getPublicId());
                return new XmlSource(inputSource);
            }
            if (source instanceof SAXSource) {
                SAXSource sAXSource = (SAXSource)source;
                InputSource inputSource = sAXSource.getInputSource();
                if (inputSource == null) {
                    throw new TransformerConfigurationException("SAXSource does not provide an InputSource");
                }
                if (inputSource.getSystemId() == null) {
                    inputSource.setSystemId("");
                }
                XmlSource xmlSource = new XmlSource(inputSource);
                xmlSource.setParser(sAXSource.getXMLReader());
                return xmlSource;
            }
            if (source instanceof DOMSource) {
                Node node = ((DOMSource)source).getNode();
                return new XmlSource(string, node);
            }
            if (source instanceof TraxModelXmlSource) {
                return new XmlSource(string, ((TraxModelXmlSource)source).getRoot());
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw transformerConfigurationException;
        }
        catch (Exception exception) {
            throw new TransformerConfigurationException(exception);
        }
        throw new TransformerConfigurationException("cannot handle a transformation source of " + source.getClass());
    }

    public static XsltResult getXsltResult(Result result) throws TransformerConfigurationException {
        if (result instanceof StreamResult) {
            return TraxUtil.getXsltResult((StreamResult)result);
        }
        if (result instanceof DOMResult) {
            return new XsltResult(TraxUtil.getDomResultBuilder((DOMResult)result));
        }
        if (result instanceof SAXResult) {
            return new XsltResult(TraxUtil.getSaxResultBuilder((SAXResult)result));
        }
        throw new TransformerConfigurationException("cannot handle transformation result " + result.getClass());
    }

    private static XsltResult getXsltResult(StreamResult streamResult) throws TransformerConfigurationException {
        String string = streamResult.getSystemId();
        String string2 = string != null ? string : "";
        OutputStream outputStream = streamResult.getOutputStream();
        if (outputStream != null) {
            return new XsltResult(string2, outputStream, false);
        }
        Writer writer = streamResult.getWriter();
        if (writer != null) {
            return new XsltResult(string2, writer, false);
        }
        if (string != null) {
            String string3 = string;
            if (string3.startsWith("file:///")) {
                string3 = string3.substring(8).indexOf(":") > 0 ? string3.substring(8) : string3.substring(7);
            }
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(string3));
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException(iOException);
            }
            return new XsltResult(string2, outputStream, true);
        }
        throw new TransformerConfigurationException("StreamResult has no OutputStream, Writer or SystemId");
    }

    private static ResultBuilder getDomResultBuilder(DOMResult dOMResult) throws TransformerConfigurationException {
        Document document;
        Node node = dOMResult.getNode();
        if (node == null) {
            node = TraxUtil.createDomDocument();
            dOMResult.setNode(node);
        }
        Document document2 = document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (document == null) {
            throw new TransformerConfigurationException("Node of DOMResult does not have a owner-document");
        }
        return new DomResultBuilder(document, node);
    }

    private static ResultBuilder getSaxResultBuilder(SAXResult sAXResult) throws TransformerConfigurationException {
        ContentHandler contentHandler;
        SAXResult sAXResult2 = sAXResult;
        String string = sAXResult.getSystemId();
        if (string == null) {
            string = "";
        }
        if ((contentHandler = sAXResult2.getHandler()) == null) {
            throw new TransformerConfigurationException("SAXResult does not provide a ContentHandler");
        }
        return new SaxResultBuilder(string, contentHandler, sAXResult2.getLexicalHandler());
    }

    public static Document createDomDocument() throws TransformerConfigurationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformerConfigurationException(parserConfigurationException);
        }
    }

    public static UriResolver getUriResolver(URIResolver uRIResolver) {
        return uRIResolver == null ? null : new UriResolverAdapter(uRIResolver);
    }

    public static String convertQualifiedName(String string) {
        if (string.charAt(0) == '{') {
            char c = string.charAt(125);
            if (c == '\uffffffff') {
                throw new IllegalArgumentException("cannot extract namespace uri from name '" + string + "'");
            }
            string = string.substring(1, c) + ':' + string.substring(c + '\u0001');
        }
        return string;
    }
}

