/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.util;

import java.io.IOException;
import java.util.Hashtable;
import jd.xml.util.UriResolver;
import jd.xml.util.UriUtil;
import jd.xml.util.XmlSource;
import jd.xml.xpath.model.ModelReader;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.model.parse.ParseHandler;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltSecurityManager;
import jd.xml.xslt.result.pipe.Dom2ResultPipe;
import jd.xml.xslt.util.KeyMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ModelCache {
    private Info info_;
    private XPathRootNode root_;
    private ModelReader modelReader_;
    private NodeNamePool namePool_;
    private NodeNamePool modelNamePool_;
    private UriResolver uriResolver_;

    public ModelCache(NodeNamePool nodeNamePool, Object object) throws SAXException {
        this.namePool_ = nodeNamePool;
        this.modelReader_ = new ModelReader(object);
    }

    public void setUriResolver(UriResolver uriResolver) {
        this.uriResolver_ = uriResolver;
    }

    public NodeNamePool getNodeNamePool() {
        return this.modelNamePool_;
    }

    public ModelReader getModelReader() {
        return this.modelReader_;
    }

    public ParseHandler getParseHandler() {
        return this.modelReader_.getParseHandler();
    }

    public void initMainModel(XmlSource xmlSource) throws IOException, SAXException, XsltException {
        if (this.root_ != null) {
            this.cleanup();
        }
        this.modelReader_.setNextDocumentId(0);
        this.modelNamePool_ = new NodeNamePool(this.namePool_);
        this.root_ = this.readModel(xmlSource);
        this.addEntry(this.root_, null, xmlSource.getUri());
    }

    public XPathRootNode getMainModel() {
        return this.root_;
    }

    public XPathRootNode getModel(String string, String string2) throws IOException, SAXException {
        return this.getModel(string, string2, null);
    }

    public XPathRootNode getModel(String string, String string2, XsltSecurityManager xsltSecurityManager) throws IOException, SAXException, SecurityException {
        if (this.root_ == null) {
            throw new XsltException("main model is null");
        }
        if (string == null) {
            throw new XsltException("href is null");
        }
        if (string2 == null) {
            throw new XsltException("baseUri is null");
        }
        Info info = this.info_;
        while (info != null) {
            if (string.equals(info.href) && string2.equals(info.baseUri)) {
                return info.root;
            }
            info = info.next;
        }
        int n = string.indexOf(35);
        if (n != -1) {
            String string3 = string.substring(n + 1);
            String string4 = string.substring(0, n);
            XPathRootNode xPathRootNode = this.getModel(string4, string2);
            XPathRootNode xPathRootNode2 = xPathRootNode.getFragment(string3);
            this.addEntry(xPathRootNode2, string, string2);
            return xPathRootNode2;
        }
        XmlSource xmlSource = UriUtil.resolveUri(string, string2, this.uriResolver_);
        if (xsltSecurityManager != null) {
            xsltSecurityManager.checkDocumentRead(xmlSource.getUri());
        }
        XPathRootNode xPathRootNode = this.readResolverModel(xmlSource);
        this.addEntry(xPathRootNode, string, string2);
        return xPathRootNode;
    }

    public XPathNode getTextNodeFragment(String string) {
        return this.modelReader_.getTextNodeFragment(string, this.modelNamePool_);
    }

    private XPathRootNode readResolverModel(XmlSource xmlSource) throws IOException, SAXException, XsltException {
        if (xmlSource.getDocument() != null) {
            Object object = xmlSource.getDocument();
            if (object instanceof XPathRootNode) {
                XPathRootNode xPathRootNode = (XPathRootNode)object;
                NodeNamePool nodeNamePool = xPathRootNode.getNodeNamePool();
                if (nodeNamePool != null && !nodeNamePool.isCreatedFrom(this.namePool_)) {
                    throw new XsltException("input document does not use the stylesheet namepool");
                }
                return xPathRootNode;
            }
            if (object instanceof Node) {
                return Dom2ResultPipe.getRoot(xmlSource.getUri(), (Node)object, this.modelNamePool_);
            }
            throw new XsltException("unknown document type: " + object.getClass().getName());
        }
        return this.modelReader_.read(xmlSource, this.getNodeNamePool(), xmlSource.getParser());
    }

    private XPathRootNode readModel(XmlSource xmlSource) throws IOException, SAXException, XsltException {
        if (xmlSource.getDocument() != null) {
            Object object = xmlSource.getDocument();
            if (object instanceof XPathRootNode) {
                XPathRootNode xPathRootNode = (XPathRootNode)object;
                NodeNamePool nodeNamePool = xPathRootNode.getNodeNamePool();
                if (nodeNamePool != null && !nodeNamePool.isCreatedFrom(this.namePool_)) {
                    throw new XsltException("input document does not use the stylesheet namepool");
                }
                return xPathRootNode;
            }
            if (object instanceof Node) {
                return Dom2ResultPipe.getRoot(xmlSource.getUri(), (Node)object, this.modelNamePool_);
            }
            throw new XsltException("unknown document type: " + object.getClass().getName());
        }
        return this.modelReader_.read(xmlSource, this.getNodeNamePool());
    }

    private Info addEntry(XPathRootNode xPathRootNode, String string, String string2) {
        Info info = new Info();
        info.root = xPathRootNode;
        info.href = string;
        info.baseUri = string2;
        if (this.info_ == null) {
            this.info_ = info;
        } else {
            this.info_.add(info);
        }
        return info;
    }

    private Info getInfo(XPathRootNode xPathRootNode) {
        if (xPathRootNode == null) {
            xPathRootNode = this.root_;
        }
        Info info = this.info_;
        while (info != null) {
            if (info.root != null && info.root.equalsNode(xPathRootNode)) {
                return info;
            }
            info = info.next;
        }
        if (xPathRootNode.getBaseUri().length() == 0) {
            return this.addEntry(xPathRootNode, null, "");
        }
        throw new XsltException("cannot retrieve document info of unknown document " + xPathRootNode);
    }

    public Object putItem(XPathRootNode xPathRootNode, Object object, Object object2) {
        Info info = this.getInfo(xPathRootNode);
        if (info.cache == null) {
            info.cache = new Hashtable(10);
        }
        return object2 == null ? info.cache.remove(object) : info.cache.put(object, object2);
    }

    public Object getItem(XPathRootNode xPathRootNode, Object object) {
        Info info = this.getInfo(xPathRootNode);
        return info.cache == null ? null : info.cache.get(object);
    }

    public KeyMap[] getKeyMaps(XPathRootNode xPathRootNode) {
        return this.getInfo((XPathRootNode)xPathRootNode).keyMaps;
    }

    public void setKeyMaps(XPathRootNode xPathRootNode, KeyMap[] keyMapArray) {
        this.getInfo((XPathRootNode)xPathRootNode).keyMaps = keyMapArray;
    }

    public void cleanup() {
        Info info = this.info_;
        while (info != null) {
            if (info.root != null) {
                info.root.cleanup();
            }
            info = info.next;
        }
        this.info_ = null;
        this.root_ = null;
        this.modelNamePool_ = null;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    private static class Info {
        XPathRootNode root;
        String href;
        String baseUri;
        KeyMap[] keyMaps;
        Hashtable cache;
        Info next;

        private Info() {
        }

        public void add(Info info) {
            if (this.next == null) {
                this.next = info;
            } else {
                this.next.add(info);
            }
        }
    }
}

