/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CCLMsgBase {
    public static final String LOCALE_INFO_SEPARATOR = "_";
    public static final String XML_ENCODING = "UTF8";
    private static String m_resFileName = "cclmsgsdk";
    protected static Locale m_resLocale = Locale.ENGLISH;
    private static ResourceBundle m_resource = ResourceBundle.getBundle(m_resFileName, m_resLocale);
    private static PrintStream m_errStream = System.err;
    private static PrintStream m_outStream = System.out;
    private static BufferedWriter m_logWriter = null;

    public CCLMsgBase() {
    }

    public CCLMsgBase(String string) {
        m_resource = ResourceBundle.getBundle(string, m_resLocale);
    }

    public void abort(int n, String string) {
        this.printError(string);
        CCLMsgBase.abort(n);
    }

    public static void abort(int n) {
        System.exit(n);
    }

    public void printError(String string) {
        m_errStream.println(string);
        try {
            if (m_logWriter != null) {
                m_logWriter.write(string);
                m_logWriter.newLine();
                m_logWriter.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgBase.abort(1);
        }
    }

    public void printWarning(String string) {
        m_outStream.println(string);
    }

    public static void printLog(String string) {
        m_outStream.println(string);
        try {
            if (m_logWriter != null) {
                m_logWriter.write(string);
                m_logWriter.newLine();
                m_logWriter.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgBase.abort(1);
        }
    }

    public String getResString(String string) {
        String string2 = null;
        try {
            string2 = (String)m_resource.getObject(string);
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{string, this.getResFileName()};
            this.printError(this.formatString(this.getResString("JMS_GEN_RES_STRING_FAILED"), objectArray));
            throwable.printStackTrace();
            CCLMsgBase.abort(1);
        }
        return this.replaceToken(string2, "'", "''");
    }

    public String formatString(String string, Object[] objectArray) {
        String string2 = MessageFormat.format(string, objectArray);
        return string2;
    }

    public ResourceBundle getResource() {
        return m_resource;
    }

    public PrintStream getOutStream() {
        return m_outStream;
    }

    public void setOutStream(PrintStream printStream) {
        m_outStream = printStream;
    }

    public String getResFileName() {
        return m_resFileName;
    }

    public void setResFileName(String string) {
        m_resFileName = string;
        m_resource = ResourceBundle.getBundle(m_resFileName, m_resLocale);
    }

    public Locale getResLocale() {
        return m_resLocale;
    }

    public void setResLocale(Locale locale) {
        m_resLocale = locale;
        m_resource = ResourceBundle.getBundle(m_resFileName, m_resLocale);
    }

    public void setResLocale(String string) {
        Locale locale = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, LOCALE_INFO_SEPARATOR, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        switch (arrayList.size()) {
            case 1: {
                locale = new Locale((String)arrayList.get(0), "");
                break;
            }
            case 2: {
                locale = new Locale((String)arrayList.get(0), (String)arrayList.get(1));
                break;
            }
            case 3: {
                locale = new Locale((String)arrayList.get(0), (String)arrayList.get(1), (String)arrayList.get(2));
            }
        }
        this.setResLocale(locale);
    }

    public void copyDir(String string, String string2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.getFileList(new File(string), arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = arrayList.get(i).toString();
            String string4 = string2 + string3.substring(string.length());
            this.copyFile(string3, string4, bl);
        }
    }

    public void getFileList(File file, List list) {
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgBase.abort(1);
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.getFileList(new File(file, stringArray[i]), list);
                }
            } else {
                list.add(string);
            }
        } else {
            Object[] objectArray = new Object[]{string};
            this.printError(this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray));
        }
    }

    public void copyFile(String string, String string2) {
        this.copyFile(string, string2, true);
    }

    public void copyFile(String string, String string2, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            Object[] objectArray = new Object[]{string};
            this.printError(this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray));
            return;
        }
        this.createParentDir(string2);
        File file2 = new File(string2);
        BufferedOutputStream bufferedOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n = 0;
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                ((OutputStream)bufferedOutputStream).write(n);
            }
            ((OutputStream)bufferedOutputStream).close();
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string, string2};
            String string3 = this.formatString(this.getResString("JMS_FIL_COPY_FAILED"), objectArray);
            this.abort(1, string3);
        }
        file2.setLastModified(file.lastModified());
        try {
            Object[] objectArray = new Object[]{file.getCanonicalPath(), file2.getCanonicalPath()};
            if (bl) {
                CCLMsgBase.printLog(this.formatString(this.getResString("JMS_LOG_COPY"), objectArray));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgBase.abort(1);
        }
    }

    public String createParentDir(String string) {
        File file = new File(string);
        String string2 = null;
        String string3 = null;
        try {
            string2 = file.getCanonicalPath();
            string3 = file.getCanonicalFile().getParent();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgBase.abort(1);
        }
        File file2 = new File(string3);
        if (!file2.exists()) {
            try {
                file2.mkdirs();
            }
            catch (SecurityException securityException) {
                Object[] objectArray = new Object[]{string3};
                String string4 = this.formatString(this.getResString("JMS_FIL_GEN_DIR_FAILED2"), objectArray);
                this.abort(1, string4);
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[]{string3};
                String string5 = this.formatString(this.getResString("JMS_FIL_GEN_DIR_FAILED1"), objectArray);
                this.abort(1, string5);
            }
        }
        return string2;
    }

    public boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                boolean bl = this.deleteDir(file2);
                if (bl) continue;
                try {
                    Object[] objectArray = new Object[]{file2.getCanonicalPath()};
                    String string = this.formatString(this.getResString("JMS_FIL_DEL_DIR_FAILED"), objectArray);
                    this.abort(1, string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    CCLMsgBase.abort(1);
                }
                return false;
            }
        }
        return file.delete();
    }

    public String replaceToken(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.compareTo("'") == 0) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public Writer getLogWriter() {
        return m_logWriter;
    }

    public void createLogWriter(String string) {
        if (string != null) {
            try {
                this.createParentDir(string);
                m_logWriter = new BufferedWriter(new FileWriter(string, true));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                CCLMsgBase.abort(1);
            }
        } else {
            m_logWriter = null;
        }
    }

    public static String getJarManifestInfo(String string, String string2) {
        String string3 = null;
        try {
            JarFile jarFile = new JarFile(string);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            for (Attributes.Name name : attributes.keySet()) {
                String string4 = attributes.getValue(name);
                if (name.toString().toLowerCase().compareTo(string2.toLowerCase()) != 0) continue;
                string3 = string4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string3;
    }
}

