/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLMsgBase;
import com.cognos.localizationkit.CCLMsgConfigInfo;
import com.cognos.localizationkit.CCLPropertyBundle;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultAttribute;

public class CCLMsgBrandLdkGenerator
extends CCLMsgBase {
    public static final String EXECUTE_COMMAND = "genbrandldkspec";
    private static final String ATTRIBUTE_CONTAINS_BRAND = "containsBrand";
    private static final String ELEMENT_MESSAGEFILES = "messageFiles";
    private static final String MESSAGEFILE_FULL_PATH = "messageFiles/messageFile";
    private static final String BRAND_LDKSPEC_FILENAME = "brand_ldkspec.xml";
    private static final String DEFAULT_LOCALE = "en";
    Set<String> dependentProcesses = null;

    public boolean execute(String string, String string2, String string3) {
        boolean bl = true;
        this.dependentProcesses = new HashSet<String>();
        String string4 = string2 + File.separator + BRAND_LDKSPEC_FILENAME;
        try {
            File[] fileArray;
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            FileWriter fileWriter = new FileWriter(string4);
            XMLWriter xMLWriter = new XMLWriter((Writer)fileWriter, outputFormat);
            CCLMsgBase.printLog("srcDir: " + string);
            CCLMsgBase.printLog("targetDir: " + string2);
            CCLMsgBase.printLog("ldkOutFile: " + string4);
            if (string3 == null) {
                string3 = DEFAULT_LOCALE;
            }
            CCLMsgBase.printLog("srcLocal: " + string3);
            Document document = this.generateBrandLdkSpecSkeleton();
            File file = new File(string);
            LdkSpecFilenameFilter ldkSpecFilenameFilter = new LdkSpecFilenameFilter();
            for (File file2 : fileArray = file.listFiles(ldkSpecFilenameFilter)) {
                bl = bl && this.processLdkSpec(string, string2, string3, document, file2);
            }
            this.copyRequiredProcesses(string, string2);
            CCLMsgBase.printLog("Writing brand ldkspec to " + string4 + ".");
            xMLWriter.write(document);
            xMLWriter.close();
            CCLMsgBase.printLog("-> Finished writing.");
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string4};
            this.printError(this.formatString(this.getResString("JMS_FIL_WRITE_FAILED"), objectArray));
            iOException.printStackTrace();
            return false;
        }
        return bl;
    }

    private void copyRequiredProcesses(String string, String string2) {
        CCLMsgBase.printLog("Copying " + this.dependentProcesses.size() + " required process files...");
        for (String string3 : this.dependentProcesses) {
            this.copyFile(string, string2, string3);
        }
    }

    private boolean processLdkSpec(String string, String string2, String string3, Document document, File file) {
        boolean bl = true;
        if (file.isFile()) {
            SAXReader sAXReader = new SAXReader();
            try {
                Document document2 = sAXReader.read(file);
                CCLMsgBase.printLog("Scanning " + file.getName() + " for brand nodes.");
                List list = document2.selectNodes("messageFiles/messageFile[@containsBrand='true']");
                int n = list.size();
                CCLMsgBase.printLog("-> found " + n + " brand node(s). " + (n > 0 ? "processing..." : "Skipping."));
                if (n > 0) {
                    for (Node node : list) {
                        if (!(node instanceof Element)) continue;
                        Element element = (Element)node;
                        bl = bl && this.processMessageFileElement(string, string2, string3, document, element);
                    }
                }
            }
            catch (DocumentException documentException) {
                Object[] objectArray = new Object[]{file};
                this.printError(this.formatString(this.getResString("JMS_DOM_DOCUMENT_EXCEPTION"), objectArray));
                documentException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void addProcessDependency(String string) {
        CCLMsgBase.printLog("Registering required process file: " + string);
        this.dependentProcesses.add(string);
    }

    private boolean processMessageFileElement(String string, String string2, String string3, Document document, Element element) {
        try {
            element.getParent().remove(element);
            document.getRootElement().add(element);
            String string4 = element.attributeValue("baseName");
            String string5 = string4 + "_" + string3 + ".xml";
            this.copyFile(string, string2, string5);
            List list = element.selectNodes("transformations/transformation/@process[ends-with(.,'.xslt')] | transformations/transformation[@process='xslt']/xsltOptions/@script");
            for (Node node : list) {
                if (!(node instanceof DefaultAttribute)) continue;
                DefaultAttribute defaultAttribute = (DefaultAttribute)node;
                this.addProcessDependency(defaultAttribute.getText());
            }
        }
        catch (Exception exception) {
            this.printError("Error processing MessageFileElement: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private Document generateBrandLdkSpecSkeleton() {
        Document document = DocumentHelper.createDocument();
        Element element = DocumentHelper.createElement((String)ELEMENT_MESSAGEFILES);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(DocumentHelper.createComment((String)this.getCopyrightHeader()));
        arrayList.add(element);
        document.setContent(arrayList);
        element.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.addAttribute("xsi:noNamespaceSchemaLocation", "../LocalizationSpec.xsd");
        return document;
    }

    private String getCopyrightHeader() {
        int n = Calendar.getInstance().get(1);
        return "Licensed Materials - Property of IBM\nIBM Cognos Products: LDK\n(C) Copyright IBM Corp. " + n + ".\n\n" + "US Government Users Restricted Rights - Use, duplication or\n" + "disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
    }

    private void copyFile(String string, String string2, String string3) {
        String string4 = string + File.separator + string3;
        String string5 = string2 + File.separator + string3;
        this.copyFile(string4, string5, true);
    }

    public static void main(String[] stringArray) {
        CCLMsgBrandLdkGenerator cCLMsgBrandLdkGenerator = new CCLMsgBrandLdkGenerator();
        Properties properties = new Properties();
        ArrayList arrayList = new ArrayList();
        CCLMsgConfigInfo.processCommandLine(stringArray, arrayList, properties);
        CCLPropertyBundle cCLPropertyBundle = null;
        if (!properties.isEmpty()) {
            cCLPropertyBundle = new CCLPropertyBundle(properties);
        }
        CCLMsgConfigInfo cCLMsgConfigInfo = new CCLMsgConfigInfo(cCLPropertyBundle);
        cCLMsgBrandLdkGenerator.execute(cCLMsgConfigInfo.getSrcDir(), cCLMsgConfigInfo.getTargetDir(), cCLMsgConfigInfo.getSrcLocale());
    }

    private class LdkSpecFilenameFilter
    implements FilenameFilter {
        private LdkSpecFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string != null && string.endsWith("_ldkspec.xml");
        }
    }
}

