/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLMsgBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class CCLMsgConfigInfo
extends CCLMsgBase {
    private static final String runProperty_Product_Locale = "Product Locale";
    private static final String runProperty_Content_Locale = "Content Locale";
    private String m_srcDir;
    private String m_alternateSchemaDir;
    private String m_srcLocale;
    private String m_refDir;
    private String m_translationDir;
    private String m_targetDir;
    private String m_sdkLocaleString;
    private List m_targetLocaleList;
    private String m_packageFileName;
    private String m_logFileName;
    private String m_compNameList;
    private String m_varInfo;
    private List m_ldkSpecList;
    private boolean m_allowUntranslatedStrings;
    private String m_localizationFilter;
    private String m_generate;
    private String m_BDDPackagingFile;
    private boolean m_bForReview = false;
    private Calendar m_calendar = Calendar.getInstance();
    private String INI_FILE = "LocalizationConfig";
    ResourceBundle m_configInfoRes;
    public static final String ALL_COMPONENT = "ALL";
    private static final String YES = "YES";
    private static final String SRC_DIR_KEY = "Source_Directory";
    private static final String SRC_LOCALE_KEY = "Source_Locale";
    private static final String REF_DIR_KEY = "Reference_Directory";
    private static final String TRANSLATION_DIR_KEY = "Synchronization_Directory";
    private static final String TARGET_DIR_KEY = "Target_Directory";
    private static final String TARGET_LOCALE_LIST_KEY = "Target_Locale_List";
    private static final String MSG_SDK_LOCALE_KEY = "LocalizationKit_Locale";
    private static final String PACKAGE_FILE_NAME_KEY = "Package_File";
    private static final String LOG_FILE_NAME_KEY = "Log_File";
    private static final String FOR_REVIEW_KEY = "For_Review";
    private static final String COMPONENT_NAME_LIST_KEY = "Component_Name_List";
    private static final String VAR_INFO_KEY = "VAR_Information";
    private static final String SPECIFICATION_LIST_KEY = "Specification_List";
    private static final String ALTERNATE_SCHEMA_DIR_KEY = "Alternate_Schema_Directory";
    private static final String ALLOW_UNTRANSLATED_STRINGS_KEY = "Allow_Untranslated_Strings";
    private static final String PURGE_TARGET_DIRECTORY_KEY = "Purge_Target_Directory";
    private static final String LOCALIZATION_FILTER_KEY = "Localization_Filter";
    private static final String GENERATE_KEY = "Generate";
    private static final String BDD_PACKAGING_FILE_KEY = "BDD_Packaging_File";
    public static final String ITEM_SEPARATOR = ",";

    public static void processCommandLine(String[] stringArray, List list, Properties properties) {
        int n = stringArray.length;
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        StringBuffer stringBuffer = null;
        if (n > 0) {
            try {
                for (int i = 0; i < n; ++i) {
                    String string4 = stringArray[i];
                    if (string4.startsWith("-")) {
                        String string5;
                        Object object;
                        if (string4.startsWith("-D")) {
                            object = new String();
                            string5 = new String();
                            if (string4.equals("-D")) {
                                if (i + 1 < n) {
                                    object = stringArray[++i];
                                } else {
                                    System.out.println("Required argument for -D option missing.");
                                    System.out.println("Expecting -D<property>[=<value>]");
                                    System.exit(1);
                                }
                            } else {
                                object = string4.substring(2);
                            }
                            int n2 = ((String)object).indexOf(61);
                            if (n2 > 0) {
                                if (n2 < ((String)object).length()) {
                                    string5 = ((String)object).substring(n2 + 1);
                                }
                                object = ((String)object).substring(0, n2);
                            }
                            properties.setProperty((String)object, string5);
                            continue;
                        }
                        if (string4.startsWith("-L")) {
                            if (string4.equals("-L")) {
                                if (i + 1 < n) {
                                    string = stringArray[++i];
                                } else {
                                    System.out.println("Required argument for -L option missing.");
                                    System.out.println("Expecting -L<localeListScript>");
                                    System.exit(1);
                                }
                            } else {
                                string = string4.substring(2);
                            }
                            CCLMsgConfigInfo.getImplicitLocales(string, properties);
                            continue;
                        }
                        if (string4.startsWith("-l")) {
                            if (string4.equals("-l")) {
                                if (i + 1 < n) {
                                    ++i;
                                    if (stringBuffer == null) {
                                        stringBuffer = new StringBuffer(stringArray[i].trim());
                                    } else {
                                        stringBuffer.append(ITEM_SEPARATOR);
                                        stringBuffer.append(stringArray[i].trim());
                                    }
                                }
                            } else if (stringBuffer == null) {
                                stringBuffer = new StringBuffer(stringArray[2].trim());
                            } else {
                                stringBuffer.append(ITEM_SEPARATOR);
                                stringBuffer.append(stringArray[2].trim());
                            }
                            if (stringBuffer.length() != 0) continue;
                            System.out.println("Required locale list for -l missing.");
                            System.out.println("You must provide one or more comma separated locales.");
                            System.exit(1);
                            continue;
                        }
                        if (string4.startsWith("-s")) {
                            boolean bl;
                            if (string4.equals("-s")) {
                                if (i + 1 < n) {
                                    string3 = stringArray[++i].trim();
                                }
                            } else {
                                string3 = string4.substring(2).trim();
                            }
                            if (string3.equals("")) {
                                System.out.println("Required locale list for -s missing.");
                                System.out.println("You must provide one or more comma separated locales.");
                                System.exit(1);
                            }
                            object = new File(string3);
                            string5 = new String(((File)object).getName());
                            String string6 = ((File)object).getParent();
                            if (string6 == null) {
                                string6 = ".";
                                bl = false;
                            } else {
                                bl = true;
                            }
                            String string7 = properties.containsKey(SRC_DIR_KEY) ? properties.getProperty(SRC_DIR_KEY) : ".";
                            if (!CCLMsgConfigInfo.comparePaths(string6, string7)) {
                                System.out.println("All explicitly specified ldkspecs must reside in the same Source Directory");
                                System.out.println("Otherwise, run LDK separately for each Source Directory ");
                                System.exit(1);
                            }
                            if (bl) {
                                properties.put(SRC_DIR_KEY, string6);
                            }
                            if (properties.containsKey(SPECIFICATION_LIST_KEY)) {
                                String string8 = properties.getProperty(SPECIFICATION_LIST_KEY);
                                string5 = string8 + ITEM_SEPARATOR + string5;
                            }
                            properties.put(SPECIFICATION_LIST_KEY, new String(string5));
                            continue;
                        }
                        System.out.println("Invalid command line argument specified: '" + string4 + "'");
                        System.exit(1);
                        continue;
                    }
                    list.add(new String(string4));
                }
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
                System.exit(1);
            }
        }
        if (stringBuffer != null) {
            properties.put(TARGET_LOCALE_LIST_KEY, stringBuffer.toString());
        }
        if (properties.size() > 0) {
            if (properties.containsKey(SRC_DIR_KEY)) {
                string2 = properties.getProperty(SRC_DIR_KEY);
            } else {
                string2 = new String(".");
                properties.setProperty(SRC_DIR_KEY, string2);
            }
            if (!properties.containsKey(TRANSLATION_DIR_KEY)) {
                properties.setProperty(TRANSLATION_DIR_KEY, new String(string2));
            }
            if (!properties.containsKey(GENERATE_KEY)) {
                properties.setProperty(GENERATE_KEY, new String("Release"));
            }
            if (!string2.endsWith("/")) {
                // empty if block
            }
            if (!properties.containsKey(REF_DIR_KEY)) {
                properties.setProperty(REF_DIR_KEY, string2 + File.separator + "LDK/Ref");
            }
            if (!properties.containsKey(PURGE_TARGET_DIRECTORY_KEY)) {
                properties.setProperty(PURGE_TARGET_DIRECTORY_KEY, new String("NO"));
            }
            if (!properties.containsKey(MSG_SDK_LOCALE_KEY)) {
                properties.setProperty(MSG_SDK_LOCALE_KEY, new String("en"));
            }
            if (!properties.containsKey(SRC_LOCALE_KEY)) {
                properties.setProperty(SRC_LOCALE_KEY, new String("en"));
            }
            Enumeration<?> enumeration = properties.propertyNames();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                int n4 = ((String)enumeration.nextElement()).length();
                if (n4 <= n3) continue;
                n3 = n4;
            }
            System.out.println("=============================================");
            System.out.println("Dynamic Localization Configuration Parameters");
            System.out.println("=============================================");
            enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string9 = (String)enumeration.nextElement();
                int n5 = string9.length();
                StringBuffer stringBuffer2 = new StringBuffer(string9);
                while (n5++ <= n3) {
                    stringBuffer2.append(" ");
                }
                stringBuffer2.append(" = '").append(properties.getProperty(string9)).append("'");
                System.out.println(stringBuffer2.toString());
            }
        }
    }

    public CCLMsgConfigInfo() {
        this.initialize(null);
    }

    public CCLMsgConfigInfo(ResourceBundle resourceBundle) {
        this.initialize(resourceBundle);
    }

    private void initialize(ResourceBundle resourceBundle) {
        Object[] objectArray;
        Object object;
        this.m_configInfoRes = resourceBundle == null ? ResourceBundle.getBundle(this.INI_FILE, Locale.ENGLISH) : resourceBundle;
        this.m_sdkLocaleString = "en";
        this.m_srcLocale = this.getResString(SRC_LOCALE_KEY, "");
        if (this.m_srcLocale.length() == 0) {
            this.m_srcLocale = "en";
            object = new Object[]{this.INI_FILE};
            CCLMsgConfigInfo.printLog(this.formatString(this.getResString("JMS_LOG_NO_SRC_LOCALE"), (Object[])object));
        } else {
            this.m_srcLocale = CCLMsgConfigInfo.normalizeLocale(this.m_srcLocale);
        }
        this.m_srcDir = this.getResString(SRC_DIR_KEY, "");
        if (this.m_srcDir.length() == 0) {
            object = new Object[]{this.INI_FILE};
            objectArray = this.formatString(this.getResString("JMS_INI_NO_SRC_DIR"), (Object[])object);
            this.abort(1, (String)objectArray);
        } else {
            this.m_srcDir = this.appendSeparator(this.m_srcDir);
        }
        this.m_alternateSchemaDir = this.getResString(ALTERNATE_SCHEMA_DIR_KEY, "");
        if (this.m_alternateSchemaDir.length() > 0) {
            this.m_alternateSchemaDir = this.appendSeparator(this.m_alternateSchemaDir);
        }
        this.m_ldkSpecList = CCLMsgConfigInfo.parseLDKSpecList(this.getResString(SPECIFICATION_LIST_KEY, null), ITEM_SEPARATOR);
        this.m_refDir = this.getResString(REF_DIR_KEY, "");
        if (this.m_refDir.length() == 0) {
            this.m_refDir = this.m_srcDir;
            object = new Object[]{this.INI_FILE};
            CCLMsgConfigInfo.printLog(this.formatString(this.getResString("JMS_LOG_NO_REF_DIR"), (Object[])object));
        } else {
            this.m_refDir = this.appendSeparator(this.m_refDir);
        }
        this.m_translationDir = this.getResString(TRANSLATION_DIR_KEY, "");
        if (this.m_translationDir.length() == 0) {
            this.m_translationDir = this.m_srcDir;
            object = new Object[]{this.INI_FILE};
            CCLMsgConfigInfo.printLog(this.formatString(this.getResString("JMS_LOG_NO_TRAN_DIR"), (Object[])object));
        } else {
            this.m_translationDir = this.appendSeparator(this.m_translationDir);
        }
        this.m_targetDir = this.getResString(TARGET_DIR_KEY, "");
        if (this.m_targetDir.length() == 0) {
            object = new Object[]{this.INI_FILE};
            objectArray = this.formatString(this.getResString("JMS_INI_NO_TARGET_DIR"), (Object[])object);
            this.abort(1, (String)objectArray);
        } else {
            this.m_targetDir = this.appendSeparator(this.m_targetDir);
        }
        this.m_packageFileName = this.getResString(PACKAGE_FILE_NAME_KEY, "");
        if (this.m_packageFileName.length() == 0) {
            this.m_packageFileName = null;
        }
        this.m_logFileName = this.getResString(LOG_FILE_NAME_KEY, "");
        if (this.m_logFileName.length() == 0) {
            this.m_logFileName = null;
            object = new Object[]{this.INI_FILE};
            CCLMsgConfigInfo.printLog(this.formatString(this.getResString("JMS_LOG_NO_LOG_FILE"), (Object[])object));
        }
        if (((String)(object = this.getResString(FOR_REVIEW_KEY, "NO"))).toUpperCase().compareTo(YES) == 0) {
            this.m_bForReview = true;
        }
        this.m_compNameList = this.getResString(COMPONENT_NAME_LIST_KEY, ALL_COMPONENT);
        this.m_varInfo = this.getResString(VAR_INFO_KEY, "");
        this.m_allowUntranslatedStrings = this.getResString(ALLOW_UNTRANSLATED_STRINGS_KEY, "NO").equalsIgnoreCase(YES);
        this.m_targetLocaleList = CCLMsgConfigInfo.parseTargetLocale(this.getResString(TARGET_LOCALE_LIST_KEY, ""), ITEM_SEPARATOR);
        if (this.m_targetLocaleList.size() == 0 && this.getResString(runProperty_Product_Locale, null) == null) {
            objectArray = new Object[]{this.INI_FILE};
            String string = this.formatString(this.getResString("JMS_INI_NO_TARGET_LOCALE"), objectArray);
            this.abort(1, string);
        }
        this.m_localizationFilter = this.getResString(LOCALIZATION_FILTER_KEY, runProperty_Product_Locale);
        this.m_generate = this.getResString(GENERATE_KEY, "Release");
        this.m_BDDPackagingFile = this.getResString(BDD_PACKAGING_FILE_KEY, null);
    }

    public String getResString(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.m_configInfoRes.getString(string);
            if (string3 != null) {
                string3 = string3.trim();
            }
            if (string3.length() == 0) {
                string3 = string2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            string3 = string2;
        }
        return string3;
    }

    public String getSrcDir() {
        return this.m_srcDir;
    }

    public String getSrcDir(boolean bl) {
        if (bl) {
            return this.getSrcDir();
        }
        String string = this.getSrcDir();
        return string.substring(0, string.lastIndexOf(File.separator));
    }

    public List getLDKSpecList() {
        return this.m_ldkSpecList;
    }

    public String resolveSchemaName(String string) {
        String string2 = this.m_alternateSchemaDir != null && new File(this.m_alternateSchemaDir + string).exists() ? this.m_alternateSchemaDir : this.m_srcDir;
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getSrcLocale() {
        return this.m_srcLocale;
    }

    public String getRefDir() {
        return this.m_refDir;
    }

    public String getTranslationDir() {
        return this.m_translationDir;
    }

    public String getTargetDir() {
        return this.m_targetDir;
    }

    public String getTargetDir(boolean bl) {
        if (bl) {
            return this.getTargetDir();
        }
        String string = this.getTargetDir();
        return string.substring(0, string.lastIndexOf(File.separator));
    }

    public String getSdkLocale() {
        return this.m_sdkLocaleString;
    }

    public List getTargetLocaleList() {
        return this.m_targetLocaleList;
    }

    public void setTargetLocaleList(List list) {
        this.m_targetLocaleList = list;
    }

    public Calendar getCalendar() {
        return this.m_calendar;
    }

    public String getPackageFileName() {
        return this.m_packageFileName;
    }

    public void setPackageFileName(String string) {
        this.m_packageFileName = string;
    }

    public static List parseTargetLocale(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = CCLMsgConfigInfo.normalizeLocale(stringTokenizer.nextToken().trim());
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static String normalizeLocale(String string) {
        String string2 = string.toLowerCase();
        return string2.replace('_', '-');
    }

    public static String unNormalizeLocale(String string) {
        if (string.length() > 2) {
            String string2 = string.substring(0, 2).toLowerCase() + '_' + string.substring(3, 5).toUpperCase();
            return string2;
        }
        return string;
    }

    public static List parseLDKSpecList(String string, String string2) {
        ArrayList<String> arrayList = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
            arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    private String appendSeparator(String string) {
        if (string.charAt(string.length() - 1) != '\\' && string.charAt(string.length() - 1) != '/') {
            string = string + File.separator;
        }
        return string;
    }

    public String getLogFileName() {
        return this.m_logFileName;
    }

    public boolean isForReview() {
        return this.m_bForReview;
    }

    public String getCompNameList() {
        return this.m_compNameList;
    }

    public String getVarInfo() {
        return this.m_varInfo;
    }

    public boolean allowUntranslatedStrings() {
        return this.m_allowUntranslatedStrings;
    }

    public boolean purgeTargetDir() {
        return this.getResString(PURGE_TARGET_DIRECTORY_KEY, YES).equalsIgnoreCase(YES);
    }

    public boolean allowLocalization(String string) {
        return this.m_localizationFilter.equalsIgnoreCase("None") || this.m_localizationFilter.equalsIgnoreCase(string);
    }

    public boolean allowGenerate(String string) {
        boolean bl = string != null ? (this.m_generate.equalsIgnoreCase("All") ? true : this.m_generate.equalsIgnoreCase(string)) : !this.m_generate.equalsIgnoreCase("Debug");
        return bl;
    }

    public String getBDDPackingFile() {
        return this.m_BDDPackagingFile;
    }

    private static void getImplicitLocales(String string, Properties properties) {
        try {
            int n;
            int n2;
            String[] stringArray = new String[3];
            File file = new File(string);
            if (!file.exists()) {
                throw new FileNotFoundException(string);
            }
            if (string.endsWith(".py")) {
                stringArray[0] = "python";
                stringArray[1] = string;
                n2 = 2;
            } else if (string.endsWith(".sh")) {
                stringArray[0] = "sh";
                stringArray[1] = string;
                n2 = 2;
            } else if (string.endsWith(".csh")) {
                stringArray[0] = "csh";
                stringArray[1] = string;
                n2 = 2;
            } else {
                stringArray[0] = string;
                stringArray[2] = "";
                n2 = 1;
            }
            stringArray[n2] = "-c";
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "ISO-8859-1"));
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = bufferedReader.read()) != -1) {
                if (n == 10 || n == 13 || n == 9) {
                    n = 32;
                }
                if (n == 32 && n3 == 32) continue;
                n3 = n;
                stringBuffer.append((char)n);
            }
            String string2 = stringBuffer.toString().trim();
            if (string2.length() == 0) {
                System.out.println("'" + string + " -c' did not return any locales");
                System.exit(1);
            }
            properties.setProperty(runProperty_Content_Locale, string2);
            stringArray[n2] = "-p";
            process = Runtime.getRuntime().exec(stringArray);
            bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "ISO-8859-1"));
            n3 = 0;
            stringBuffer = new StringBuffer();
            while ((n = bufferedReader.read()) != -1) {
                if (n == 10 || n == 13 || n == 9) {
                    n = 32;
                }
                if (n == 32 && n3 == 32) continue;
                n3 = n;
                stringBuffer.append((char)n);
            }
            while ((n = bufferedReader.read()) != -1) {
                if (n == 10 || n == 13) {
                    n = 32;
                }
                stringBuffer.append((char)n);
            }
            string2 = stringBuffer.toString().trim();
            if (string2.length() == 0) {
                System.out.println("'" + string + " -p' did not return any locales");
                System.exit(1);
            }
            properties.setProperty(runProperty_Product_Locale, string2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
    }

    public static boolean comparePaths(String string, String string2) {
        boolean bl = false;
        try {
            File file = new File(string);
            File file2 = new File(string2);
            bl = file.getCanonicalPath().compareTo(file2.getCanonicalPath()) == 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        CCLMsgConfigInfo cCLMsgConfigInfo = new CCLMsgConfigInfo();
        cCLMsgConfigInfo.getClass();
    }
}

