/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLMsgBase;
import com.cognos.localizationkit.CCLMsgXMLErrorHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CCLMsgDOM
extends CCLMsgBase {
    private boolean m_isValidation = false;
    private boolean m_isValid = true;
    private boolean m_isEncodingSet = false;
    private String m_xmlFileSchema = null;
    private File m_xmlFile = null;
    private Document m_doc = null;
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    public static final String FEATURE_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String PROPERTY_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    public CCLMsgDOM() {
    }

    public CCLMsgDOM(String string) {
        this.m_xmlFileSchema = string;
        this.m_isValidation = string != null;
    }

    public Document parseXmlFile(String string) {
        try {
            this.m_doc = this.parseWithSax(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{string};
            String string2 = this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray);
            this.abort(1, string2);
        }
        return this.m_doc;
    }

    public Document parseWithSax(String string) throws FileNotFoundException {
        File file = new File(string);
        return this.parseWithSax(file);
    }

    public Document parseWithSax(File file) throws FileNotFoundException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.m_xmlFile = file;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        if (this.m_isValidation) {
            object4 = null;
            try {
                object4 = this.getXMLFileName();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                CCLMsgDOM.abort(1);
            }
            this.m_isValid = this.validEncoding((String)object4);
            if (this.m_isValid) {
                if (this.m_xmlFileSchema == null) {
                    object3 = new StringBuffer(file.getParent());
                    ((StringBuffer)object3).append(File.separator);
                    ((StringBuffer)object3).append("CCLMessageFile.xsd");
                    this.m_xmlFileSchema = ((StringBuffer)object3).toString();
                }
                object3 = null;
                try {
                    object3 = this.convertFileNameToURL(this.m_xmlFileSchema);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    CCLMsgDOM.abort(1);
                }
                try {
                    sAXParserFactory.setValidating(false);
                    sAXParserFactory.setNamespaceAware(true);
                    object2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    sAXParserFactory.setSchema(((SchemaFactory)object2).newSchema(new Source[]{new StreamSource((String)object3)}));
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                    CCLMsgDOM.abort(1);
                }
            }
        }
        sAXParserFactory.setNamespaceAware(true);
        object4 = null;
        object3 = null;
        object2 = null;
        try {
            object4 = sAXParserFactory.newSAXParser();
            object3 = new SAXReader(((SAXParser)object4).getXMLReader());
            object2 = new CCLMsgXMLErrorHandler();
            object3.setErrorHandler((ErrorHandler)object2);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            CCLMsgDOM.abort(1);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            CCLMsgDOM.abort(1);
        }
        try {
            this.m_doc = object3.read(this.m_xmlFile);
        }
        catch (DocumentException documentException) {
            object = new Object[]{file.getName()};
            this.printError(this.formatString(this.getResString("JMS_DOM_DOCUMENT_EXCEPTION"), (Object[])object));
            this.printError(((CCLMsgXMLErrorHandler)((Object)object2)).getMsg(file.getName()));
            documentException.printStackTrace();
            CCLMsgDOM.abort(1);
        }
        if (!this.m_isValid || this.m_isValidation && object2 != null && !((CCLMsgXMLErrorHandler)((Object)object2)).isValid()) {
            Object[] objectArray = new Object[]{file};
            object = this.formatString(this.getResString("JMS_DOM_INVALID_XML"), objectArray);
            this.printError((String)object);
            this.printError(((CCLMsgXMLErrorHandler)((Object)object2)).getMsg(file.getName()));
            this.m_isValid = false;
            this.m_doc = null;
        }
        return this.m_doc;
    }

    public List getNodeList(Node node, String string) {
        XPath xPath = DocumentHelper.createXPath((String)string);
        return xPath.selectNodes((Object)node);
    }

    public Node getNode(Node node, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("[@");
        stringBuffer.append(string2);
        stringBuffer.append("='");
        stringBuffer.append(string3);
        stringBuffer.append("']");
        return node.selectSingleNode(stringBuffer.toString());
    }

    public void serializeToXML(Document document, String string, String string2) throws UnsupportedEncodingException, IOException {
        File file = new File(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.serializeToXML(document, string, bufferedOutputStream);
    }

    public void serializeToXML(Document document, String string, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setEncoding(string);
        if (!this.m_isEncodingSet) {
            outputFormat.setSuppressDeclaration(true);
            outputFormat.setOmitEncoding(true);
        } else {
            outputFormat.setSuppressDeclaration(false);
            outputFormat.setOmitEncoding(false);
        }
        XMLWriter xMLWriter = new XMLWriter(outputStream, outputFormat);
        xMLWriter.write(document);
        xMLWriter.flush();
        xMLWriter.close();
    }

    public boolean isValidation() {
        return this.m_isValidation;
    }

    public void setValidation(boolean bl) {
        this.m_isValidation = bl;
    }

    public String getXMLFileSchema() {
        return this.m_xmlFileSchema;
    }

    public void setXMLFileSchema(String string) {
        this.m_xmlFileSchema = string;
    }

    public Document getDocument() {
        return this.m_doc;
    }

    public String getXMLFileName() throws IOException {
        return this.m_xmlFile.getCanonicalPath();
    }

    public File getXMLFile() {
        return this.m_xmlFile;
    }

    public Node getComponentNode(Document document, String string, boolean bl) {
        Node node = null;
        if (document != null) {
            node = this.getNode((Node)document, "/stringTable/component", "name", string);
            if (bl && node == null) {
                System.out.println("Error: component '" + string + "' not found in stringTable.");
                System.out.println("Your reference and trans files must contain exactly the same component names. Fix this and try again.");
                System.exit(0);
            }
        }
        return node;
    }

    public Node getSectionNode(Element element, String string, boolean bl) {
        Node node = null;
        if (element != null) {
            node = this.getNode((Node)element, "section", "name", string);
            if (bl && node == null) {
                System.out.println("Error: section '" + string + "' not found in component '" + element.getDocument().getName());
                System.out.println("Your reference and trans files must contain exactly the same section names. Fix this and try again.");
                System.exit(0);
            }
        }
        return node;
    }

    public Node getStringNode(Element element, String string, String string2, boolean bl) {
        Node node = null;
        if (element != null) {
            node = this.getNode((Node)element, "string", string, string2);
            if (bl && node == null) {
                System.out.println("Error: string '" + string2 + "' not found in section '" + element.attributeValue("name") + "' of component '" + element.getParent().attributeValue("name") + "' in '" + element.getDocument().getName());
                System.out.println("Your reference and trans files must contain exactly the same strings. Fix this and try again.");
                System.exit(0);
            }
        }
        return node;
    }

    public boolean validEncoding(String string) {
        boolean bl = false;
        try {
            FileReader fileReader = new FileReader(string);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            String string2 = null;
            while ((string2 = lineNumberReader.readLine()) != null && string2.indexOf("<?") == -1) {
            }
            boolean bl2 = false;
            if (string2 != null) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                if (stringBuffer.indexOf("?>") > 0) {
                    bl2 = true;
                }
                boolean bl3 = false;
                while ((string2 = lineNumberReader.readLine()) != null && string2.indexOf("?>") == -1 && !bl2) {
                    stringBuffer.append(string2);
                    bl3 = true;
                }
                if (bl2 || bl3 && string2 != null) {
                    stringBuffer.append(string2);
                    if (stringBuffer.indexOf("encoding") > 0 && stringBuffer.indexOf(UTF8_ENCODING) > 0) {
                        this.m_isEncodingSet = true;
                        bl = true;
                    } else if (stringBuffer.indexOf("encoding") > 0) {
                        this.m_isEncodingSet = true;
                        bl = false;
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = true;
            }
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgDOM.abort(1);
        }
        return bl;
    }

    public String convertFileNameToURL(String string) throws MalformedURLException {
        String string2;
        Object[] objectArray;
        File file = new File(string);
        if (!file.exists()) {
            objectArray = new Object[]{string};
            string2 = this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray);
            this.abort(1, string2);
        }
        objectArray = file.toURL();
        string2 = objectArray.toString();
        return CCLMsgDOM.replace(string2, " ", "%20");
    }

    static String replace(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public static void main(String[] stringArray) {
        System.out.println("Test validate");
        String string = new String("C:\\Program Files\\cognos\\crn\\msgsdk\\CCLMessageFile.xsd");
        CCLMsgDOM cCLMsgDOM = new CCLMsgDOM(string);
        String string2 = new String("C:\\Translation\\Sync\\Log_fr.xml");
        cCLMsgDOM.parseXmlFile(string2);
        CCLMsgDOM.printLog("Done!");
    }
}

