/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLMsgBase;
import com.cognos.localizationkit.CCLMsgDOM;
import com.cognos.localizationkit.CCLMsgString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class CCLMsgFile
extends CCLMsgBase {
    private List m_msgList = null;
    private String m_xmlFileName = null;
    private CCLMsgDOM m_domParser = null;
    private String m_xmlFileSchema = null;
    private static Hashtable m_icuFormatCode = null;
    private static final int LOW_INDEX = 1;
    private static final int UP_INDEX = 10;
    public static final String STRINGTABLE_FULL_PATH = "/stringTable";
    public static final String STRINGTABLE_ATTRIBUTE_LOCALIZATION = "localization";
    public static final String COMPOMENT_FULL_PATH = "/stringTable/component";
    public static final String SECTION_FULL_PATH = "/stringTable/component/section";
    public static final String STRING_FULL_PATH = "/stringTable/component/section/string";
    public static final String NODE_STRING = "string";
    public static final String NODE_SECTION = "section";
    public static final String NODE_PARAM = "param";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_WHITESPACE = "whiteSpace";
    public static final String ATTRIBUTE_ERR_CODE = "errorCode";
    public static final String ATTRIBUTE_TRANSLATE = "translate";
    public static final String ATTRI_VALUE_NEW = "new";
    public static final String ATTRI_VALUE_CHANGED = "changed";
    public static final String STRING_DESCEN_PATH = ".//string";
    public static final String SECT_TYPE_MESSAGE = "Message";
    public static final String ATTRIBUTE_INDEX = "index";
    public static final String DEFAULT_ICU_FORMAT = "String";
    public static final String XML_MSG_FILE_SCHEMA = "CCLMessageFile.xsd";

    public CCLMsgFile() {
        this.m_xmlFileSchema = XML_MSG_FILE_SCHEMA;
    }

    public CCLMsgFile(String string) {
        this.m_xmlFileSchema = string;
    }

    public List ParseCCLMsg(String string) {
        this.m_xmlFileName = string;
        this.m_domParser = new CCLMsgDOM(this.m_xmlFileSchema);
        Document document = this.m_domParser.parseXmlFile(string);
        this.m_msgList = null;
        if (document != null) {
            this.m_msgList = new ArrayList();
            CCLMsgFile.getICUFormatCode();
            this.traverseDoc(document);
        }
        return this.m_msgList;
    }

    public boolean isHashCodeDuplicated(CCLMsgString cCLMsgString) {
        Object object;
        Object[] objectArray;
        long l = cCLMsgString.getHashCode();
        if (l == -1L) {
            objectArray = new Object[]{cCLMsgString.getCompName(), cCLMsgString.getSectName(), cCLMsgString.getMsgName(), this.m_xmlFileName};
            object = this.formatString(this.getResString("JMS_FOR_NO_NAME"), objectArray);
            this.abort(1, (String)object);
        }
        objectArray = this.m_msgList.listIterator();
        while (objectArray.hasNext()) {
            object = (CCLMsgString)objectArray.next();
            if (((CCLMsgString)object).getHashCode() != l) continue;
            return true;
        }
        return false;
    }

    public static Hashtable getICUFormatCode() {
        if (m_icuFormatCode == null) {
            CCLMsgFile.genICUFormatCode();
        }
        return m_icuFormatCode;
    }

    public String getXMLFileName() {
        return this.m_xmlFileName;
    }

    public List getMsgList() {
        return this.m_msgList;
    }

    public String getXMLFileSchema() {
        return this.m_xmlFileSchema;
    }

    public void setXMLMsgFileSchema(String string) {
        this.m_xmlFileSchema = string;
    }

    public String getLocalization(String string) {
        List list;
        ListIterator listIterator;
        String string2 = null;
        this.m_xmlFileName = string;
        this.m_domParser = new CCLMsgDOM(this.m_xmlFileSchema);
        Document document = this.m_domParser.parseXmlFile(string);
        if (this.m_domParser.isValid() && (listIterator = (list = this.m_domParser.getNodeList((Node)document, STRINGTABLE_FULL_PATH)).listIterator()).hasNext()) {
            Element element = (Element)listIterator.next();
            string2 = element.attributeValue(STRINGTABLE_ATTRIBUTE_LOCALIZATION);
        }
        if (string2 == null) {
            string2 = "Product Locale";
        }
        return string2;
    }

    public boolean checkIsTranslated(String string) {
        boolean bl = true;
        this.m_xmlFileName = string;
        this.m_domParser = new CCLMsgDOM(this.m_xmlFileSchema);
        Document document = this.m_domParser.parseXmlFile(string);
        if (this.m_domParser.isValid()) {
            List list = this.m_domParser.getNodeList((Node)document, STRING_FULL_PATH);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Element element = (Element)listIterator.next();
                String string2 = element.attributeValue(ATTRIBUTE_TRANSLATE);
                if (string2 == null) continue;
                String string3 = element.attributeValue(ATTRIBUTE_NAME);
                String string4 = element.getParent().attributeValue(ATTRIBUTE_NAME);
                String string5 = element.getParent().getParent().attributeValue(ATTRIBUTE_NAME);
                if (string3 == null) {
                    string3 = element.attributeValue(ATTRIBUTE_ID);
                }
                Object[] objectArray = new Object[]{string3, string2, string5, string4, this.m_xmlFileName};
                String string6 = this.formatString(this.getResString("JMS_FOR_NEED_TRANS"), objectArray);
                bl = false;
                this.printError(string6);
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void removeAttribute(String string, String string2) {
        Object[] objectArray;
        this.m_xmlFileName = string;
        this.m_domParser = new CCLMsgDOM(this.m_xmlFileSchema);
        this.m_domParser.validEncoding(string);
        Document document = this.m_domParser.parseXmlFile(string);
        List list = this.m_domParser.getNodeList((Node)document, STRING_FULL_PATH);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            objectArray = element.attribute(string2);
            if (objectArray == null) continue;
            element.remove((Attribute)objectArray);
        }
        try {
            this.m_domParser.serializeToXML(document, "UTF8", string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            objectArray = new Object[]{"UTF8"};
            String string3 = this.formatString(this.getResString("JMS_GEN_NO_REQ_ENCODING"), objectArray);
            this.abort(1, string3);
        }
        catch (IOException iOException) {
            objectArray = new Object[]{string};
            String string4 = this.formatString(this.getResString("JMS_FIL_WRITE_FAILED"), objectArray);
            this.abort(1, string4);
        }
    }

    private void traverseDoc(Document document) {
        List list = this.m_domParser.getNodeList((Node)document, STRING_FULL_PATH);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string;
            Object[] objectArray;
            Element element = (Element)listIterator.next();
            String string2 = element.attributeValue(ATTRIBUTE_NAME);
            String string3 = element.attributeValue(ATTRIBUTE_TYPE);
            String string4 = element.attributeValue(ATTRIBUTE_ERR_CODE);
            String string5 = element.attributeValue(ATTRIBUTE_WHITESPACE);
            String string6 = element.getParent().attributeValue(ATTRIBUTE_NAME);
            String string7 = element.getParent().attributeValue(ATTRIBUTE_TYPE);
            String string8 = element.getParent().getParent().attributeValue(ATTRIBUTE_NAME);
            if (string2 == null) {
                string2 = element.attributeValue(ATTRIBUTE_ID);
            }
            CCLMsgString cCLMsgString = new CCLMsgString();
            cCLMsgString.setCompName(string8);
            cCLMsgString.setSectName(string6);
            cCLMsgString.setSectType(string7);
            cCLMsgString.setMsgName(string2);
            cCLMsgString.setMsgErrCode(string4);
            cCLMsgString.setMsgType(string3);
            cCLMsgString.setWhiteSpace(string5);
            if (this.isHashCodeDuplicated(cCLMsgString)) {
                objectArray = new Object[]{cCLMsgString.getCompName(), cCLMsgString.getSectName(), cCLMsgString.getMsgName(), this.m_xmlFileName};
                string = this.formatString(this.getResString("JMS_FOR_DUPLICATE_HASH"), objectArray);
                this.abort(1, string);
            }
            if (cCLMsgString.getMsgErrCode() == null && cCLMsgString.getSectType().compareTo(SECT_TYPE_MESSAGE) == 0) {
                objectArray = new Object[]{cCLMsgString.getCompName(), cCLMsgString.getSectName(), cCLMsgString.getMsgName(), this.m_xmlFileName};
                string = this.formatString(this.getResString("JMS_FOR_NO_ERR_CODE"), objectArray);
                this.abort(1, string);
            }
            cCLMsgString.setMsgString(this.retriveMsgString(element, cCLMsgString));
            this.m_msgList.add(cCLMsgString);
        }
    }

    private String retriveMsgString(Element element, CCLMsgString cCLMsgString) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = element.nodeIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            short s = node.getNodeType();
            switch (s) {
                case 1: {
                    Object object;
                    bl = true;
                    boolean bl2 = true;
                    boolean bl3 = true;
                    String string = null;
                    int n = -1;
                    Object[] objectArray = ((Element)node).attributeIterator();
                    while (objectArray.hasNext()) {
                        object = (Attribute)objectArray.next();
                        if (object.getName().compareTo(ATTRIBUTE_INDEX) == 0) {
                            bl2 = false;
                            try {
                                n = Integer.parseInt(object.getText());
                            }
                            catch (NumberFormatException numberFormatException) {
                                Object[] objectArray2 = new Object[]{cCLMsgString.getCompName(), cCLMsgString.getSectName(), cCLMsgString.getMsgName(), this.m_xmlFileName};
                                String string2 = this.formatString(this.getResString("JMS_FOR_NO_INTEGER"), objectArray2);
                                this.abort(1, string2);
                            }
                            continue;
                        }
                        if (object.getName().compareTo(ATTRIBUTE_TYPE) == 0) {
                            bl3 = false;
                            string = object.getText();
                            continue;
                        }
                        if (object.getName().compareTo(ATTRIBUTE_NAME) != 0) continue;
                    }
                    if (bl2) {
                        objectArray = new Object[]{cCLMsgString.getCompName(), cCLMsgString.getSectName(), cCLMsgString.getMsgName(), this.m_xmlFileName};
                        object = this.formatString(this.getResString("JMS_FOR_NO_INDEX"), objectArray);
                        this.abort(1, (String)object);
                    } else if (n > 10 || n < 1) {
                        objectArray = new Object[]{cCLMsgString.getCompName(), cCLMsgString.getSectName(), cCLMsgString.getMsgName(), this.m_xmlFileName, new Integer(1), new Integer(10)};
                        object = this.formatString(this.getResString("JMS_FOR_BAD_INDEX"), objectArray);
                        this.abort(1, (String)object);
                    }
                    if (bl3) {
                        string = DEFAULT_ICU_FORMAT;
                    }
                    objectArray = (String)m_icuFormatCode.get(string);
                    if (!bl3 && objectArray == null) {
                        object = new Object[]{cCLMsgString.getCompName(), cCLMsgString.getSectName(), cCLMsgString.getMsgName(), this.m_xmlFileName};
                        String string3 = this.formatString(this.getResString("JMS_FOR_BAD_ICU_TYPE"), (Object[])object);
                        this.abort(1, string3);
                    }
                    if (objectArray == null) break;
                    object = new StringBuffer((String)objectArray);
                    ((StringBuffer)object).replace(1, 3, Integer.toString(n - 1));
                    stringBuffer.append(((StringBuffer)object).toString());
                    break;
                }
                case 3: {
                    stringBuffer.append(node.getText());
                }
            }
        }
        if (bl) {
            return this.replaceToken(stringBuffer.toString(), "'", "''");
        }
        return stringBuffer.toString();
    }

    private static void genICUFormatCode() {
        m_icuFormatCode = new Hashtable(12);
        m_icuFormatCode.put("shortTime", "{%d,time,short}");
        m_icuFormatCode.put("mediumTime", "{%d,time,medium}");
        m_icuFormatCode.put("longTime", "{%d,time,long}");
        m_icuFormatCode.put("fullTime", "{%d,time,full}");
        m_icuFormatCode.put("shortDate", "{%d,date,short}");
        m_icuFormatCode.put("mediumDate", "{%d,date,medium}");
        m_icuFormatCode.put("longDate", "{%d,date,long}");
        m_icuFormatCode.put("fullDate", "{%d,date,full}");
        m_icuFormatCode.put("currency", "{%d,number,currency}");
        m_icuFormatCode.put("percent", "{%d,number,percent}");
        m_icuFormatCode.put("integer", "{%d,number,integer}");
        m_icuFormatCode.put(NODE_STRING, "{%d}");
    }

    public static void main(String[] stringArray) throws UnsupportedEncodingException, IOException {
        String string = "S:\\CCL_Latest\\src\\CCL\\Messages\\udamsgs_en.xml";
        CCLMsgFile cCLMsgFile = new CCLMsgFile();
        try {
            cCLMsgFile.ParseCCLMsg(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        CCLMsgFile.printLog("Done");
    }
}

