/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLBinaryMsgFile;
import com.cognos.localizationkit.CCLMsgBase;
import com.cognos.localizationkit.CCLMsgBrandLdkGenerator;
import com.cognos.localizationkit.CCLMsgConfigInfo;
import com.cognos.localizationkit.CCLMsgDOM;
import com.cognos.localizationkit.CCLMsgProcessor;
import com.cognos.localizationkit.CCLMsgZip;
import com.cognos.localizationkit.CCLPropertyBundle;
import com.cognos.localizationkit.LDKProcessSpecsFilter;
import com.cognos.localizationkit.Transformation;
import com.cognos.localizationkit.TransformationKey;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class CCLMsgLocalizer
extends CCLMsgBase {
    private CCLMsgDOM m_xmlSpecParser = null;
    private CCLMsgProcessor m_msgProcessor = null;
    private TreeMap m_msgFileMap = null;
    private TreeMap m_msgFileLocalizationMap = null;
    private CCLMsgConfigInfo m_configInfo = null;
    private List m_resultFileList = new ArrayList();
    private boolean m_bCreateZipFile = true;
    private boolean m_hasMissingFile = false;
    private boolean m_hasInvalidFile = false;
    static final String MESSAGE_LOCALIZATION_SPEC = "LocalizationSpec.xml";
    private static final String MESSAGE_LOCALIZATION_SPEC_SCHEMA = "LocalizationSpec.xsd";
    private static final String TRANSFORMATIONS_PATH = "transformations/transformation";
    private static final String MESSAGEFILE_FULL_PATH = "messageFiles/messageFile";
    private static final String TARGET_DIR_DESCEN_PATH = ".//targetDir";
    private static final String ELEMENT_XSLTOPTIONS = "xsltOptions";
    private static final String ELEMENT_CUSTOMOPTIONS = "customOptions";
    private static final String ATTRIBUTE_SCRIPT = "script";
    private static final String ATTRIBUTE_PROCESS = "process";
    private static final String ATTRIBUTE_BASE_NAME = "baseName";
    private static final String TARGETDIR_ATTRIBUTE_DIR = "dir";
    private static final String TARGETDIR_ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_COMPONENT = "component";
    private static final String ATTRIBUTE_TARGET_FILE_EXTENSION = "targetFileExtension";
    private static final String ATTRIBUTE_TARGET_FILE_TYPE = "targetFileType";

    public static void main(String[] stringArray) {
        boolean bl = true;
        Properties properties = new Properties();
        ArrayList arrayList = new ArrayList();
        CCLMsgConfigInfo.processCommandLine(stringArray, arrayList, properties);
        CCLPropertyBundle cCLPropertyBundle = null;
        if (!properties.isEmpty()) {
            cCLPropertyBundle = new CCLPropertyBundle(properties);
        }
        CCLMsgLocalizer cCLMsgLocalizer = new CCLMsgLocalizer(cCLPropertyBundle);
        if (arrayList.size() != 1) {
            System.out.println("Usage: CCLMsgLocalizer <command>");
            System.out.println("Where command could be one of the following:");
            System.out.println("    sync ");
            System.out.println("        synchronzize XML message files");
            System.out.println("    validate");
            System.out.println("        validate XML message files");
            System.out.println("    generate");
            System.out.println("        generate target message files");
            System.out.println("    clean");
            System.out.println("        remove translate attribute from message files in synchronization directory");
            System.out.println("    genbrandldkspec");
            System.out.println("        generate brand ldkspec");
            System.exit(1);
        }
        String string = (String)arrayList.get(0);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, cCLMsgLocalizer.getResLocale());
        String string2 = "***** " + string + " - " + dateFormat.format(new Date()) + " *****";
        if (string.toLowerCase().compareTo("sync") == 0) {
            CCLMsgLocalizer.printLog(string2);
            bl = cCLMsgLocalizer.procSyncTrans();
        } else if (string.toLowerCase().compareTo("validate") == 0) {
            CCLMsgLocalizer.printLog(string2);
            bl = cCLMsgLocalizer.procValidate();
        } else if (string.toLowerCase().compareTo("generate") == 0) {
            CCLMsgLocalizer.printLog("***** validate - " + dateFormat.format(new Date()) + " *****");
            bl = cCLMsgLocalizer.procValidate();
            if (bl) {
                CCLMsgLocalizer.printLog(string2);
                bl = cCLMsgLocalizer.procGenerate();
            }
        } else if (string.toLowerCase().compareTo("clean") == 0) {
            CCLMsgLocalizer.printLog(string2);
            bl = cCLMsgLocalizer.procRemoveTranslateAttribute();
        } else if (string.toLowerCase().compareTo("devgenerate") == 0) {
            bl = cCLMsgLocalizer.procGenerate();
        } else if (string.toLowerCase().compareTo("genbrandldkspec") == 0) {
            CCLMsgLocalizer.printLog("***** genbrandldkspec - " + dateFormat.format(new Date()) + " *****");
            bl = cCLMsgLocalizer.procGenerateBrandLdk();
        } else {
            System.out.println("Unknown command <" + string + "> is specified.");
            System.exit(1);
        }
        if (bl) {
            System.out.println();
            System.out.println("Command '" + string + "' has finished successfully.");
            CCLMsgLocalizer.printLog("");
        } else {
            System.out.println();
            System.out.println("Command '" + string + "' has finished unsuccessfully.");
            CCLMsgLocalizer.printLog("");
            System.exit(1);
        }
    }

    public CCLMsgLocalizer(ResourceBundle resourceBundle) {
        this.m_configInfo = new CCLMsgConfigInfo(resourceBundle);
        this.createLogWriter(this.m_configInfo.getLogFileName());
        this.m_xmlSpecParser = new CCLMsgDOM(this.getMsgLocalizationSpecSchema());
        this.m_msgProcessor = new CCLMsgProcessor();
        this.m_msgProcessor.setConfigInfo(this.m_configInfo);
        if (this.m_bCreateZipFile) {
            this.m_msgProcessor.setResultFileList(this.m_resultFileList);
        }
    }

    public void procExtractDelta() {
        TreeMap treeMap = this.getMsgFileMap();
        Set set = treeMap.keySet();
        List list = this.m_configInfo.getTargetLocaleList();
        for (int i = 0; i < list.size(); ++i) {
            this.m_msgProcessor.setTargetLocale((String)list.get(i));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.m_msgProcessor.extractDelta((String)iterator.next());
            }
        }
    }

    public void procMergeDelta() {
        TreeMap treeMap = this.getMsgFileMap();
        Set set = treeMap.keySet();
        List list = this.m_configInfo.getTargetLocaleList();
        for (int i = 0; i < list.size(); ++i) {
            this.m_msgProcessor.setTargetLocale((String)list.get(i));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.m_msgProcessor.mergeDelta((String)iterator.next());
            }
        }
    }

    public boolean procSyncTrans() {
        boolean bl = true;
        TreeMap treeMap = this.getMsgFileMap();
        if (this.m_hasInvalidFile || treeMap == null || treeMap.size() <= 0) {
            bl = false;
        } else {
            Set set = treeMap.keySet();
            List list = this.m_configInfo.getTargetLocaleList();
            for (int i = 0; i < list.size(); ++i) {
                this.m_msgProcessor.setTargetLocale((String)list.get(i));
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.m_msgProcessor.syncTrans((String)iterator.next());
                }
            }
        }
        if (this.m_hasMissingFile || this.m_hasInvalidFile) {
            bl = false;
        }
        return bl;
    }

    public boolean procValidate() {
        boolean bl = true;
        TreeMap treeMap = this.getMsgFileMap();
        boolean bl2 = bl = !this.m_hasMissingFile && !this.m_hasInvalidFile;
        if (bl && treeMap != null && treeMap.size() > 0) {
            Set set = treeMap.keySet();
            List list = this.m_configInfo.getTargetLocaleList();
            if (list == null || list.size() == 0) {
                for (String string : set) {
                    list = CCLMsgConfigInfo.parseTargetLocale(this.m_configInfo.getResString((String)this.m_msgFileLocalizationMap.get(string), ""), " ");
                    for (int i = 0; i < list.size(); ++i) {
                        this.m_msgProcessor.setTargetLocale((String)list.get(i));
                        this.m_msgProcessor.validate(string);
                    }
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.m_msgProcessor.setTargetLocale((String)list.get(i));
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        this.m_msgProcessor.validate((String)iterator.next());
                    }
                }
            }
        }
        if (!this.m_msgProcessor.isAllTranslated() || this.m_hasMissingFile || this.m_hasInvalidFile) {
            bl = false;
        }
        if (bl) {
            CCLMsgLocalizer.printLog(this.getResString("JMS_LOG_FILES_READY"));
        }
        return bl;
    }

    public boolean procGenerate() {
        TreeMap treeMap;
        boolean bl = true;
        if (this.m_configInfo.purgeTargetDir()) {
            System.out.println("Purging '" + this.m_configInfo.getTargetDir() + "'");
            this.deleteDir(new File(this.m_configInfo.getTargetDir()));
        }
        if ((treeMap = this.getMsgFileMap()) != null && treeMap.size() > 0) {
            Object object52;
            Object object;
            Collection<Object> collection;
            Object object3;
            Object object422;
            Set set = treeMap.keySet();
            List list = this.m_configInfo.getTargetLocaleList();
            if (list != null && list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    this.m_msgProcessor.setTargetLocale((String)list.get(i));
                    for (Object object422 : set) {
                        object3 = (TreeMap)treeMap.get(object422);
                        collection = ((TreeMap)object3).keySet();
                        for (String string : collection) {
                            object = (Transformation)((TreeMap)object3).get(string);
                            if (this.m_msgProcessor.generate((String)object422, ((Transformation)object).m_procType, ((Transformation)object).m_procSrc, ((Transformation)object).m_procSpec, ((Transformation)object).m_targetType, ((Transformation)object).m_targetExt, ((Transformation)object).getDirs())) continue;
                            bl = false;
                        }
                    }
                }
            }
            for (Object object52 : set) {
                object422 = (TreeMap)treeMap.get(object52);
                object3 = ((TreeMap)object422).keySet();
                collection = CCLMsgConfigInfo.parseTargetLocale(this.m_configInfo.getResString((String)this.m_msgFileLocalizationMap.get(object52), ""), " ");
                for (int i = 0; i < collection.size(); ++i) {
                    String string = (String)collection.get(i);
                    if (list.contains(string)) continue;
                    this.m_msgProcessor.setTargetLocale(string);
                    object = object3.iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        Transformation transformation = (Transformation)((TreeMap)object422).get(string2);
                        if (this.m_msgProcessor.generate((String)object52, transformation.m_procType, transformation.m_procSrc, transformation.m_procSpec, transformation.m_targetType, transformation.m_targetExt, transformation.getDirs())) continue;
                        bl = false;
                    }
                }
            }
            object52 = this.m_configInfo.getBDDPackingFile();
            if (object52 != null && (object422 = this.m_msgProcessor.getResultFileList()) != null) {
                this.appendBDDPackingFile((String)object52, (List)object422);
            }
            if (this.m_configInfo.getPackageFileName() != null) {
                object422 = new CCLMsgZip();
                object3 = new ArrayList();
                ((CCLMsgBase)object422).getFileList(new File(this.m_configInfo.getTargetDir()), (List)object3);
                ((CCLMsgZip)object422).zip((List<String>)object3, this.m_configInfo.getTargetDir(), this.m_configInfo.getPackageFileName());
            }
        } else {
            bl = false;
        }
        if (this.m_hasMissingFile || this.m_hasInvalidFile) {
            bl = false;
        }
        return bl;
    }

    public boolean procRemoveTranslateAttribute() {
        boolean bl = true;
        TreeMap treeMap = this.getMsgFileMap();
        if (treeMap != null && treeMap.size() > 0) {
            Set set = treeMap.keySet();
            List list = this.m_configInfo.getTargetLocaleList();
            for (int i = 0; i < list.size(); ++i) {
                this.m_msgProcessor.setTargetLocale((String)list.get(i));
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.m_msgProcessor.removeAttribute((String)iterator.next(), "translate");
                }
            }
        } else {
            bl = false;
        }
        if (this.m_hasMissingFile || this.m_hasInvalidFile) {
            bl = false;
        }
        return bl;
    }

    public boolean procGenerateBrandLdk() {
        return new CCLMsgBrandLdkGenerator().execute(this.m_configInfo.getSrcDir(true), this.m_configInfo.getTargetDir(true), this.m_configInfo.getSrcLocale());
    }

    private boolean isRequired(String string) {
        boolean bl = false;
        String string2 = this.m_configInfo.getCompNameList();
        int n = string2.toLowerCase().indexOf(string.toLowerCase());
        int n2 = string2.toLowerCase().indexOf("ALL".toLowerCase());
        bl = n != -1 || n2 != -1;
        return bl;
    }

    private void addMessageFile(TreeMap treeMap, Element element) {
        String string = element.attributeValue(ATTRIBUTE_BASE_NAME);
        List list = element.selectNodes(TRANSFORMATIONS_PATH);
        TreeMap treeMap2 = null;
        if (treeMap.containsKey(string)) {
            treeMap2 = (TreeMap)treeMap.get(string);
        } else {
            treeMap2 = new TreeMap();
            treeMap.put(string, treeMap2);
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            List list2;
            Object object;
            String string2;
            Element element2 = (Element)listIterator.next();
            String string3 = string2 = element2.attributeValue(ATTRIBUTE_PROCESS).trim();
            Node node = null;
            String string4 = null;
            String string5 = null;
            if (string2.compareTo("xslt") == 0) {
                object = element2.element(ELEMENT_XSLTOPTIONS);
                if (object != null) {
                    string3 = object.attributeValue(ATTRIBUTE_SCRIPT);
                    string4 = object.attributeValue(ATTRIBUTE_TARGET_FILE_EXTENSION);
                    string5 = object.attributeValue(ATTRIBUTE_TARGET_FILE_TYPE);
                }
            } else if (string2.compareTo("custom") == 0 && (object = element2.element(ELEMENT_CUSTOMOPTIONS)) != null) {
                string3 = object.attributeValue("impl");
                string4 = object.attributeValue(ATTRIBUTE_TARGET_FILE_EXTENSION);
                string5 = object.attributeValue(ATTRIBUTE_TARGET_FILE_TYPE);
                node = element2.element(ELEMENT_CUSTOMOPTIONS).selectSingleNode("properties");
            }
            if (string4 != null) {
                string4 = string4.trim();
            }
            if (string5 != null) {
                string5 = string5.trim();
            }
            object = null;
            String string6 = TransformationKey.get(string3, string5, string4, node);
            if (!treeMap2.containsKey(string6)) {
                object = new Transformation(string2, string3, string5, string4);
                ((Transformation)object).m_procSpec = node;
                treeMap2.put(string6, object);
            } else {
                object = (Transformation)treeMap2.get(string6);
            }
            if ((list2 = element2.selectNodes(TARGET_DIR_DESCEN_PATH)) == null) continue;
            Object[] objectArray = list2.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string7 = ((Element)objectArray[i]).attributeValue(TARGETDIR_ATTRIBUTE_TYPE);
                if (string7 != null) {
                    string7 = string7.trim();
                }
                if (!this.m_configInfo.allowGenerate(string7)) continue;
                ((Transformation)object).addDir(((Element)objectArray[i]).attributeValue(TARGETDIR_ATTRIBUTE_DIR).trim());
            }
        }
    }

    private TreeMap getMsgFileMap() {
        if (this.m_msgFileMap == null) {
            Object[] objectArray;
            List<String> list;
            Object object;
            StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getSrcDir());
            File file = new File(this.m_configInfo.getSrcDir());
            LDKProcessSpecsFilter lDKProcessSpecsFilter = new LDKProcessSpecsFilter();
            TreeMap treeMap = new TreeMap();
            TreeMap treeMap2 = new TreeMap();
            TreeMap<String, Object[]> treeMap3 = new TreeMap<String, Object[]>();
            CCLBinaryMsgFile cCLBinaryMsgFile = new CCLBinaryMsgFile(this.m_msgProcessor.getXMLFileSchema());
            if (!file.isDirectory()) {
                object = new Object[]{stringBuffer.toString()};
                this.abort(1, this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), (Object[])object));
            }
            if ((list = this.m_configInfo.getLDKSpecList()) == null) {
                list = Arrays.asList(file.list(lDKProcessSpecsFilter));
            }
            if (list.size() == 0) {
                object = stringBuffer;
                ((StringBuffer)object).append("*_ldkspec.xml");
                objectArray = new Object[]{((StringBuffer)object).toString()};
                this.abort(1, this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray));
            }
            for (int i = 0; i < list.size(); ++i) {
                objectArray = list.get(i) + "...";
                CCLMsgLocalizer.printLog((String)objectArray);
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(this.m_configInfo.getSrcDir());
                stringBuffer2.append((Object)list.get(i));
                Document document = this.m_xmlSpecParser.parseXmlFile(stringBuffer2.toString());
                if (document == null) {
                    this.m_hasInvalidFile = true;
                }
                List list2 = this.m_xmlSpecParser.getNodeList((Node)document, MESSAGEFILE_FULL_PATH);
                ListIterator listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    Element element = (Element)listIterator.next();
                    if (!this.isRequired(element.attributeValue(ATTRIBUTE_COMPONENT))) continue;
                    String string = element.attributeValue(ATTRIBUTE_BASE_NAME);
                    if (!treeMap.containsKey(string)) {
                        Object[] objectArray2;
                        if (treeMap2.containsKey(string)) continue;
                        String string2 = CCLMsgProcessor.getSrcXMLFileName(this.m_configInfo.getSrcDir(), string, this.m_configInfo.getSrcLocale());
                        File file2 = new File(string2);
                        if (file2.exists()) {
                            objectArray2 = cCLBinaryMsgFile.getLocalization(string2);
                            if (objectArray2 == null) {
                                this.m_hasInvalidFile = true;
                                continue;
                            }
                            if (!this.m_configInfo.allowLocalization((String)objectArray2)) continue;
                            treeMap3.put(string, objectArray2);
                            this.addMessageFile(treeMap, element);
                            continue;
                        }
                        objectArray2 = new Object[]{string2};
                        CCLMsgLocalizer.printLog(this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray2));
                        this.m_hasMissingFile = true;
                        treeMap2.put(string, null);
                        continue;
                    }
                    this.addMessageFile(treeMap, element);
                }
            }
            this.m_msgFileMap = treeMap;
            this.m_msgFileLocalizationMap = treeMap3;
        }
        return this.m_msgFileMap;
    }

    private String getMsgLocalizationSpecSchema() {
        return this.m_configInfo.resolveSchemaName(MESSAGE_LOCALIZATION_SPEC_SCHEMA);
    }

    private void appendBDDPackingFile(String string, List list) {
        File file = new File(string);
        if (!file.exists()) {
            CCLMsgLocalizer.printLog("File '" + string + "' does not exist. Create it.");
            boolean bl = false;
            try {
                bl = file.createNewFile();
            }
            catch (IOException iOException) {
                this.printError("IOException was caught when create file '" + string + "'");
                iOException.printStackTrace();
                CCLMsgLocalizer.abort(1);
            }
            if (!bl) {
                this.printError("Unable to create file '" + string + "'");
                CCLMsgLocalizer.abort(1);
            }
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            for (String string2 : list) {
                File file2 = new File(string2);
                if (file2.exists()) {
                    try {
                        bufferedWriter.write(file2.getCanonicalPath());
                        bufferedWriter.newLine();
                    }
                    catch (IOException iOException) {
                        this.printError("IOException was caught when writing to file '" + string2 + "'");
                        iOException.printStackTrace();
                        CCLMsgLocalizer.abort(1);
                    }
                    continue;
                }
                this.printError("Unable to append '" + string2 + "' into '" + string + "'. '" + string2 + "' does not exist.");
                CCLMsgLocalizer.abort(1);
            }
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.printError("IOException was caught with file '" + string + "'");
            iOException.printStackTrace();
            CCLMsgLocalizer.abort(1);
        }
    }
}

