/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLBinaryMsgFile;
import com.cognos.localizationkit.CCLMsgBase;
import com.cognos.localizationkit.CCLMsgConfigInfo;
import com.cognos.localizationkit.CCLMsgSyncTrans;
import com.cognos.localizationkit.CCLMsgValidateTrans;
import com.cognos.localizationkit.CCLMsgXMLTransformer;
import com.cognos.localizationkit.ExternalProcess;
import com.cognos.localizationkit.ExternalProcessException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.dom4j.Element;
import org.dom4j.Node;

public class CCLMsgProcessor
extends CCLMsgBase {
    private HashMap<String, ExternalProcess> externalProcessCache = new HashMap();
    private boolean m_isAllTranslated = true;
    private String m_baseName = null;
    private String m_procInstruction = null;
    private List m_dirList = null;
    private List m_resultFileList = null;
    private String m_targetLocale = null;
    private CCLMsgConfigInfo m_configInfo = null;
    private String m_XMLFileSchema = null;
    private CCLBinaryMsgFile m_binaryMsgFile = null;
    private CCLMsgXMLTransformer m_msgTransformer = null;
    private CCLMsgSyncTrans m_msgSyncTrans = null;
    private CCLMsgValidateTrans m_msgValTrans = null;
    private static final String TARGET_BIN_MESSAGE_FILE = "BMF";
    private static final String TARGET_CUSTOM_MESSAGE_FILE = "custom";
    private static final String TARGET_DIRECT_CONSUMED = "Copy";
    private static final String TARGET_JAVA_PROPERTY = "CCLXmlToProperties.xslt";
    private static final String TARGET_JAVA_PROPERTY2 = "CCLXmlToProperties2.xslt";
    private static final String TARGET_INPUT_SOURCE = "CCLInputSource.xslt";
    private static final String ENCODING_SEPARATOR = "_";
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String BINARY_MSG_FILE_EXTENSION = ".bmf";
    private static final String JAVA_PROPERTY_FILE_EXTENSION = ".properties";
    private static final String DELTA_POSTFIX = "_DELTA";
    private static final String TRANSLATION_POSTFIX = "";
    private static final String REFENCE_FILE_POSTFIX = "_REF";
    private final String TYPE_JAVA_PROPERTIES_FILE = "Java Properties";
    private final String TYPE_TEXT_FILE = "Text";
    private final String TYPE_XML_FILE = "XML";

    public void syncTrans(String string) {
        this.m_baseName = string;
        String string2 = this.getSrcXMLFileName();
        String string3 = this.getRefXMLFileName();
        String string4 = this.getTranslatedXMLFileName();
        String string5 = this.getTranslatedXMLFileName();
        this.m_msgSyncTrans = new CCLMsgSyncTrans(null);
        this.m_msgSyncTrans.setCalendar(this.m_configInfo.getCalendar());
        this.m_msgSyncTrans.setForReview(this.m_configInfo.isForReview());
        this.m_msgSyncTrans.processSyncTran(string2, string3, string4, string5);
    }

    public void extractDelta(String string) {
        this.m_baseName = string;
        String string2 = this.getTranslatedXMLFileName();
        String string3 = this.getDeltaXMLFileName();
        this.m_msgSyncTrans = new CCLMsgSyncTrans(null);
        this.m_msgSyncTrans.extractDelta(string2, string3);
    }

    public void mergeDelta(String string) {
        this.m_baseName = string;
        String string2 = this.getTranslatedXMLFileName();
        String string3 = this.getDeltaXMLFileName();
        this.m_msgSyncTrans = new CCLMsgSyncTrans(null);
        this.m_msgSyncTrans.mergeDelta(string2, string3);
    }

    public void validate(String string) {
        this.m_baseName = string;
        String string2 = this.getTranslatedXMLFileName();
        String string3 = this.getRefXMLFileName();
        if (!this.isXMLFileExisted(string2) || !this.isXMLFileExisted(string3)) {
            this.m_isAllTranslated = false;
            return;
        }
        this.m_msgValTrans = new CCLMsgValidateTrans(null);
        if (!this.m_msgValTrans.validateTran(string3, string2)) {
            this.m_isAllTranslated = false;
            return;
        }
        CCLBinaryMsgFile cCLBinaryMsgFile = new CCLBinaryMsgFile(this.getXMLFileSchema());
        if (!cCLBinaryMsgFile.checkIsTranslated(string2)) {
            this.m_isAllTranslated = false;
        }
    }

    public void removeAttribute(String string, String string2) {
        this.m_baseName = string;
        String string3 = this.getTranslatedXMLFileName();
        CCLBinaryMsgFile cCLBinaryMsgFile = new CCLBinaryMsgFile(null);
        if (!new File(string3).exists()) {
            Object[] objectArray = new Object[]{string3};
            String string4 = this.formatString(this.getResString("JMS_LOG_FILE_NOT_FOUND"), objectArray);
            CCLMsgProcessor.printLog(string4);
            return;
        }
        cCLBinaryMsgFile.removeAttribute(string3, string2);
    }

    public boolean generate(String string, String string2, String string3, Node node, String string4, String string5, List list) {
        this.m_baseName = string;
        this.m_dirList = list;
        this.m_procInstruction = string3;
        boolean bl = false;
        String string6 = null;
        boolean bl2 = false;
        if (this.m_dirList != null && this.m_dirList.size() > 0) {
            this.m_binaryMsgFile = new CCLBinaryMsgFile(this.getXMLFileSchema());
            if (this.m_configInfo.getVarInfo().length() != 0) {
                this.m_binaryMsgFile.setVarInfo(this.m_configInfo.getVarInfo());
            }
            this.m_msgTransformer = new CCLMsgXMLTransformer(null);
            String string7 = this.getTranslatedXMLFileName();
            if (!this.isXMLFileExisted(string7)) {
                return bl;
            }
            String string8 = (String)this.m_dirList.get(0);
            String string9 = null;
            string6 = string5;
            if (string2.compareTo(TARGET_BIN_MESSAGE_FILE) == 0) {
                string6 = BINARY_MSG_FILE_EXTENSION;
                string9 = this.getTargetFileName(string8, string6);
                this.createBinaryMsgFile(string7, string9);
                bl = true;
            } else if (string2.compareTo(TARGET_CUSTOM_MESSAGE_FILE) == 0) {
                String string10 = string + string3 + string4 + string5 + node.hashCode();
                ExternalProcess externalProcess = this.externalProcessCache.get(string10);
                try {
                    Object object;
                    if (externalProcess == null) {
                        externalProcess = (ExternalProcess)Class.forName(string3).newInstance();
                        this.externalProcessCache.put(string10, externalProcess);
                        object = this.getExternalProcessSpec(node);
                        ((Properties)object).put("type", string4);
                        ((Properties)object).put("ext", string6);
                        externalProcess.init((Properties)object);
                    }
                    if ((object = externalProcess.getBaseName()) != null) {
                        string = object;
                    }
                    string9 = this.getTargetFileName(string8, string6, string);
                    Properties properties = this.loadExternalProcessMsgs(string7);
                    bl = externalProcess.generate(this.getTargetLocale(), properties, string9);
                }
                catch (Exception exception) {
                    CCLMsgProcessor.printLog("Error executing external process: baseName=" + string + ", procSrc=" + string3);
                    exception.printStackTrace();
                }
            } else if (string2.compareTo(TARGET_DIRECT_CONSUMED) == 0) {
                string6 = XML_FILE_EXTENSION;
                string9 = this.getTargetFileName(string8, string6);
                this.createDirectConsumedFile(string7, string9);
                bl = true;
            } else if (this.m_procInstruction.compareTo(TARGET_INPUT_SOURCE) == 0) {
                string6 = XML_FILE_EXTENSION;
                string9 = this.getTargetFileName(string8, string6);
                bl = this.transformFile(string7, "XML", TARGET_INPUT_SOURCE, string9);
            } else if (this.m_procInstruction.compareTo(TARGET_JAVA_PROPERTY) == 0 || this.m_procInstruction.compareTo(TARGET_JAVA_PROPERTY2) == 0) {
                boolean bl3 = bl2 = string4 == null && string5 == null || string4 != null && string4.compareTo("Java Properties") == 0;
                if (bl2) {
                    if (string6 == null) {
                        string6 = JAVA_PROPERTY_FILE_EXTENSION;
                    }
                    string9 = this.getIsoTargetFileName(string8, string6);
                    String string11 = this.getTempFileName(string6);
                    bl = this.transformFile(string7, "Text", this.m_procInstruction, string11);
                    if (bl) {
                        this.createParentDir(string9);
                        this.native2Ascii(string11, string9);
                    }
                } else {
                    string6 = string5 != null && string5.length() != 0 ? CCLMsgProcessor.checkFileExtension(string5) : TRANSLATION_POSTFIX;
                    string9 = this.getIsoTargetFileName(string8, string6);
                    bl = this.transformFile(string7, string4, this.m_procInstruction, string9);
                }
            } else {
                String string12 = null;
                if (string5 != null && string5.length() != 0) {
                    string6 = CCLMsgProcessor.checkFileExtension(string5);
                }
                if (string6 != null) {
                    string12 = string6.toLowerCase().compareTo(JAVA_PROPERTY_FILE_EXTENSION) == 0 ? "Java Properties" : (string6.toLowerCase().compareTo(XML_FILE_EXTENSION) == 0 ? "XML" : "Text");
                } else {
                    string6 = TRANSLATION_POSTFIX;
                }
                if (string4 != null) {
                    if (string4.compareTo("Java Properties") == 0) {
                        string12 = "Java Properties";
                    } else if (string4.compareTo("XML") == 0) {
                        string12 = "XML";
                    } else if (string4.compareTo("Text") == 0) {
                        string12 = "Text";
                    }
                }
                if (string12.compareTo("Java Properties") == 0) {
                    bl2 = true;
                    string9 = this.getIsoTargetFileName(string8, string6);
                    String string13 = this.getTempFileName(string6);
                    bl = this.transformFile(string7, "Text", this.m_procInstruction, string13);
                    if (bl) {
                        this.createParentDir(string9);
                        this.native2Ascii(string13, string9);
                    }
                } else {
                    string9 = this.getTargetFileName(string8, string6);
                    bl = this.transformFile(string7, string12, this.m_procInstruction, string9);
                }
            }
            if (bl) {
                this.addToResultFileList(string9);
                if (this.m_dirList.size() > 1) {
                    this.copyTargetFileToOthers(string9, string6);
                }
                this.processExtraTargetFile(string9, string8, string, string6, bl2);
            }
        }
        return bl;
    }

    private Properties getExternalProcessSpec(Node node) throws ExternalProcessException {
        Properties properties = new Properties();
        List list = node.selectNodes("entry");
        for (Node node2 : list) {
            if (!(node2 instanceof Element)) continue;
            Element element = (Element)node2;
            properties.setProperty(element.attributeValue("key"), element.getText());
        }
        return properties;
    }

    private Properties loadExternalProcessMsgs(String string) throws ExternalProcessException {
        String string2 = this.getTempFileName(JAVA_PROPERTY_FILE_EXTENSION);
        File file = new File(string2.replace(JAVA_PROPERTY_FILE_EXTENSION, "n2a.properties"));
        file.deleteOnExit();
        boolean bl = this.transformFile(string, "Text", TARGET_JAVA_PROPERTY, string2);
        if (bl) {
            this.native2Ascii(string2, file.getPath());
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
                return properties;
            }
            catch (Exception exception) {
                throw new ExternalProcessException("Error transforming performing Native2Ascii conversion on msg properties", exception);
            }
        }
        throw new ExternalProcessException("Error transforming " + string + " to properties");
    }

    private void processExtraTargetFile(String string, String string2, String string3, String string4, boolean bl) {
        boolean bl2;
        boolean bl3;
        CharSequence charSequence;
        boolean bl4;
        boolean bl5;
        CharSequence charSequence2;
        boolean bl6;
        boolean bl7;
        CharSequence charSequence3;
        boolean bl8;
        String string5 = new String(this.getTargetLocale());
        StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getTargetDir());
        stringBuffer.append(string2);
        stringBuffer.append(File.separator);
        stringBuffer.append(string3);
        boolean bl9 = bl8 = bl && string5.compareToIgnoreCase("en") == 0 && string4 != null && string4.toLowerCase().compareTo(JAVA_PROPERTY_FILE_EXTENSION) == 0;
        if (bl8) {
            charSequence3 = new StringBuffer(stringBuffer.toString());
            ((StringBuffer)charSequence3).append(string4);
            this.copyFile(string, ((StringBuffer)charSequence3).toString());
            this.addToResultFileList(((StringBuffer)charSequence3).toString());
            if (this.m_dirList.size() > 1) {
                this.copyTargetFileToOthers(((StringBuffer)charSequence3).toString(), string4);
            }
        }
        charSequence3 = null;
        boolean bl10 = bl7 = string5.substring(0, 2).compareToIgnoreCase("in") == 0;
        if (bl7) {
            charSequence3 = new String("id");
        }
        boolean bl11 = bl6 = string5.substring(0, 2).compareToIgnoreCase("id") == 0;
        if (bl6) {
            charSequence3 = new String("in");
        }
        if (string5.length() > 2) {
            charSequence3 = (String)charSequence3 + string5.substring(2);
        }
        if (bl7 || bl6) {
            charSequence2 = new StringBuffer(stringBuffer.toString());
            ((StringBuffer)charSequence2).append(ENCODING_SEPARATOR);
            if (bl) {
                ((StringBuffer)charSequence2).append(CCLMsgConfigInfo.unNormalizeLocale((String)charSequence3));
            } else {
                ((StringBuffer)charSequence2).append((String)charSequence3);
            }
            ((StringBuffer)charSequence2).append(string4);
            this.copyFile(string, ((StringBuffer)charSequence2).toString());
            this.addToResultFileList(((StringBuffer)charSequence2).toString());
            if (this.m_dirList.size() > 1) {
                this.copyTargetFileToOthers(((StringBuffer)charSequence2).toString(), string4);
            }
        }
        charSequence2 = null;
        boolean bl12 = bl5 = string5.substring(0, 2).compareToIgnoreCase("iw") == 0;
        if (bl5) {
            charSequence2 = new String("he");
        }
        boolean bl13 = bl4 = string5.substring(0, 2).compareToIgnoreCase("he") == 0;
        if (bl4) {
            charSequence2 = new String("iw");
        }
        if (string5.length() > 2) {
            charSequence2 = (String)charSequence2 + string5.substring(2);
        }
        if (bl5 || bl4) {
            charSequence = new StringBuffer(stringBuffer.toString());
            ((StringBuffer)charSequence).append(ENCODING_SEPARATOR);
            if (bl) {
                ((StringBuffer)charSequence).append(CCLMsgConfigInfo.unNormalizeLocale((String)charSequence2));
            } else {
                ((StringBuffer)charSequence).append((String)charSequence2);
            }
            ((StringBuffer)charSequence).append(string4);
            this.copyFile(string, ((StringBuffer)charSequence).toString());
            this.addToResultFileList(((StringBuffer)charSequence).toString());
            if (this.m_dirList.size() > 1) {
                this.copyTargetFileToOthers(((StringBuffer)charSequence).toString(), string4);
            }
        }
        charSequence = null;
        boolean bl14 = bl3 = string5.substring(0, 2).compareToIgnoreCase("no") == 0;
        if (bl3) {
            charSequence = new String("nb");
        }
        boolean bl15 = bl2 = string5.substring(0, 2).compareToIgnoreCase("nb") == 0;
        if (bl2) {
            charSequence = new String("no");
        }
        if (string5.length() > 2) {
            charSequence = (String)charSequence + string5.substring(2);
        }
        if (bl3 || bl2) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            stringBuffer2.append(ENCODING_SEPARATOR);
            if (bl) {
                stringBuffer2.append(CCLMsgConfigInfo.unNormalizeLocale((String)charSequence));
            } else {
                stringBuffer2.append((String)charSequence);
            }
            stringBuffer2.append(string4);
            this.copyFile(string, stringBuffer2.toString());
            this.addToResultFileList(stringBuffer2.toString());
            if (this.m_dirList.size() > 1) {
                this.copyTargetFileToOthers(stringBuffer2.toString(), string4);
            }
        }
    }

    public static String checkFileExtension(String string) {
        if (string.charAt(0) != '.') {
            return '.' + string;
        }
        return string;
    }

    private void copyTargetFileToOthers(String string, String string2) {
        for (int i = 1; i < this.m_dirList.size(); ++i) {
            StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getTargetDir());
            stringBuffer.append((String)this.m_dirList.get(i));
            stringBuffer.append(File.separator);
            stringBuffer.append(string.substring(string.lastIndexOf(File.separator)));
            this.copyFile(string, stringBuffer.toString());
            this.addToResultFileList(stringBuffer.toString());
        }
    }

    public void createBinaryMsgFile(String string, String string2) {
        string2 = this.createParentDir(string2);
        try {
            this.m_binaryMsgFile.output(string, string2);
            try {
                Object[] objectArray = new Object[]{new File(string2).getCanonicalPath(), new File(string).getCanonicalPath()};
                String string3 = this.formatString(this.getResString("JMS_LOG_GEN_FILE"), objectArray);
                CCLMsgProcessor.printLog(string3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                CCLMsgProcessor.abort(1);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{string2};
            String string4 = this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray);
            this.abort(1, string4);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string2};
            String string5 = this.formatString(this.getResString("JMS_FIL_WRITE_FAILED"), objectArray);
            this.abort(1, string5);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            CCLMsgProcessor.abort(1);
        }
    }

    public void createDirectConsumedFile(String string, String string2) {
        string2 = this.createParentDir(string2);
        this.copyFile(string, string2);
    }

    private boolean transformFile(String string, String string2, String string3, String string4) {
        string4 = this.createParentDir(string4);
        boolean bl = false;
        String string5 = this.m_configInfo.resolveSchemaName(string3);
        if (!new File(string5).exists()) {
            Object[] objectArray = new Object[]{string5};
            CCLMsgProcessor.printLog(this.formatString(this.getResString("JMS_FIL_NOT_FOUND"), objectArray));
            return bl;
        }
        bl = string2.compareTo("XML") == 0 ? this.m_msgTransformer.transformToXmlFile(string, string5, string4) : this.m_msgTransformer.transformToTextFile(string, string5, string4);
        if (bl) {
            try {
                Object[] objectArray = new Object[]{new File(string4).getCanonicalPath(), new File(string).getCanonicalPath()};
                String string6 = this.formatString(this.getResString("JMS_LOG_GEN_FILE"), objectArray);
                CCLMsgProcessor.printLog(string6);
                return bl;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                CCLMsgProcessor.abort(1);
            }
        }
        return bl;
    }

    private String getTranslatedXMLFileName() {
        StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getTranslationDir());
        stringBuffer.append(this.m_baseName);
        stringBuffer.append(ENCODING_SEPARATOR);
        stringBuffer.append(this.getTargetLocale());
        stringBuffer.append(TRANSLATION_POSTFIX);
        stringBuffer.append(XML_FILE_EXTENSION);
        return new File(stringBuffer.toString()).getPath();
    }

    private String getTargetFileName(String string, String string2) {
        return this.getTargetFileName(string, string2, null);
    }

    private String getTargetFileName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getTargetDir());
        stringBuffer.append(string);
        stringBuffer.append(File.separator);
        stringBuffer.append(string3 != null ? string3 : this.m_baseName);
        stringBuffer.append(ENCODING_SEPARATOR);
        stringBuffer.append(this.getTargetLocale());
        stringBuffer.append(string2);
        return new File(stringBuffer.toString()).getPath();
    }

    private String getIsoTargetFileName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getTargetDir());
        stringBuffer.append(string);
        stringBuffer.append(File.separator);
        stringBuffer.append(this.m_baseName);
        stringBuffer.append(ENCODING_SEPARATOR);
        stringBuffer.append(CCLMsgConfigInfo.unNormalizeLocale(this.getTargetLocale()));
        stringBuffer.append(string2);
        return new File(stringBuffer.toString()).getPath();
    }

    public static String getSrcXMLFileName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string2);
        stringBuffer.append(ENCODING_SEPARATOR);
        stringBuffer.append(string3);
        stringBuffer.append(XML_FILE_EXTENSION);
        return new File(stringBuffer.toString()).getPath();
    }

    private String getSrcXMLFileName() {
        return CCLMsgProcessor.getSrcXMLFileName(this.m_configInfo.getSrcDir(), this.m_baseName, this.m_configInfo.getSrcLocale());
    }

    private String getRefXMLFileName() {
        StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getRefDir());
        stringBuffer.append(this.m_baseName);
        stringBuffer.append(ENCODING_SEPARATOR);
        stringBuffer.append(this.getTargetLocale());
        stringBuffer.append(REFENCE_FILE_POSTFIX);
        stringBuffer.append(XML_FILE_EXTENSION);
        return new File(stringBuffer.toString()).getPath();
    }

    private String getTempFileName(String string) {
        String string2 = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(this.m_baseName);
            stringBuffer.append(ENCODING_SEPARATOR);
            stringBuffer.append(CCLMsgConfigInfo.unNormalizeLocale(this.getTargetLocale()));
            File file = File.createTempFile(stringBuffer.toString(), string);
            string2 = file.getCanonicalPath();
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgProcessor.abort(1);
        }
        return string2;
    }

    private String getDeltaXMLFileName() {
        StringBuffer stringBuffer = new StringBuffer(this.m_configInfo.getTranslationDir());
        stringBuffer.append(this.m_baseName);
        stringBuffer.append(ENCODING_SEPARATOR);
        stringBuffer.append(this.getTargetLocale());
        stringBuffer.append(TRANSLATION_POSTFIX);
        stringBuffer.append(DELTA_POSTFIX);
        stringBuffer.append(XML_FILE_EXTENSION);
        return new File(stringBuffer.toString()).getPath();
    }

    public void setConfigInfo(CCLMsgConfigInfo cCLMsgConfigInfo) {
        this.m_configInfo = cCLMsgConfigInfo;
    }

    public String getXMLFileSchema() {
        if (this.m_XMLFileSchema == null) {
            this.m_XMLFileSchema = this.m_configInfo.resolveSchemaName("CCLMessageFile.xsd");
        }
        return this.m_XMLFileSchema;
    }

    public void setXMLFileSchema(String string) {
        this.m_XMLFileSchema = string;
    }

    public String getTargetLocale() {
        return this.m_targetLocale;
    }

    public void setTargetLocale(String string) {
        this.m_targetLocale = string;
    }

    public List getResultFileList() {
        return this.m_resultFileList;
    }

    public void setResultFileList(List list) {
        this.m_resultFileList = list;
    }

    public boolean isAllTranslated() {
        return this.m_isAllTranslated || this.m_configInfo.allowUntranslatedStrings();
    }

    private void addToResultFileList(String string) {
        this.addToList(this.m_resultFileList, string);
    }

    private void addToList(List list, Object object) {
        if (list != null && !list.contains(object)) {
            list.add(object);
        }
    }

    private void native2Ascii(String string, String string2) {
        Object[] objectArray;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string3 = null;
        StringBuffer stringBuffer = null;
        Character c = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            objectArray = new OutputStreamWriter((OutputStream)new FileOutputStream(string2, false), "ASCII");
            bufferedWriter = new BufferedWriter((Writer)objectArray);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer = new StringBuffer();
                for (int i = 0; i < string3.length(); ++i) {
                    c = Character.valueOf(string3.charAt(i));
                    if (c.charValue() <= '\u007f') {
                        stringBuffer.append(c);
                        continue;
                    }
                    StringBuffer stringBuffer2 = new StringBuffer(Integer.toHexString(c.charValue()));
                    for (int j = 4 - stringBuffer2.length(); j > 0; --j) {
                        stringBuffer2.insert(0, '0');
                    }
                    stringBuffer.append("\\u").append(stringBuffer2);
                }
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.newLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            CCLMsgProcessor.abort(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CCLMsgProcessor.abort(1);
        }
        objectArray = new Object[]{string2, string};
        String string4 = this.formatString(this.getResString("JMS_LOG_GEN_FILE"), objectArray);
        CCLMsgProcessor.printLog(string4);
    }

    private boolean isXMLFileExisted(String string) {
        if (!new File(string).exists()) {
            Object[] objectArray = new Object[]{string};
            String string2 = this.formatString(this.getResString("JMS_LOG_FILE_NOT_FOUND"), objectArray);
            CCLMsgProcessor.printLog(string2);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        System.out.println("Nothing is implemented in the main");
    }
}

