/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLMsgBase;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class CCLMsgString
extends CCLMsgBase
implements Comparable {
    private String m_compName = null;
    private String m_sectName = null;
    private String m_sectType = null;
    private String m_msgName = null;
    private String m_msgType = null;
    private String m_msgErrCode = null;
    private String m_msgString = null;
    private String m_whiteSpace = null;
    private long m_hashCode = 0L;
    private int m_msgStringUTF8Length = 0;
    private byte[] m_msgStringUTF8Byte = null;
    public static final String SECT_TYPE_MESSAGE = "Messages";
    private static final String PREFIX_MSG_SEPARATOR = " ";

    public long getHashCode() {
        if (this.m_hashCode == 0L) {
            this.m_hashCode = CCLMsgString.genHashCode(this.m_compName, this.m_sectName, this.m_msgName);
        }
        return this.m_hashCode;
    }

    public String getPrefix() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCompName());
        stringBuffer.append("-");
        stringBuffer.append(this.getSectName());
        stringBuffer.append("-");
        stringBuffer.append(this.getMsgErrCode());
        return stringBuffer.toString();
    }

    public String getCompName() {
        return this.m_compName;
    }

    public String getSectName() {
        return this.m_sectName;
    }

    public String getMsgName() {
        return this.m_msgName;
    }

    public String getSectType() {
        return this.m_sectType;
    }

    public String getMsgType() {
        return this.m_msgType;
    }

    public String getMsgErrCode() {
        return this.m_msgErrCode;
    }

    public String getMsgString() {
        return this.m_msgString;
    }

    public String getWhiteSpace() {
        return this.m_whiteSpace;
    }

    public int getMsgStringUTF8Length() {
        return this.m_msgStringUTF8Length;
    }

    public byte[] getMsgStringUTF8Byte() {
        return this.m_msgStringUTF8Byte;
    }

    public void setCompName(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.m_compName = string;
    }

    public void setSectName(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.m_sectName = string;
    }

    public void setMsgName(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.m_msgName = string;
    }

    public void setSectType(String string) {
        this.m_sectType = string != null ? (string = string.trim()) : SECT_TYPE_MESSAGE;
    }

    public void setMsgType(String string) {
        this.m_msgType = string;
    }

    public void setWhiteSpace(String string) {
        this.m_whiteSpace = string;
    }

    public void setMsgErrCode(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.m_msgErrCode = string;
    }

    public void setMsgString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSectType().compareTo(SECT_TYPE_MESSAGE) == 0) {
            stringBuffer.append(this.getPrefix());
            stringBuffer.append(PREFIX_MSG_SEPARATOR);
        }
        if (string != null) {
            if (this.m_whiteSpace == null || this.m_whiteSpace.compareTo("preserve") != 0) {
                stringBuffer.append(CCLMsgString.stripws(string));
            } else {
                stringBuffer.append(string);
            }
        }
        this.m_msgString = stringBuffer.toString();
        try {
            StringBuffer stringBuffer2 = new StringBuffer(this.m_msgString);
            stringBuffer2.append("\u0000");
            this.m_msgStringUTF8Byte = stringBuffer2.toString().getBytes("UTF8");
            this.m_msgStringUTF8Length = this.m_msgStringUTF8Byte.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            Object[] objectArray = new Object[]{"UTF8"};
            String string2 = this.formatString(this.getResString("JMS_GEN_BAD_ENCODING"), objectArray);
            this.abort(1, string2);
        }
    }

    public int compareTo(Object object) {
        CCLMsgString cCLMsgString = (CCLMsgString)object;
        if (this.getHashCode() < cCLMsgString.getHashCode()) {
            return -1;
        }
        if (this.getHashCode() > cCLMsgString.getHashCode()) {
            return 1;
        }
        Object[] objectArray = new Object[]{this.getCompName() + "/" + this.getSectName() + "/" + this.getMsgName()};
        String string = this.formatString(this.getResString("JMS_FOR_DUPLICATE_HASH"), objectArray);
        this.abort(1, string);
        return 0;
    }

    public static long genHashCode(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return -1L;
        }
        long l = CCLMsgString.hash(string + string2, 64L, 4095L);
        long l2 = CCLMsgString.hash(string3, 64L, 1048575L);
        return l << 20 | l2;
    }

    private static long hash(String string, long l, long l2) {
        long l3 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l3 = (l3 * l + (long)string.charAt(i)) % l2;
        }
        return l3;
    }

    private static String stripws(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.length();
        if (n > 0 && (n = (string2 = string.trim()).length()) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n2 = 0;
            int n3 = stringTokenizer.countTokens();
            while (n2 != n3) {
                String string3 = stringTokenizer.nextToken();
                if (n2++ > 0) {
                    stringBuffer.append(PREFIX_MSG_SEPARATOR);
                }
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }
}

