/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit;

import com.cognos.localizationkit.CCLMsgBase;
import com.cognos.localizationkit.CCLMsgDOM;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;

public class CCLMsgXMLTransformer
extends CCLMsgBase {
    private Transformer m_transformer = null;
    private String m_styleSheet = null;
    private String m_xmlFileSchema = "CCLMessageFile.xsd";
    private CCLMsgDOM m_domParser = null;

    public CCLMsgXMLTransformer() {
        this.m_xmlFileSchema = "CCLMessageFile.xsd";
        this.m_styleSheet = null;
    }

    public CCLMsgXMLTransformer(String string) {
        this.m_xmlFileSchema = string;
        this.m_styleSheet = null;
    }

    public CCLMsgXMLTransformer(String string, String string2) {
        this.m_xmlFileSchema = string;
        this.m_styleSheet = string2;
    }

    public boolean transformToXmlFile(String string, String string2, String string3) {
        boolean bl = true;
        try {
            this.createDomParser(this.m_xmlFileSchema);
            this.createTransformer(string2);
            bl = this.transformToXmlFile(string, string3);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            Object[] objectArray = new Object[]{string2};
            String string4 = this.formatString(this.getResString("JMS_DOM_TRANSFORMERCONFIGURATION_EXCEPTION"), objectArray);
            this.abort(1, string4);
        }
        return bl;
    }

    public boolean transformToXmlFile(String string, String string2) {
        boolean bl = true;
        try {
            this.createDomParser(this.m_xmlFileSchema);
            Document document = this.m_domParser.parseXmlFile(string);
            if (document == null) {
                bl = false;
            } else {
                Document document2 = this.transToDomDoc(document);
                this.m_domParser.serializeToXML(document2, "UTF8", string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Object[] objectArray = new Object[]{"UTF8"};
            String string3 = this.formatString(this.getResString("JMS_GEN_NO_REQ_ENCODING"), objectArray);
            this.abort(1, string3);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            Object[] objectArray = new Object[]{string, string2};
            String string4 = this.formatString(this.getResString("JMS_DOM_TRANSFORMER_EXCEPTION"), objectArray);
            this.abort(1, string4);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string2};
            String string5 = this.formatString(this.getResString("JMS_FIL_WRITE_FAILED"), objectArray);
            this.abort(1, string5);
        }
        return bl;
    }

    public boolean transformToTextFile(String string, String string2, String string3) {
        boolean bl = true;
        try {
            this.createDomParser(this.m_xmlFileSchema);
            this.createTransformer(string2);
            bl = this.transformToTextFile(string, string3);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            Object[] objectArray = new Object[]{string2};
            String string4 = this.formatString(this.getResString("JMS_DOM_TRANSFORMERCONFIGURATION_EXCEPTION"), objectArray);
            this.abort(1, string4);
        }
        return bl;
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.m_transformer = transformer;
    }

    public boolean transformToTextFile(String string, String string2) {
        boolean bl = true;
        try {
            Document document = this.m_domParser.parseXmlFile(string);
            if (document == null) {
                bl = false;
            } else {
                this.transToTextFile(document, string2);
            }
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            Object[] objectArray = new Object[]{string, string2};
            String string3 = this.formatString(this.getResString("JMS_DOM_TRANSFORMER_EXCEPTION"), objectArray);
            this.abort(1, string3);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string2};
            String string4 = this.formatString(this.getResString("JMS_FIL_WRITE_FAILED"), objectArray);
            this.abort(1, string4);
        }
        return bl;
    }

    public String getStyleSheet() {
        return this.m_styleSheet;
    }

    public void setStyleSheet(String string) throws TransformerConfigurationException {
        this.createTransformer(string);
    }

    public String getXMLFileSchema() {
        return this.m_xmlFileSchema;
    }

    public void setXMLFileSchema(String string) {
        this.createDomParser(string);
    }

    private void createTransformer(String string) throws TransformerConfigurationException {
        if (this.m_transformer == null || string != null && string.compareTo(this.m_styleSheet) != 0) {
            this.m_styleSheet = string;
            StreamSource streamSource = new StreamSource(new File(string));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.m_transformer = transformerFactory.newTransformer(streamSource);
        }
    }

    private void createDomParser(String string) {
        if (this.m_domParser == null || string != null && string.compareTo(this.m_xmlFileSchema) != 0) {
            this.m_xmlFileSchema = string;
            this.m_domParser = new CCLMsgDOM(this.m_xmlFileSchema);
        }
    }

    private Document transToDomDoc(Document document) throws TransformerException {
        DocumentSource documentSource = new DocumentSource(document);
        DocumentResult documentResult = new DocumentResult();
        this.m_transformer.transform((Source)documentSource, (Result)documentResult);
        return documentResult.getDocument();
    }

    private void transToTextFile(Document document, String string) throws TransformerException, IOException {
        DocumentSource documentSource = new DocumentSource(document);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        StreamResult streamResult = new StreamResult(bufferedOutputStream);
        this.m_transformer.transform((Source)documentSource, streamResult);
        bufferedOutputStream.close();
    }

    public static void main(String[] stringArray) {
        String string = "S:\\CCL_Latest\\src\\CCL\\Resources\\CCLInputSource.xslt";
        String string2 = "S:\\CCL_Latest\\win32\\bind\\cclmsgs_en.xml";
        String string3 = "S:\\CCL_Latest\\win32\\bind\\cclmsgs_en_after_inputsource.xml";
        String string4 = "S:\\MessageSDK\\src\\MessageSDK\\message\\CCLMessageFile.xsd";
        CCLMsgXMLTransformer cCLMsgXMLTransformer = new CCLMsgXMLTransformer(string4);
        string = "S:/CCL_Latest/src/CCL/Resources/CCLXmlToProperties.xslt";
        string2 = "S:/CCL_Latest/src/localizationkit/message/cclmsgsdk_en.xml";
        string3 = "S:/CCL_Latest/src/localizationkit/message/cclmsgsdk.properties";
        cCLMsgXMLTransformer.transformToTextFile(string2, string, string3);
        CCLMsgXMLTransformer.printLog("Done!");
    }
}

