/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit.extension.i18nimage;

import com.cognos.localizationkit.CCLMsgFile;
import com.cognos.localizationkit.ExternalProcess;
import com.cognos.localizationkit.ExternalProcessException;
import com.cognos.localizationkit.extension.i18nimage.Image;
import com.cognos.localizationkit.extension.i18nimage.ImageTemplate;
import com.cognos.localizationkit.extension.i18nimage.Label;
import com.cognos.localizationkit.extension.i18nimage.LabelTemplate;
import com.cognos.localizationkit.extension.i18nimage.MessagesManager;
import com.cognos.localizationkit.extension.i18nimage.RootImage;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ImageGenerator
implements ExternalProcess {
    private static final String LOGO_ECLIPSE_SRC = "images/eclipse.png";
    private static final String LOGO_JAVA_SRC = "images/java.png";
    private static final int SPACE_BETWEEN_LOGOS = 20;
    private Label productLabel = null;
    private Label versionLabel = null;
    private Label legalLabel = null;
    private Properties props = null;
    private HashMap<String, Properties> propertiesCache = new HashMap();
    private RootImage rootImage = null;
    private RootImage rootImage_rtl = null;
    private MessagesManager messagesManager = MessagesManager.getInstance();

    private RootImage buildRootImage(ImageTemplate template, boolean hasEclipseLogo, boolean hasJavaLogo, boolean isRTL) throws ExternalProcessException {
        int y;
        String src = template.getSrc();
        if (isRTL) {
            StringBuilder src_rtl = new StringBuilder(src);
            src_rtl.insert(src.indexOf("."), "_rtl");
            src = src_rtl.toString();
        }
        String type = template.getType();
        RootImage rootImage = new RootImage(type, src, template.getMargin());
        if (this.productLabel == null) {
            this.productLabel = new Label(template.getProductTemplate());
        }
        rootImage.add(this.productLabel);
        if (this.versionLabel == null) {
            this.versionLabel = new Label(template.getVersionTemplate());
        }
        rootImage.add(this.versionLabel);
        if (this.legalLabel == null) {
            this.legalLabel = new Label(template.getLegalTemplate());
        }
        rootImage.add(this.legalLabel);
        int bottomX = 0;
        bottomX = isRTL ? rootImage.getMargin() : rootImage.getWidth() - rootImage.getMargin();
        int bottomY = rootImage.getHeight() - rootImage.getMargin();
        int xOffset = 0;
        if (hasJavaLogo) {
            Image javaLogo = new Image(LOGO_JAVA_SRC);
            if (!isRTL) {
                bottomX -= javaLogo.getWidth();
            }
            y = bottomY - javaLogo.getHeight();
            javaLogo.setCoordinate(bottomX, y);
            xOffset = 20;
            rootImage.add(javaLogo);
            if (isRTL) {
                bottomX += javaLogo.getWidth();
            }
        }
        if (hasEclipseLogo) {
            Image eclipseLogo = new Image(LOGO_ECLIPSE_SRC);
            bottomX = isRTL ? (bottomX += xOffset) : bottomX - eclipseLogo.getWidth() - xOffset;
            y = bottomY - eclipseLogo.getHeight();
            eclipseLogo.setCoordinate(bottomX, y);
            rootImage.add(eclipseLogo);
        }
        return rootImage;
    }

    public void init(Properties customProps) throws ExternalProcessException {
        String templateName = customProps.getProperty("template");
        this.props = new Properties();
        this.load(this.getDefaultProperties());
        this.load(this.getTemplateProperties(templateName));
        this.load(customProps);
        this.load(this.getMasterProperties());
        ImageGenerator.printLog(this.getClass(), "Initializing with the following properties: " + this.props);
        boolean hasEclipseLogo = "true".equals(this.getProperty("hasEclipseLogo"));
        boolean hasJavaLogo = "true".equals(this.getProperty("hasJavaLogo"));
        ImageTemplate imageTemplate = this.getImageTemplate(this.props);
        this.rootImage = this.buildRootImage(imageTemplate, hasEclipseLogo, hasJavaLogo, false);
        this.rootImage_rtl = this.buildRootImage(imageTemplate, hasEclipseLogo, hasJavaLogo, true);
    }

    private void load(Properties srcProperties) {
        if (srcProperties != null) {
            this.props.putAll((Map<?, ?>)srcProperties);
        }
    }

    protected Properties getTemplateProperties(String templateName) throws ExternalProcessException {
        return this.getProperties(templateName);
    }

    protected Properties getDefaultProperties() throws ExternalProcessException {
        return this.getProperties("default");
    }

    protected Properties getMasterProperties() throws ExternalProcessException {
        return this.getProperties("master");
    }

    private Properties getProperties(String type) throws ExternalProcessException {
        if (type != null) {
            Properties properties = this.propertiesCache.get(type);
            if (properties == null) {
                properties = new Properties();
                try {
                    properties.load(this.getClass().getResourceAsStream("templates/" + type + ".properties"));
                }
                catch (IOException e) {
                    throw new ExternalProcessException("Error loading properties: " + type, (Throwable)e);
                }
                this.propertiesCache.put(type, properties);
            }
            return properties;
        }
        return null;
    }

    public boolean generate(String locale, Properties msgProps, String targetFile) throws ExternalProcessException {
        ImageGenerator.printLog(this.getClass(), "Generating " + targetFile);
        this.messagesManager.initialize(msgProps);
        String product = this.getMessage("product");
        String version = this.getMessage("version");
        String legal = this.getMessage("legal");
        this.messagesManager.terminate();
        this.productLabel.setText(product);
        this.versionLabel.setText(version);
        this.legalLabel.setText(legal);
        if (locale.startsWith("ar") || locale.startsWith("he") || locale.startsWith("iw") || locale.startsWith("ur")) {
            this.rootImage_rtl.setLocaleRTL(true);
            this.rootImage_rtl.save(locale, targetFile);
        } else {
            this.rootImage.save(locale, targetFile);
        }
        return true;
    }

    protected String getMessage(String type) {
        String key = this.getProperty(type + ".msgId");
        String parms = this.getProperty(type + ".msgId.parms");
        if (parms != null) {
            return this.messagesManager.getMessage(key, parms.split(","));
        }
        return this.messagesManager.getMessage(key);
    }

    private LabelTemplate getLabelTemplate(Properties props, String type, LabelTemplate.Style style, Color color) {
        return new LabelTemplate(type, props, style, color);
    }

    private ImageTemplate getImageTemplate(Properties props) {
        String src = this.getProperty("src");
        String type = this.getProperty("type");
        int margin = Integer.parseInt(this.getProperty("margin"));
        LabelTemplate productTemplate = this.getLabelTemplate(props, "product", LabelTemplate.Style.PLAIN, Color.BLACK);
        LabelTemplate versionTemplate = this.getLabelTemplate(props, "version", LabelTemplate.Style.PLAIN, Color.BLACK);
        LabelTemplate legalTemplate = this.getLabelTemplate(props, "legal", LabelTemplate.Style.PLAIN, Color.GRAY);
        ImageTemplate imageTemplate = new ImageTemplate(type, src, margin, productTemplate, versionTemplate, legalTemplate);
        return imageTemplate;
    }

    public String getBaseName() {
        return this.getProperty("baseName");
    }

    public static void printLog(Class clazz, String log) {
        CCLMsgFile.printLog((String)(clazz.getName() + ": " + log));
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }
}

