/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit.extension.i18nimage;

import com.cognos.localizationkit.extension.i18nimage.ImageGenerator;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class LabelTemplate {
    private String type = null;
    private int style = 0;
    private Color defaultColor = null;
    private Properties props = null;

    public LabelTemplate(String type, Properties props, Style style, Color defaultColor) {
        this.type = type;
        this.props = props;
        this.style = style.equals((Object)Style.BOLD) ? 1 : 0;
        this.defaultColor = defaultColor;
    }

    public String getType() {
        return this.type;
    }

    public int getFontSize() {
        return Integer.parseInt(this.props.getProperty(this.type + ".size"));
    }

    public int getY() {
        return Integer.parseInt(this.props.getProperty(this.type + ".y"));
    }

    public int getStyle() {
        return this.style;
    }

    public Color getColor() {
        Color result = this.defaultColor;
        String colorValue = this.props.getProperty(this.type + ".color");
        if (colorValue == null || colorValue.isEmpty()) {
            colorValue = this.props.getProperty("color");
        }
        if (colorValue != null && !colorValue.isEmpty()) {
            result = Color.decode(colorValue);
        }
        return result;
    }

    public String getFont(String locale) {
        String font = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            boolean success = ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("fonts/Andalewt.ttf")));
            if (success) {
                ImageGenerator.printLog(this.getClass(), "Sucessfully registered font: Andalewt.ttf");
            } else {
                ImageGenerator.printLog(this.getClass(), "Unable to register font: Andalewt.ttf");
            }
        }
        catch (Exception e) {
            ImageGenerator.printLog(this.getClass(), "An error occuring registering font: Andalewt.ttf");
        }
        String fontNames = this.props.getProperty(this.type + ".font");
        if (fontNames == null) {
            fontNames = this.props.getProperty("font");
        }
        List<String> availableFonts = Arrays.asList(ge.getAvailableFontFamilyNames(new Locale(locale)));
        for (String fontName : fontNames.split("\\,")) {
            int idx = availableFonts.indexOf(fontName);
            if (idx == -1) continue;
            font = availableFonts.get(idx);
            break;
        }
        return font;
    }

    public static enum Style {
        PLAIN,
        BOLD;

    }
}

