/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit.extension.i18nimage;

import com.cognos.localizationkit.ExternalProcessException;
import com.cognos.localizationkit.extension.i18nimage.Image;
import com.cognos.localizationkit.extension.i18nimage.ImageContent;
import com.cognos.localizationkit.extension.i18nimage.ImageGenerator;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class RootImage
extends Image {
    private int margin = 0;
    private String type = null;
    private ArrayList<ImageContent> imageContents = new ArrayList();
    private Graphics2D g2d = null;
    private String locale = null;
    private boolean isLocaleRTL = false;

    public void setLocaleRTL(boolean isLocaleRTL) {
        this.isLocaleRTL = isLocaleRTL;
    }

    public boolean isLocaleRTL() {
        return this.isLocaleRTL;
    }

    public RootImage(String type, String src, int margin) throws ExternalProcessException {
        super(src, 0, 0);
        this.type = type;
        this.margin = margin;
    }

    public int getMargin() {
        return this.margin;
    }

    public String getLocale() {
        return this.locale;
    }

    public void save(String locale, String file) throws ExternalProcessException {
        this.locale = locale;
        int m_imgWidth = this.awtImage.getWidth(null);
        int m_imgHeight = this.awtImage.getHeight(null);
        BufferedImage bufImg = new BufferedImage(m_imgWidth, m_imgHeight, 1);
        this.g2d = bufImg.createGraphics();
        this.write(this);
        for (ImageContent imageContent : this.imageContents) {
            imageContent.write(this);
        }
        ImageGenerator.printLog(this.getClass(), "Writing file " + file);
        try {
            this.createParentDir(file);
            File image = new File(file);
            ImageIO.write((RenderedImage)bufImg, this.type, image);
        }
        catch (IOException e) {
            throw new ExternalProcessException("Error saving image to file: " + file, (Throwable)e);
        }
        ImageGenerator.printLog(this.getClass(), "Finished Writing file " + file);
    }

    public Graphics2D getGraphics() {
        return this.g2d;
    }

    public void add(ImageContent imageContent) {
        this.imageContents.add(imageContent);
    }
}

