/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.assembler;

import com.cognos.mobile.assembler.ASMTokenizer;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMHtmlHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.compiler.ReportCompiler;
import com.cognos.mobile.vm.IVMWriter;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOpcodeHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;

public class ASMAssembler {
    private static final char CHAR_QUOTE = '\"';
    private static String LABEL_SUFFIX = ":";
    private static String META_PREFIX = ".";
    private static Class CLASS = ASMAssembler.class;
    private static boolean wouldDebugLog = VM.wouldLog(CLASS, 0);
    private static final int LINE_INSTRUCTION = 0;
    private static final int LINE_LABEL = 1;
    private static final int LINE_META = 2;
    private static Instruction[] s_instructionTable;
    private static Map s_constantTable;
    protected ReportCompiler m_reportCompiler;
    private final boolean removeExtraSpaces;
    private int lineCount;
    private int pageCount;
    private int tableCount;
    private int errorCount;
    private IVMWriter writer;
    private Map m_symbolTable;
    private Map m_stringCache;
    static final int BYTE_ARRAY_INITIAL_CAPACITY = 1024;
    static final int RENDER_STRING_MAX_SIZE = 255;

    public ASMAssembler(boolean removeExtraSpaces, ReportCompiler reportCompiler) {
        this.removeExtraSpaces = removeExtraSpaces;
        this.m_reportCompiler = reportCompiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble(InputStream in, IVMWriter aWriter) throws CMException {
        BufferedReader reader;
        if (s_instructionTable == null || s_constantTable == null) {
            Class clazz = CLASS;
            synchronized (clazz) {
                if (s_instructionTable == null) {
                    this.buildInstructionTable();
                }
                if (s_constantTable == null) {
                    this.buildConstantTable();
                }
            }
        }
        VM.log(CLASS, 1, "assemble begin");
        long startTime = System.currentTimeMillis();
        this.lineCount = 0;
        this.pageCount = 0;
        this.tableCount = 0;
        this.errorCount = 0;
        this.writer = aWriter;
        this.m_symbolTable = new TreeMap();
        this.m_stringCache = new TreeMap();
        int address = this.writer.onWriterOpen();
        try {
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CMException(1002, new String[]{"UTF-8"}, "missing UTF-8 encoding");
        }
        if (wouldDebugLog) {
            VM.log(CLASS, 0, CMStringHelper.formatAddress(address) + ":");
        }
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (line == null) break;
            if (wouldDebugLog) {
                VM.log(CLASS, 0, line);
            }
            ++this.lineCount;
            try {
                Tokens tokens = new Tokens();
                this.parseLine(line, tokens);
                if (tokens.keyword == null) continue;
                int lineType = this.getLineType(tokens);
                switch (lineType) {
                    case 1: {
                        this.processLabel(address, tokens);
                        break;
                    }
                    case 0: {
                        address = this.processInstruction(address, tokens);
                        break;
                    }
                    case 2: {
                        address = this.processMeta(address, tokens);
                        break;
                    }
                    default: {
                        throw new CMException(1201, "syntax error");
                    }
                }
            }
            catch (CMException e) {
                String error = "line " + Integer.toString(this.lineCount) + ": " + e.getMessage();
                VM.log(CLASS, 3, error);
            }
            if (!wouldDebugLog) continue;
            VM.log(CLASS, 0, CMStringHelper.formatAddress(address) + ":");
        }
        this.writer.onWriterClose();
        if (this.errorCount > 0) {
            String error = "error count: " + Integer.toString(this.errorCount);
            VM.log(CLASS, 3, error);
        }
        long stopTime = System.currentTimeMillis();
        VM.log(CLASS, 1, "assemble end in " + Long.toString(stopTime - startTime) + "ms");
    }

    private void parseLine(String line, Tokens tokens) throws CMException {
        ASMTokenizer tokenizer = new ASMTokenizer();
        tokenizer.setString(line);
        String mnemonic = tokenizer.getNextToken();
        if (mnemonic == null) {
            return;
        }
        tokens.keyword = mnemonic;
        String p1 = tokenizer.getNextToken();
        if (p1 == null) {
            return;
        }
        tokens.p1 = p1;
        String p2 = tokenizer.getNextToken();
        if (p2 == null) {
            return;
        }
        tokens.p2 = p2;
        String extra = tokenizer.getNextToken();
        if (extra == null) {
            return;
        }
        throw new CMException(1202, "found extra text near '" + extra + "'");
    }

    private int getLineType(Tokens tokens) {
        if (tokens.keyword != null && tokens.keyword.endsWith(LABEL_SUFFIX)) {
            return 1;
        }
        if (tokens.keyword != null && tokens.keyword.startsWith(META_PREFIX)) {
            return 2;
        }
        return 0;
    }

    private void processLabel(int address, Tokens tokens) throws CMException {
        String name = tokens.keyword.substring(0, tokens.keyword.length() - LABEL_SUFFIX.length());
        this.insertSymbol(name, address, this.m_symbolTable);
    }

    private int processInstruction(int address, Tokens tokens) throws CMException {
        int opcode = -1;
        if (tokens.keyword == null || tokens.keyword.length() == 0) {
            throw new CMException(1202, "missing mnemonic");
        }
        int instruction = -1;
        for (int i = 0; i < s_instructionTable.length; ++i) {
            if (s_instructionTable[i] == null || ASMAssembler.s_instructionTable[i].mnemonic == null || !ASMAssembler.s_instructionTable[i].mnemonic.equals(tokens.keyword)) continue;
            instruction = i;
            break;
        }
        if (instruction == -1) {
            throw new CMException(1201, "invalid mnemonic: " + tokens.keyword);
        }
        int paramCount = 0;
        if (tokens.p1 != null) {
            ++paramCount;
        }
        if (tokens.p2 != null) {
            ++paramCount;
        }
        if (paramCount < ASMAssembler.s_instructionTable[instruction].minParamCount) {
            throw new CMException(1200, "missing parameters");
        }
        if (paramCount > ASMAssembler.s_instructionTable[instruction].maxParamCount) {
            VM.log(CLASS, 2, "extra parameters will be ignored");
        }
        switch (instruction) {
            case 73: {
                ++this.tableCount;
                if (paramCount != 0) break;
                tokens.p1 = "\"_table " + Integer.toString(this.tableCount) + '\"';
                VM.log(CLASS, 2, "set unamed table name: " + tokens.p1);
                break;
            }
            case 71: {
                ++this.pageCount;
                if (paramCount != 0) break;
                tokens.p1 = Integer.toString(this.pageCount);
                VM.log(CLASS, 2, "set unamed page: " + tokens.p1);
            }
        }
        Parameter p1 = this.processParameter(instruction, tokens.p1);
        Parameter p2 = this.processParameter(instruction, tokens.p2);
        opcode = VMOpcodeHelper.encodeOpcode(instruction, p1.mode, p2.mode);
        address = this.writer.onWriterWriteCode(opcode, p1.value, p2.value);
        return address;
    }

    private int processMeta(int address, Tokens tokens) throws CMException {
        if (tokens.p1 == null) {
            throw new CMException(1200, "meta is missing p1");
        }
        if (tokens.p2 != null) {
            throw new CMException(1200, "extra p2 parameter in meta");
        }
        int metaConstant = this.findSymbol(s_constantTable, tokens.keyword);
        Parameter p1 = new Parameter();
        p1.mode = 0;
        p1.value = metaConstant;
        Parameter p2 = this.processParameter(4, tokens.p1);
        int opcode = VMOpcodeHelper.encodeOpcode(4, p1.mode, p2.mode);
        address = this.writer.onWriterWriteCode(opcode, p1.value, p2.value);
        return address;
    }

    private void buildInstructionTable() {
        s_instructionTable = new Instruction[131];
        for (int i = 0; i < s_instructionTable.length; ++i) {
            ASMAssembler.s_instructionTable[i] = new Instruction();
        }
        ASMAssembler.s_instructionTable[87].mnemonic = "BackColor";
        ASMAssembler.s_instructionTable[87].minParamCount = 1;
        ASMAssembler.s_instructionTable[87].maxParamCount = 1;
        ASMAssembler.s_instructionTable[112].mnemonic = "BlockBegin";
        ASMAssembler.s_instructionTable[113].mnemonic = "BlockEnd";
        ASMAssembler.s_instructionTable[64].mnemonic = "BodyBegin";
        ASMAssembler.s_instructionTable[65].mnemonic = "BodyEnd";
        ASMAssembler.s_instructionTable[94].mnemonic = "BorderColor";
        ASMAssembler.s_instructionTable[94].minParamCount = 1;
        ASMAssembler.s_instructionTable[94].maxParamCount = 1;
        ASMAssembler.s_instructionTable[2].mnemonic = "Call";
        ASMAssembler.s_instructionTable[2].minParamCount = 1;
        ASMAssembler.s_instructionTable[2].maxParamCount = 1;
        ASMAssembler.s_instructionTable[96].mnemonic = "ChartBegin";
        ASMAssembler.s_instructionTable[97].mnemonic = "ChartEnd";
        ASMAssembler.s_instructionTable[93].mnemonic = "ClearStyle";
        ASMAssembler.s_instructionTable[93].minParamCount = 1;
        ASMAssembler.s_instructionTable[93].maxParamCount = 1;
        ASMAssembler.s_instructionTable[0].mnemonic = "End";
        ASMAssembler.s_instructionTable[85].mnemonic = "Font";
        ASMAssembler.s_instructionTable[85].minParamCount = 1;
        ASMAssembler.s_instructionTable[85].maxParamCount = 1;
        ASMAssembler.s_instructionTable[95].mnemonic = "Flow";
        ASMAssembler.s_instructionTable[95].minParamCount = 1;
        ASMAssembler.s_instructionTable[95].maxParamCount = 1;
        ASMAssembler.s_instructionTable[66].mnemonic = "FooterBegin";
        ASMAssembler.s_instructionTable[67].mnemonic = "FooterEnd";
        ASMAssembler.s_instructionTable[90].mnemonic = "GroupBegin";
        ASMAssembler.s_instructionTable[91].mnemonic = "GroupEnd";
        ASMAssembler.s_instructionTable[69].mnemonic = "HeaderBegin";
        ASMAssembler.s_instructionTable[70].mnemonic = "HeaderEnd";
        ASMAssembler.s_instructionTable[89].mnemonic = "Image";
        ASMAssembler.s_instructionTable[89].minParamCount = 1;
        ASMAssembler.s_instructionTable[89].maxParamCount = 2;
        ASMAssembler.s_instructionTable[100].mnemonic = "Label";
        ASMAssembler.s_instructionTable[100].minParamCount = 1;
        ASMAssembler.s_instructionTable[100].maxParamCount = 1;
        ASMAssembler.s_instructionTable[68].mnemonic = "NextLine";
        ASMAssembler.s_instructionTable[1].mnemonic = "Nop";
        ASMAssembler.s_instructionTable[71].mnemonic = "PageBegin";
        ASMAssembler.s_instructionTable[71].minParamCount = 0;
        ASMAssembler.s_instructionTable[71].maxParamCount = 1;
        ASMAssembler.s_instructionTable[72].mnemonic = "PageEnd";
        ASMAssembler.s_instructionTable[3].mnemonic = "Return";
        ASMAssembler.s_instructionTable[98].mnemonic = "SpotBegin";
        ASMAssembler.s_instructionTable[98].minParamCount = 2;
        ASMAssembler.s_instructionTable[98].maxParamCount = 2;
        ASMAssembler.s_instructionTable[123].mnemonic = "SpotIndex";
        ASMAssembler.s_instructionTable[123].minParamCount = 1;
        ASMAssembler.s_instructionTable[123].maxParamCount = 1;
        ASMAssembler.s_instructionTable[124].mnemonic = "SpotLeft";
        ASMAssembler.s_instructionTable[124].minParamCount = 1;
        ASMAssembler.s_instructionTable[124].maxParamCount = 1;
        ASMAssembler.s_instructionTable[125].mnemonic = "SpotUp";
        ASMAssembler.s_instructionTable[125].minParamCount = 1;
        ASMAssembler.s_instructionTable[125].maxParamCount = 1;
        ASMAssembler.s_instructionTable[126].mnemonic = "SpotRight";
        ASMAssembler.s_instructionTable[126].minParamCount = 1;
        ASMAssembler.s_instructionTable[126].maxParamCount = 1;
        ASMAssembler.s_instructionTable[127].mnemonic = "SpotDown";
        ASMAssembler.s_instructionTable[127].minParamCount = 1;
        ASMAssembler.s_instructionTable[127].maxParamCount = 1;
        ASMAssembler.s_instructionTable[99].mnemonic = "SpotEnd";
        ASMAssembler.s_instructionTable[73].mnemonic = "TableBegin";
        ASMAssembler.s_instructionTable[73].minParamCount = 0;
        ASMAssembler.s_instructionTable[73].maxParamCount = 1;
        ASMAssembler.s_instructionTable[80].mnemonic = "TableCell";
        ASMAssembler.s_instructionTable[80].minParamCount = 0;
        ASMAssembler.s_instructionTable[80].maxParamCount = 2;
        ASMAssembler.s_instructionTable[81].mnemonic = "TableEnd";
        ASMAssembler.s_instructionTable[82].mnemonic = "TableFreeze";
        ASMAssembler.s_instructionTable[82].minParamCount = 2;
        ASMAssembler.s_instructionTable[82].maxParamCount = 2;
        ASMAssembler.s_instructionTable[83].mnemonic = "TableRow";
        ASMAssembler.s_instructionTable[84].mnemonic = "Text";
        ASMAssembler.s_instructionTable[84].minParamCount = 1;
        ASMAssembler.s_instructionTable[84].maxParamCount = 1;
        ASMAssembler.s_instructionTable[88].mnemonic = "TextAlign";
        ASMAssembler.s_instructionTable[88].minParamCount = 1;
        ASMAssembler.s_instructionTable[88].maxParamCount = 1;
        ASMAssembler.s_instructionTable[86].mnemonic = "TextColor";
        ASMAssembler.s_instructionTable[86].minParamCount = 1;
        ASMAssembler.s_instructionTable[86].maxParamCount = 1;
        ASMAssembler.s_instructionTable[92].mnemonic = "SetStyle";
        ASMAssembler.s_instructionTable[92].minParamCount = 1;
        ASMAssembler.s_instructionTable[92].maxParamCount = 1;
        ASMAssembler.s_instructionTable[108].mnemonic = "DrillContextBegin";
        ASMAssembler.s_instructionTable[108].minParamCount = 0;
        ASMAssembler.s_instructionTable[108].maxParamCount = 1;
        ASMAssembler.s_instructionTable[109].mnemonic = "DrillContextEnd";
        ASMAssembler.s_instructionTable[109].minParamCount = 0;
        ASMAssembler.s_instructionTable[109].maxParamCount = 1;
        ASMAssembler.s_instructionTable[101].mnemonic = "DrillIndex";
        ASMAssembler.s_instructionTable[101].minParamCount = 1;
        ASMAssembler.s_instructionTable[101].maxParamCount = 1;
        ASMAssembler.s_instructionTable[102].mnemonic = "DrillParameter";
        ASMAssembler.s_instructionTable[102].minParamCount = 2;
        ASMAssembler.s_instructionTable[102].maxParamCount = 2;
        ASMAssembler.s_instructionTable[111].mnemonic = "DrillParameterMun";
        ASMAssembler.s_instructionTable[111].minParamCount = 1;
        ASMAssembler.s_instructionTable[111].maxParamCount = 1;
        ASMAssembler.s_instructionTable[103].mnemonic = "DrillTargetInfoBegin";
        ASMAssembler.s_instructionTable[103].minParamCount = 0;
        ASMAssembler.s_instructionTable[103].maxParamCount = 1;
        ASMAssembler.s_instructionTable[104].mnemonic = "DrillTargetInfoEnd";
        ASMAssembler.s_instructionTable[104].minParamCount = 0;
        ASMAssembler.s_instructionTable[104].maxParamCount = 1;
        ASMAssembler.s_instructionTable[105].mnemonic = "DrillCMPath";
        ASMAssembler.s_instructionTable[105].minParamCount = 1;
        ASMAssembler.s_instructionTable[105].maxParamCount = 1;
        ASMAssembler.s_instructionTable[110].mnemonic = "DrillLabel";
        ASMAssembler.s_instructionTable[110].minParamCount = 1;
        ASMAssembler.s_instructionTable[110].maxParamCount = 1;
        ASMAssembler.s_instructionTable[106].mnemonic = "DrillParamNameType";
        ASMAssembler.s_instructionTable[106].minParamCount = 2;
        ASMAssembler.s_instructionTable[106].maxParamCount = 2;
        ASMAssembler.s_instructionTable[107].mnemonic = "DrillSearchObject";
        ASMAssembler.s_instructionTable[107].minParamCount = 1;
        ASMAssembler.s_instructionTable[107].maxParamCount = 1;
        ASMAssembler.s_instructionTable[114].mnemonic = "BorderDisplay";
        ASMAssembler.s_instructionTable[114].minParamCount = 1;
        ASMAssembler.s_instructionTable[114].maxParamCount = 1;
        ASMAssembler.s_instructionTable[128].mnemonic = "BorderHorizontalColour";
        ASMAssembler.s_instructionTable[128].minParamCount = 2;
        ASMAssembler.s_instructionTable[128].maxParamCount = 2;
        ASMAssembler.s_instructionTable[129].mnemonic = "BorderVerticalColor";
        ASMAssembler.s_instructionTable[129].minParamCount = 2;
        ASMAssembler.s_instructionTable[129].maxParamCount = 2;
        ASMAssembler.s_instructionTable[115].mnemonic = "MailToBegin";
        ASMAssembler.s_instructionTable[115].minParamCount = 0;
        ASMAssembler.s_instructionTable[115].maxParamCount = 1;
        ASMAssembler.s_instructionTable[116].mnemonic = "MailToEnd";
        ASMAssembler.s_instructionTable[116].minParamCount = 0;
        ASMAssembler.s_instructionTable[116].maxParamCount = 1;
        ASMAssembler.s_instructionTable[117].mnemonic = "MailTo";
        ASMAssembler.s_instructionTable[117].minParamCount = 1;
        ASMAssembler.s_instructionTable[117].maxParamCount = 1;
        ASMAssembler.s_instructionTable[118].mnemonic = "MailToCC";
        ASMAssembler.s_instructionTable[118].minParamCount = 1;
        ASMAssembler.s_instructionTable[118].maxParamCount = 1;
        ASMAssembler.s_instructionTable[119].mnemonic = "MailToBCC";
        ASMAssembler.s_instructionTable[119].minParamCount = 1;
        ASMAssembler.s_instructionTable[119].maxParamCount = 1;
        ASMAssembler.s_instructionTable[120].mnemonic = "MailToSubBody";
        ASMAssembler.s_instructionTable[120].minParamCount = 2;
        ASMAssembler.s_instructionTable[120].maxParamCount = 2;
        ASMAssembler.s_instructionTable[121].mnemonic = "DrillUpDownContext";
        ASMAssembler.s_instructionTable[121].minParamCount = 0;
        ASMAssembler.s_instructionTable[121].maxParamCount = 1;
        ASMAssembler.s_instructionTable[122].mnemonic = "DrillWidget";
        ASMAssembler.s_instructionTable[122].minParamCount = 0;
        ASMAssembler.s_instructionTable[122].maxParamCount = 1;
        ASMAssembler.s_instructionTable[130].mnemonic = "Size";
        ASMAssembler.s_instructionTable[130].minParamCount = 1;
        ASMAssembler.s_instructionTable[130].maxParamCount = 2;
    }

    private void buildConstantTable() {
        s_constantTable = new TreeMap();
        this.insertSymbol(META_PREFIX + "Timestamp", 3, s_constantTable);
        this.insertSymbol(META_PREFIX + "Title", 2, s_constantTable);
        this.insertSymbol(META_PREFIX + "Version", 1, s_constantTable);
        this.insertSymbol(META_PREFIX + "GatewayUrl", 6, s_constantTable);
        this.insertSymbol(META_PREFIX + "CMPath", 7, s_constantTable);
        this.insertSymbol(META_PREFIX + "SourcePath", 5, s_constantTable);
        this.insertSymbol(META_PREFIX + "PageCount", 4, s_constantTable);
        this.insertSymbol(META_PREFIX + "STATUS", 8, s_constantTable);
        this.insertSymbol(META_PREFIX + "DRILLSTR", 9, s_constantTable);
        this.insertSymbol(META_PREFIX + "SourceCode", 16, s_constantTable);
        this.insertSymbol(META_PREFIX + "StoreID", 17, s_constantTable);
        this.insertSymbol(META_PREFIX + "ThumbnailSmall", 18, s_constantTable);
        this.insertSymbol(META_PREFIX + "Dashboard", 19, s_constantTable);
        this.insertSymbol(META_PREFIX + "Description", 20, s_constantTable);
        this.insertSymbol(META_PREFIX + "BURSTVALUE", 21, s_constantTable);
        this.insertSymbol("BOLD", 1, s_constantTable);
        this.insertSymbol("ITALIC", 4, s_constantTable);
        this.insertSymbol("NORMAL", 0, s_constantTable);
        this.insertSymbol("UNDERLINE", 2, s_constantTable);
        this.insertSymbol("CENTER", 2, s_constantTable);
        this.insertSymbol("LEFT", 0, s_constantTable);
        this.insertSymbol("RIGHT", 1, s_constantTable);
        this.insertSymbol("LEFTTORIGHT", 0, s_constantTable);
        this.insertSymbol("RIGHTTOLEFT", 1, s_constantTable);
        this.insertSymbol("SELECTOBJECT", 1, s_constantTable);
        this.insertSymbol("SELECTPAGE", 2, s_constantTable);
        this.insertSymbol("TABLELAYOUT", 4, s_constantTable);
        this.insertSymbol("DRILLTHROUGH", 8, s_constantTable);
        this.insertSymbol("MAILTO", 16, s_constantTable);
        this.insertSymbol("DRILLUP", 32, s_constantTable);
        this.insertSymbol("DRILLDOWN", 64, s_constantTable);
        this.insertSymbol("BOLD|UNDERLINE", 3, s_constantTable);
        this.insertSymbol("BOLD|ITALIC", 5, s_constantTable);
        this.insertSymbol("ITALIC|UNDERLINE", 6, s_constantTable);
        this.insertSymbol("BOLD|ITALIC|UNDERLINE", 7, s_constantTable);
    }

    private Parameter processParameter(int instruction, String string) throws CMException {
        Parameter p = new Parameter();
        if (string == null || string.length() == 0) {
            p.mode = -1;
            p.value = 0;
            return p;
        }
        if (string.charAt(0) == '\"') {
            if (string.charAt(string.length() - 1) != '\"') {
                throw new CMException(1202, "string literal missing end quote: " + string);
            }
            String literal = string.substring(1, string.length() - 1);
            if (this.removeExtraSpaces) {
                literal = literal.trim();
                StringBuffer clean = new StringBuffer(literal.length());
                for (int i = 0; i < literal.length(); ++i) {
                    char ch = literal.charAt(i);
                    if (Character.isSpaceChar(ch)) {
                        while (i < literal.length() - 1 && Character.isSpaceChar(literal.charAt(i + 1))) {
                            ++i;
                        }
                    }
                    clean.append(ch);
                }
                literal = clean.toString();
            }
            p.value = this.insertString(literal);
            p.mode = 0;
            return p;
        }
        if (string.startsWith("cid:") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("file://")) {
            p.value = this.insertImageBlob(instruction, string);
            p.mode = 0;
            return p;
        }
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            p.value = this.findSymbol(this.m_symbolTable, s_constantTable, string);
            p.mode = 0;
            return p;
        }
        if (Character.isDigit(string.charAt(0)) || '-' == string.charAt(0) && Character.isDigit(string.charAt(1))) {
            int literal;
            try {
                literal = CMStringHelper.parseIntegerLiteral(string);
            }
            catch (NumberFormatException e) {
                throw new CMException(1202, "invalid integer literal: " + string);
            }
            p.value = literal;
            p.mode = 0;
            return p;
        }
        throw new CMException(1200, "invalid parameter: " + string);
    }

    private void insertSymbol(String name, int value, Map table) {
        Symbol symbol = new Symbol();
        symbol.name = name;
        symbol.value = value;
        table.put(symbol.name, symbol);
    }

    private int insertString(String literal) throws CMException {
        Integer stringID = (Integer)this.m_stringCache.get(literal);
        if (stringID == null) {
            int rc = this.writer.onWriterWriteString(CMHtmlHelper.stripHtml(literal));
            stringID = new Integer(rc);
            this.m_stringCache.put(literal, stringID);
        }
        return stringID;
    }

    private int insertImageBlob(int instruction, String originalBlobUrl) throws CMException {
        Integer blobID = this.m_reportCompiler.storeImageResource(instruction, originalBlobUrl, this.writer).getBlobID();
        return blobID;
    }

    private int findSymbol(Map table, String name) throws CMException {
        Symbol symbol = (Symbol)table.get(name);
        if (symbol == null) {
            throw new CMException(1202, "unrecognized symbol: " + name);
        }
        return symbol.value;
    }

    private int findSymbol(Map table1, Map table2, String name) throws CMException {
        Symbol symbol = (Symbol)table1.get(name);
        if (symbol == null) {
            symbol = (Symbol)table2.get(name);
        }
        if (symbol == null) {
            throw new CMException(1202, "unrecognized symbol: " + name);
        }
        return symbol.value;
    }

    private static class Symbol {
        String name;
        int value;

        private Symbol() {
        }
    }

    private static class Parameter {
        int mode = -1;
        int value = 0;

        private Parameter() {
        }
    }

    private static class Instruction {
        String mnemonic;
        int minParamCount;
        int maxParamCount;

        private Instruction() {
        }
    }

    private static class Tokens {
        String keyword = null;
        String p1 = null;
        String p2 = null;

        private Tokens() {
        }
    }
}

