/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.assembler;

public class ASMTokenizer {
    private static final char CHAR_QUOTE = '\"';
    private static final char CHAR_COMMENT = ';';
    private static final char CHAR_BACKSLASH = '\\';
    private String m_string = null;
    private int m_currentChar = 0;

    public void setString(String string) {
        this.m_string = string;
        this.m_currentChar = 0;
    }

    public String getNextToken() {
        if (this.m_string == null) {
            return null;
        }
        if (this.m_currentChar >= this.m_string.length()) {
            return null;
        }
        String token = this.readNextToken();
        return token;
    }

    private String readNextToken() {
        boolean quote = false;
        StringBuffer token = new StringBuffer();
        while (this.m_currentChar < this.m_string.length() && Character.isWhitespace(this.m_string.charAt(this.m_currentChar))) {
            ++this.m_currentChar;
        }
        while (this.m_currentChar < this.m_string.length()) {
            char ch = this.m_string.charAt(this.m_currentChar);
            if (ch == '\"') {
                quote = !quote;
                token.append('\"');
            } else if (ch == '\\') {
                if (this.m_currentChar < this.m_string.length() - 1) {
                    token.append(this.m_string.charAt(this.m_currentChar + 1));
                }
                ++this.m_currentChar;
            } else if (quote) {
                token.append(ch);
            } else {
                if (Character.isWhitespace(ch) || ch == ';') break;
                token.append(ch);
            }
            ++this.m_currentChar;
        }
        if (token.length() == 0) {
            return null;
        }
        return token.toString();
    }
}

