/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.assembler;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.IVMReader;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMMemDatabase;
import java.io.FileInputStream;
import java.lang.reflect.Field;

public class DASMMain {
    private static Field[] fields = VM.class.getDeclaredFields();

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            System.out.println("File: '" + args[0] + "'");
            FileInputStream fis = new FileInputStream(args[0]);
            final VMMemDatabase db = VMMemDatabase.fromInputStream(fis);
            fis.close();
            db.print(System.out, new IVMReader.Formatter(){

                @Override
                public String format(IVMReader.CodeRecord codeRecord) {
                    try {
                        StringBuffer sb = new StringBuffer();
                        sb.append(CMStringHelper.formatAddress(codeRecord.address));
                        sb.append(":\t");
                        if (codeRecord.opcode == 84) {
                            sb.append("INT_TEXT\t\"");
                            sb.append(db.onReaderLoadString(codeRecord.p1));
                            sb.append("\"");
                        } else if (codeRecord.opcode == 4) {
                            sb.append("INT_META\t");
                            sb.append(this.decode(codeRecord.p1, "P1"));
                            sb.append("\t");
                            sb.append(db.onReaderLoadString(codeRecord.p2));
                        } else {
                            sb.append(this.decode(codeRecord.opcode, "INT"));
                            sb.append("\t");
                            sb.append(codeRecord.p1);
                            sb.append("\t");
                            sb.append(codeRecord.p2);
                        }
                        return sb.toString();
                    }
                    catch (Throwable t) {
                        return t.toString();
                    }
                }

                @Override
                public String format(IVMReader.StringRecord stringRecord) {
                    return IVMReader.PrintFormatter.format(stringRecord);
                }

                @Override
                public String format(IVMReader.BlobRecord blobRecord) {
                    return IVMReader.PrintFormatter.format(blobRecord);
                }

                private String decode(int code, String prefix) throws IllegalAccessException {
                    for (int i = 0; i < fields.length; ++i) {
                        if (!fields[i].getName().startsWith(prefix) || fields[i].getType() != Integer.TYPE || fields[i].getInt(null) != code) continue;
                        return fields[i].getName();
                    }
                    return Integer.toHexString(code);
                }
            });
        } else {
            System.out.println("Pass the name of a .db file as an argument.");
        }
    }
}

