/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.builder;

import com.cognos.mobile.builder.DemoSettings;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.standardedition.FileHelper;
import com.cognos.mobile.standardedition.JarHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Manifest;

public class DemoJarHelper {
    public static final int CHUNK_SIZE = 102400;

    public static void buildJarContents(DemoSettings demoSettings, String[] files, String tempDir) throws CMException {
        try {
            String contentsDir = tempDir + "contents/";
            String classDir = contentsDir + "com/cognos/mobile/rimclient/demo/";
            FileHelper.makeDir(classDir);
            FileHelper.copyFileToDir("../../prod/swt/DEMOLoader.class", classDir, System.out);
            String resDir = contentsDir + "res/";
            FileHelper.makeDir(resDir);
            FileHelper.copyFileToDir(tempDir + "index.txt", resDir, System.out);
            FileHelper.copyFileToDir(tempDir + "demo.prop", resDir, System.out);
            for (int i = 0; i < files.length; ++i) {
                File file = new File(demoSettings.inputDir + files[i]);
                if (file.length() > 102400L) {
                    FileInputStream in = new FileInputStream(file);
                    int count = (int)(file.length() / 102400L) + 1;
                    int index = file.getName().indexOf(".dbz");
                    if (index == -1) {
                        throw new CMException(1000, "unsupported db file format.");
                    }
                    for (int j = 0; j < count; ++j) {
                        int l;
                        FileOutputStream out = new FileOutputStream(resDir + "/" + files[i].substring(0, index) + "-" + j + ".dbz");
                        byte[] buff = new byte[1024];
                        int read = 0;
                        while ((l = in.read(buff)) > 0) {
                            out.write(buff, 0, l);
                            if ((read += l) < 102400) continue;
                        }
                        out.close();
                    }
                    in.close();
                    continue;
                }
                FileHelper.copyFileToDir(demoSettings.inputDir + files[i], resDir, System.out);
            }
            String metaInfDir = contentsDir + "META-INF/";
            FileHelper.makeDir(metaInfDir);
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
            manifest.getMainAttributes().putValue("MIDlet-Name", "Cognos Mobile Demo Inbox");
            manifest.getMainAttributes().putValue("MIDlet-Version", "11.2.2.2.7");
            manifest.getMainAttributes().putValue("MIDlet-Vendor", "Cognos, Inc.");
            manifest.getMainAttributes().putValue("MicroEdition-Profile", "MIDP-2.0");
            manifest.getMainAttributes().putValue("MicroEdition-Configuration", "CLDC-1.1");
            FileOutputStream f = new FileOutputStream(metaInfDir + "MANIFEST.MF");
            manifest.write(f);
            f.close();
        }
        catch (IOException ex) {
            throw new CMException(1000, "Failed to build jar contents.", (Throwable)ex);
        }
    }

    public static String createJarFile(String tempDir) throws CMException {
        try {
            System.out.println("Creating jar...");
            String jarPath = tempDir + "cognos_mobile_demo.jar";
            JarHelper jarHelper = new JarHelper(System.out);
            jarHelper.jarDirectory(jarPath, tempDir + "contents/");
            if (!FileHelper.fileExists(jarPath)) {
                throw new CMException(1000, "The jar file '" + jarPath + "' was not created.");
            }
            return jarPath;
        }
        catch (IOException ex) {
            throw new CMException(1000, "Error while creating jar file.", (Throwable)ex);
        }
    }
}

