/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.builder;

import com.cognos.mobile.builder.BuilderHelper;
import com.cognos.mobile.builder.SettingsBuilder;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.StreamHelper;
import com.cognos.mobile.standardedition.FileHelper;
import com.cognos.mobile.standardedition.JarHelper;
import com.cognos.mobile.standardedition.ProcessHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;

public class RIMSettingsBuilder
extends SettingsBuilder {
    private static final String COD_NAME = "cognos_mobile_settings";
    private static final String[] MANDATORY_FILES = new String[]{"bin/rapc.exe", "bin/rapc.jar"};
    private static final String[] MANIFEST = new String[]{"MIDlet-Name: Cognos Mobile Settings", "MIDlet-Version: %VERSION%", "MIDlet-Vendor: %VENDOR%", "MicroEdition-Profile: MIDP-2.0", "MicroEdition-Configuration: CLDC-1.1"};
    private static final String[] JAD_PROPERTIES = new String[]{"MIDlet-Name: Cognos Mobile Settings", "MIDlet-Version: %VERSION%", "MIDlet-Vendor: %VENDOR%", "MicroEdition-Profile: MIDP-2.0", "MicroEdition-Configuration: CLDC-1.1", "RIM-MIDlet-Flags-1: 0", "RIM-COD-Module-Dependencies: cognos_mobile", "MIDlet-Jar-URL: cognos_mobile_settings.jar", "MIDlet-Jar-Size: %JARSIZE%"};

    @Override
    public final String getPlatform() {
        return "BlackBerry";
    }

    @Override
    public String buildSettings(Hashtable settings) throws Exception {
        RIMSettingsBuilder.log("\n\nConfiguring the BlackBerry client...\n");
        if (!BuilderHelper.isWindows()) {
            throw new CMException(1000, "BlackBerry files can only be built on Windows machines; please install the Administration Tools on a Windows machine.");
        }
        BuilderHelper.checkForMandatoryFiles(RIMSettingsBuilder.getC8Dir(), MANDATORY_FILES);
        RIMSettingsBuilder.log("Creating temporary directories...");
        String tempDir = RIMSettingsBuilder.makeDirectories();
        PrintStream out = new PrintStream(new FileOutputStream(tempDir + "/config/server.properties"));
        StreamHelper.saveAsProperties(settings, out, "=");
        out.close();
        this.createManifest(tempDir);
        String jarPath = RIMSettingsBuilder.getC8Dir() + "/configuration/mobile/" + COD_NAME + ".jar";
        RIMSettingsBuilder.log("Building " + jarPath);
        FileHelper.deleteFiles(jarPath);
        JarHelper jarHelper = new JarHelper(System.err);
        jarHelper.jarDirectory(jarPath, tempDir);
        RIMSettingsBuilder.log("Building " + RIMSettingsBuilder.getC8Dir() + "/configuration/mobile/" + COD_NAME + ".jad");
        this.createJadFile(RIMSettingsBuilder.getC8Dir() + "/configuration/mobile/");
        RIMSettingsBuilder.log("Compiling settings file...");
        String codPath = this.compileJar(jarPath, tempDir, COD_NAME);
        RIMSettingsBuilder.log("Successfully compiled settings to: " + codPath);
        FileHelper.deleteFiles(jarPath);
        RIMSettingsBuilder.log("Copying " + codPath + " to the configuration directory...");
        FileHelper.copyFileToDir(codPath, RIMSettingsBuilder.getC8Dir() + "/configuration/mobile", null);
        RIMSettingsBuilder.log("Successfully copied " + codPath + " to: " + RIMSettingsBuilder.getC8Dir() + "/configuration/mobile");
        codPath = RIMSettingsBuilder.getC8Dir() + "/configuration/mobile/" + COD_NAME + ".cod";
        RIMSettingsBuilder.log("\n\nSuccessfully built new BlackBerry settings file:\n" + codPath + "\n\n");
        return codPath;
    }

    private void createManifest(String workingDir) throws CMException {
        PrintWriter manifestWriter = null;
        File manifestDir = new File(workingDir + "/META-INF");
        if (!manifestDir.exists()) {
            manifestDir.mkdir();
        }
        try {
            manifestWriter = new PrintWriter(new FileWriter(workingDir + "/META-INF/MANIFEST.MF"));
            for (int i = 0; i < MANIFEST.length; ++i) {
                String line = MANIFEST[i];
                line = line.replaceAll("%VENDOR%", "IBM Corp.");
                line = line.replaceAll("%VERSION%", "11.2.2.2.7");
                manifestWriter.println(line);
            }
        }
        catch (IOException ex) {
            throw new CMException(1000, "failed to create manifest file", (Throwable)ex);
        }
        finally {
            if (manifestWriter != null) {
                manifestWriter.close();
            }
        }
    }

    private void createJadFile(String workingDir) throws CMException {
        try (PrintWriter jadWriter = null;){
            File jar = new File(workingDir + "/" + COD_NAME + ".jar");
            long jarSize = jar.length();
            jadWriter = new PrintWriter(new FileWriter(workingDir + "/" + COD_NAME + ".jad"));
            for (int i = 0; i < JAD_PROPERTIES.length; ++i) {
                String line = JAD_PROPERTIES[i];
                line = line.replaceAll("%VENDOR%", "IBM Corp.");
                line = line.replaceAll("%VERSION%", "11.2.2.2.7");
                line = line.replaceAll("%JARSIZE%", Long.toString(jarSize));
                jadWriter.println(line);
            }
        }
    }

    private String compileJar(String jarPath, String workingDir, String codName) throws CMException {
        int rc;
        String rapcPath = CMStringHelper.quoteStringLiteral(RIMSettingsBuilder.getC8Dir() + "/bin/rapc.exe");
        String netRimPath = CMStringHelper.quoteStringLiteral(RIMSettingsBuilder.getC8Dir() + "/bin/net_rim_api.jar");
        jarPath = CMStringHelper.quoteStringLiteral(jarPath);
        String jadPath = jarPath.replaceAll(".jar", ".jad");
        String[] command = new String[]{rapcPath, "-quiet", "import=\"" + netRimPath + "\"", "jad=\"" + jadPath + "\"", "codename=" + codName, jarPath};
        try {
            rc = ProcessHelper.runProcess(command, workingDir);
        }
        catch (IOException ex) {
            throw new CMException(1000, "failed to launch rapc.exe; please re-install the Administration Tools", (Throwable)ex);
        }
        if (rc != 0) {
            throw new CMException(1000, "rapc returned error code " + rc);
        }
        String codPath = workingDir + "/" + codName + ".cod";
        File codFile = new File(codPath);
        if (!codFile.exists()) {
            throw new CMException(1000, "failed to find file: " + codPath);
        }
        return codPath;
    }
}

