/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.builder;

import com.cognos.mobile.builder.DemoJarHelper;
import com.cognos.mobile.builder.DemoSettings;
import com.cognos.mobile.builder.IDemoBuilder;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.standardedition.FileHelper;
import com.cognos.mobile.standardedition.ProcessHelper;
import com.cognos.mobile.standardedition.TemplateHelper;
import java.io.File;
import java.io.IOException;

public class RimDesktopDemoBuilder
implements IDemoBuilder {
    public static final String CODNAME = "cognos_mobile_demo";
    public static final String CORE_CODNAME = "cognos_mobile";
    public static final String SETTINGS_CODNAME = "cognos_mobile_settings";
    private static final String QUOTE = "\"";
    private String version = "4.1";

    public RimDesktopDemoBuilder(String version) {
        this.version = version;
    }

    @Override
    public boolean needsIndexFile() {
        return true;
    }

    @Override
    public void buildDemo(DemoSettings demoSettings, String[] files, String tempDir, String outputDir) throws CMException {
        System.out.println("--- RIM Desktop ---");
        DemoJarHelper.buildJarContents(demoSettings, files, tempDir);
        FileHelper.copyFiles(demoSettings.outputDir + "_common", tempDir + "contents/res/", System.out);
        String jarPath = DemoJarHelper.createJarFile(tempDir);
        String codPath = this.compileCodFile(tempDir, jarPath, demoSettings);
        String alxPath = this.buildAlxFile("template.demo.alx", outputDir + CODNAME + ".alx");
        System.out.println("- " + alxPath);
        FileHelper.copyFileToDir(codPath, outputDir, System.out);
        String workingDir = "";
        if (!FileHelper.fileExists("cognos_mobile_template_" + this.version + ".cod")) {
            workingDir = "../_inst/tools/";
        }
        FileHelper.copyFileToFile(workingDir + "cognos_mobile_template_" + this.version + ".cod", outputDir + CORE_CODNAME + ".cod", System.out);
        FileHelper.copyFileToFile(workingDir + "cognos_mobile_settings_template_" + this.version + ".cod", outputDir + SETTINGS_CODNAME + ".cod", System.out);
    }

    private String compileCodFile(String tempDir, String jarPath, DemoSettings demoSettings) throws CMException {
        int rc;
        String jadPath = tempDir + CODNAME + ".jad";
        FileHelper.copyFileToFile("demo_original.jad", jadPath, System.out);
        String command = QUOTE + demoSettings.rapcExe + "\" import=\"" + demoSettings.netRimApi + "\" codename=" + CODNAME + " jad=" + QUOTE + jadPath + QUOTE + " " + QUOTE + jarPath + QUOTE;
        try {
            rc = ProcessHelper.runProcess(command, ".");
        }
        catch (IOException ex) {
            throw new CMException(1000, "Failed to launch rapc.exe (command was '" + command + "').", (Throwable)ex);
        }
        if (rc != 0) {
            throw new CMException(1000, "rapc.exe returned error code " + rc + " (command was '" + command + "')");
        }
        if (!FileHelper.fileExists("cognos_mobile_demo.cod")) {
            throw new CMException(1000, "Failed to generate cognos_mobile_demo.cod file (command was '" + command + "'.");
        }
        String codPath = tempDir + CODNAME + ".cod";
        FileHelper.copyFileToFile("cognos_mobile_demo.cod", codPath, System.out);
        FileHelper.deleteFiles("cognos_mobile_demo.cod");
        return codPath;
    }

    private String buildAlxFile(String templatePath, String alxPath) throws CMException {
        try {
            File templateFile = new File(templatePath);
            if (!templateFile.exists()) {
                throw new CMException(1000, "Unable to find template file: " + templatePath);
            }
            File alxFile = new File(alxPath);
            alxFile.createNewFile();
            String version = "11.2.2.2.7";
            String[] fileList = new String[]{"cognos_mobile.cod\r\n", "cognos_mobile_settings.cod\r\n", "cognos_mobile_demo.cod\r\n"};
            StringBuffer fileListString = new StringBuffer();
            for (int i = 0; i < fileList.length; ++i) {
                fileListString.append(fileList[i]);
            }
            TemplateHelper.substituteKeywords(templateFile, alxFile, new String[]{"%VERSION%", "%FILES_LIST%"}, new String[]{version, fileListString.toString()});
        }
        catch (IOException ex) {
            throw new CMException(1000, "Failed to generate *.alx file", (Throwable)ex);
        }
        return alxPath;
    }
}

